/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.makumba.commons.MakumbaTLDGenerator;
import org.makumba.commons.StringUtils;

public class TLD2Forest {
    private static final int CREATE = 1;
    private static final int UPDATE = 2;
    private static final int BOTH = 3;
    private static final String EXAMPLE_SECTION_ID = "example";
    private static String errorMsg;
    private static HashMap<String, Element> processedTags;
    private static final String[] attributeTags;
    private static final String[] attributeClassesAlignment;
    private static final String[][] attributeHighlightValues;
    private static final String[][] genericAttributes;
    private static final String[] attributeHighlightClasses;
    private static String genericAttributeName;
    private static int genericAttributesCount;
    private static Element genericAttributeFirstRow;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Arguments needed: [path to the TLD file] [path to the output directory of example XMLs] [path to the output directory of taglib XMLs for Forrest]  (absolute paths)");
        }
        String tldFilePath = args[0];
        errorMsg = "Error processing '" + tldFilePath + "': ";
        String exampleDirectory = args[1];
        String taglibDirectory = args[2];
        int action = 1;
        if (args.length == 4) {
            String s = args[3];
            try {
                int parsedAction = Integer.parseInt(s);
                if (!s.equals("create") && !s.equals("update") && parsedAction != 1 && parsedAction != 2 && parsedAction != 3) {
                    System.err.println("args[2] must be 'create', 'update', 'both', '1', '2' or '3' ");
                    return;
                }
                action = s.equals("create") ? 1 : (s.equals("update") ? 2 : (s.equals("both") ? 3 : parsedAction));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("continuing with creating new files");
            }
        }
        if (action == 1 || action == 3) {
            System.out.println("doing STEP 1");
            TLD2Forest.generateAllTagFiles(tldFilePath, taglibDirectory);
            TLD2Forest.generateAllTagExampleFiles(tldFilePath, exampleDirectory);
        }
        if (action == 2 || action == 3) {
            System.out.println("doing STEP 2");
            TLD2Forest.generateAllTagsWithExampleFile2(tldFilePath, taglibDirectory, exampleDirectory);
        }
    }

    public static void generateAllTagFiles(String tldFileDirectory, String taglibDirectory) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(new File(tldFileDirectory));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.getName().equals("tag") && !e.getName().equals("function")) continue;
            TLD2Forest.generateTagFile(taglibDirectory, e);
        }
    }

    public static void generateAllTagExampleFiles(String tldFileDirectory, String exampleDirectory) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(new File(tldFileDirectory));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.getName().equals("tag")) continue;
            TLD2Forest.generateTagExampleFile(exampleDirectory, e.elementText("name"));
        }
    }

    public static String generateTagFile(String taglibDirectory, Element tag) {
        String tagName = tag.elementText("name");
        String tagFilePath = taglibDirectory + File.separator + "mak" + tagName + ".xml";
        System.out.println("TLD2Forest.generateTagFile(): file name -" + tagFilePath);
        Document tagXML = DocumentHelper.createDocument();
        Element docElement = tagXML.addElement("document");
        Element headerElement = docElement.addElement("header");
        Element titleElement = headerElement.addElement("title");
        if (tag.getName().equals("tag")) {
            titleElement.setText("mak:" + tagName + " tag documentation");
        } else {
            titleElement.setText("mak:" + tagName + "() function documentation");
        }
        Element bodyElement = docElement.addElement("body");
        Element infoSection = bodyElement.addElement("section");
        infoSection.addAttribute("id", "description");
        Element infoSectionTitle = infoSection.addElement("title");
        infoSectionTitle.setText("Description");
        Element description = infoSection.addElement("p");
        description.addAttribute("class", "tagDescription");
        String desc = new String();
        String see = new String();
        Iterator tagElementIter = tag.elementIterator();
        while (tagElementIter.hasNext()) {
            Element tagElement = (Element)tagElementIter.next();
            if (tagElement.getName().equals("description")) {
                desc = tagElement.getText();
            }
            if (!tagElement.getName().equals("see")) continue;
            see = tagElement.getText();
        }
        if (desc.trim().length() != 0) {
            description.setText(desc);
        } else {
            description.setText("FIXME: no description for this tag in taglib-documented.xml!");
        }
        Element sectionElement = bodyElement.addElement("section");
        sectionElement.addAttribute("id", "attributes");
        Element titleElement2 = sectionElement.addElement("title");
        if (tag.getName().equals("tag")) {
            titleElement2.setText("Attributes");
            if (TLD2Forest.hasAttributes(tag, "attribute")) {
                Element table = sectionElement.addElement("table");
                Element headerRow = table.addElement("tr");
                headerRow.addElement("th").setText("Name");
                headerRow.addElement("th").setText("Required");
                headerRow.addElement("th").setText("Request-time");
                headerRow.addElement("th").setText("Description");
                headerRow.addElement("th").setText("Comments");
                Iterator tagElementIter2 = tag.elementIterator();
                while (tagElementIter2.hasNext()) {
                    Element tagElement = (Element)tagElementIter2.next();
                    if (!tagElement.getName().equals("attribute")) continue;
                    if (tagElement.attributeValue("name") != null || tagElement.attributeValue("specifiedIn") != null) {
                        Element attribute = MakumbaTLDGenerator.getReferencedAttributes(processedTags, errorMsg, tag, tagName, tagElement);
                        TLD2Forest.processAttribute(table, attribute);
                        continue;
                    }
                    TLD2Forest.processAttribute(table, tagElement);
                }
                TLD2Forest.modifyGenericAttributeFirstRow();
                genericAttributeName = null;
                genericAttributeFirstRow = null;
                genericAttributesCount = 0;
            } else {
                sectionElement.addElement("p").setText("This tag has no attributes");
            }
        }
        Element exampleSection = bodyElement.addElement("section");
        exampleSection.addAttribute("id", EXAMPLE_SECTION_ID);
        exampleSection.addElement("title");
        if (see.length() != 0) {
            see = see.trim();
            Element seeAlsoSection = bodyElement.addElement("section");
            seeAlsoSection.addAttribute("id", "seeAlso");
            Element seeAlsoSectionTitle = seeAlsoSection.addElement("title");
            seeAlsoSectionTitle.setText("See also");
            Element seeAlso = seeAlsoSection.addElement("ul");
            String links = new String();
            StringTokenizer st = new StringTokenizer(see, ",");
            while (st.hasMoreTokens()) {
                String reference = st.nextToken().trim();
                List referredElement = (List)tag.getDocument().getRootElement().selectObject("//taglib//tag['@name=" + reference + "']");
                if (referredElement == null) {
                    throw new RuntimeException("Error: see also reference " + reference + " in tag definition " + tagName + " does not exist.");
                }
                Element refElement = seeAlso.addElement("li");
                Element link = refElement.addElement("a");
                link.addAttribute("href", "/doc/taglib/mak" + reference + ".html");
                link.setText("mak:" + reference);
            }
            seeAlso.setText(links);
        }
        System.out.println("Writing XML for tag " + tagName + " at path " + tagFilePath);
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(tagFilePath)), new OutputFormat("  ", true));
            output.write(tagXML);
            output.close();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        processedTags.put(tagName, tag);
        return tagFilePath;
    }

    private static boolean hasAttributes(Element tag, String attributeName) {
        for (Element e : tag.elements()) {
            if (!e.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    private static void processAttribute(Element table, Element tagElement) {
        int cellAddedCount = 0;
        Element tr = table.addElement("tr");
        boolean isDeprecated = TLD2Forest.isDeprecated(tagElement);
        if (isDeprecated) {
            tr.addAttribute("class", "deprecated");
        }
        Element[] elements = new Element[attributeTags.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = TLD2Forest.getChildElement(tagElement, attributeTags[i]);
        }
        String thisGenericAttributeName = null;
        for (String[] generic : genericAttributes) {
            if (!generic[0].equals(elements[3].getTextTrim()) || !generic[1].equals(elements[4].getTextTrim())) continue;
            thisGenericAttributeName = generic[0];
            if (genericAttributeName == null) {
                genericAttributeName = thisGenericAttributeName;
                genericAttributeFirstRow = tr;
                genericAttributesCount = 1;
                continue;
            }
            if (genericAttributeName.equals(thisGenericAttributeName)) {
                ++genericAttributesCount;
                continue;
            }
            TLD2Forest.modifyGenericAttributeFirstRow();
            genericAttributeFirstRow = tr;
            genericAttributesCount = 1;
        }
        if (thisGenericAttributeName == null && genericAttributeName != null) {
            System.out.println("change of generic attribute: " + thisGenericAttributeName);
            TLD2Forest.modifyGenericAttributeFirstRow();
            genericAttributeName = null;
            genericAttributeFirstRow = null;
            genericAttributesCount = 0;
        }
        for (int i = 0; i < elements.length; ++i) {
            String elementText;
            if (genericAttributesCount > 1 && (i == 3 || i == 4)) continue;
            Element dataElement = elements[i];
            String attributeName = attributeTags[i];
            Element td = tr.addElement("td");
            StringBuffer cssClasses = new StringBuffer();
            if (isDeprecated) {
                TLD2Forest.appendClass(cssClasses, "deprecated");
            }
            String string = elementText = dataElement != null ? dataElement.getText() : "FIXME";
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)attributeClassesAlignment[i])) {
                TLD2Forest.appendClass(cssClasses, attributeClassesAlignment[i]);
            }
            if (StringUtils.equalsAny(elementText, attributeHighlightValues[i])) {
                TLD2Forest.appendClass(cssClasses, attributeHighlightClasses[i]);
            }
            if (isDeprecated && attributeName.equals("name")) {
                elementText = elementText + " (deprecated)";
            }
            td.setText(elementText);
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)cssClasses.toString())) {
                td.addAttribute("class", cssClasses.toString());
            }
            ++cellAddedCount;
        }
    }

    private static void modifyGenericAttributeFirstRow() {
        if (genericAttributesCount > 1) {
            List elements2 = genericAttributeFirstRow.elements();
            ((Element)elements2.get(3)).addAttribute("rowspan", String.valueOf(genericAttributesCount));
            ((Element)elements2.get(4)).addAttribute("rowspan", String.valueOf(genericAttributesCount));
            ((Element)elements2.get(3)).addAttribute("class", "generic");
            ((Element)elements2.get(4)).addAttribute("class", "generic");
        }
    }

    private static void appendClass(StringBuffer cssClasses, String cssClass) {
        if (cssClasses.length() > 0) {
            cssClasses.append(" ");
        }
        cssClasses.append(cssClass);
    }

    private static boolean isDeprecated(Element e) {
        Iterator tagElementAttributeIter = e.elementIterator();
        while (tagElementAttributeIter.hasNext()) {
            Element dataElement = (Element)tagElementAttributeIter.next();
            if (!dataElement.getName().equals("deprecated")) continue;
            return org.apache.commons.lang.StringUtils.equals((String)dataElement.getText(), (String)"true");
        }
        return false;
    }

    private static Element getChildElement(Element e, String name) {
        for (Element dataElement : e.elements()) {
            if (!dataElement.getName().equals(name)) continue;
            return dataElement;
        }
        return null;
    }

    public static String generateTagExampleFile(String exampleDirectory, String tagName) {
        String exampleFilePath = exampleDirectory + File.separator + "mak" + tagName + "Example" + ".xml";
        File f = new File(exampleFilePath);
        if (!f.exists()) {
            Document exampleXML = DocumentHelper.createDocument();
            Element exampleSection = exampleXML.addElement("section");
            exampleSection.addAttribute("id", EXAMPLE_SECTION_ID);
            Element exampleTitle = exampleSection.addElement("title");
            exampleTitle.setText("Example");
            Element exampleTextParagraph = exampleSection.addElement("p");
            exampleTextParagraph.setText("");
            Element exampleCodeParagraph = exampleSection.addElement("p");
            Element exampleCode = exampleCodeParagraph.addElement("code");
            exampleCode.setText("");
            try {
                boolean success;
                if (!new File(exampleDirectory).exists() && (success = new File(exampleDirectory).mkdir())) {
                    System.out.println("Directory: " + exampleDirectory + " created");
                }
                XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(exampleFilePath)), new OutputFormat("  ", true));
                output.write(exampleXML);
                output.close();
            }
            catch (IOException e1) {
                System.out.println(e1.getMessage());
            }
        }
        return exampleFilePath;
    }

    public static String generateAllTagsWithExampleFile2(String tldFilePath, String taglibDirectory, String exampleDirectory) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(new File(tldFilePath));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element root = document.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.getName().equals("tag") && !e.getName().equals("function")) continue;
            TLD2Forest.generateTagWithExampleFile(taglibDirectory, exampleDirectory, e);
        }
        return null;
    }

    public static void generateTagWithExampleFile(String tagsDir, String exampleDir, Element tag) {
        String tagName = tag.elementText("name");
        SAXReader saxReader = new SAXReader();
        String tagFileName = "mak" + tagName + ".xml";
        String tagFilePath = tagsDir + File.separator + tagFileName;
        String exampleFileName = "mak" + tagName + "Example" + ".xml";
        String exampleFilePath = exampleDir + File.separator + exampleFileName;
        File exampleFile = new File(exampleFilePath);
        if (exampleFile.exists()) {
            try {
                Document exampleXML = saxReader.read(exampleFile);
                DefaultElement exampleSection = (DefaultElement)exampleXML.getRootElement().selectObject("//section");
                Document tagXML = saxReader.read(new File(tagFilePath));
                tagXML.addDocType("document", "-//MAKUMBA//DTD Documentation V2.0//EN", "document-v20-mak.dtd");
                Element tagRoot = tagXML.getRootElement();
                Element tagExampleSection = null;
                List l = (List)tagRoot.selectObject("//document//body//section");
                if (l.size() > 0) {
                    for (Element el : l) {
                        if (!EXAMPLE_SECTION_ID.equals(el.attributeValue("id"))) continue;
                        System.out.println("writing file " + tagFilePath);
                        tagExampleSection = el;
                        Element parent = tagExampleSection.getParent();
                        parent.remove(tagExampleSection);
                        parent.add((Element)exampleSection);
                        XMLWriter writer = new XMLWriter((Writer)new FileWriter(new File(tagFilePath)), new OutputFormat("  ", false));
                        writer.write(tagXML);
                        writer.close();
                    }
                    if (tagExampleSection == null) {
                        System.err.println("There was no section with ID=example");
                    }
                } else {
                    System.err.println("Couldn't find elementById example from file " + tagFilePath);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        processedTags = new HashMap();
        attributeTags = new String[]{"name", "required", "rtexprvalue", "description", "comments"};
        attributeClassesAlignment = new String[]{null, "center", "center", null, null};
        attributeHighlightValues = new String[][]{null, {"true"}, null, {"Document me please", "FIXME"}, {"Document me please"}};
        genericAttributes = new String[][]{{"Form-specific HTML tag attribute", "The content is copied to the resulting <form...> tag. Careful with (escaping) quotes."}, {"Generic HTML tag attribute", "The content is copied to the resulting html tag. Careful with (escaping) quotes."}, {"Input-specific HTML tag attribute", "The content is copied to the resulting <input...> tag. Careful with (escaping) quotes."}};
        attributeHighlightClasses = new String[]{null, "required", null, "missingDoc", "missingDoc"};
        genericAttributeName = null;
        genericAttributesCount = 0;
        genericAttributeFirstRow = null;
    }
}

