/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaSystem;
import org.makumba.providers.DataDefinitionProvider;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.action.layout.graph.SquarifiedTreeMapLayout;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.data.Graph;
import prefuse.data.expression.Predicate;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphMLReader;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class MDDRelationVisualiser {
    static final String tree = "graph";
    static final String treeNodes = "graph.nodes";
    static final String treeEdges = "graph.edges";

    public static void main(String[] args) throws IOException {
        Vector<String> mdds = DataDefinitionProvider.getInstance().getDataDefinitionsInDefaultLocations();
        File tmp = new File("/tmp/graph.ml");
        Namespace ns = Namespace.getNamespace((String)"http://graphml.graphdrawing.org/xmlns");
        Element graphml_tag = new Element("graphml").setNamespace(ns);
        Element root = new Element(tree).setAttribute("edgedefault", "directed");
        graphml_tag.addContent((Content)root);
        Element incoming = new Element("key");
        incoming.setAttribute("id", "name");
        incoming.setAttribute("for", "node");
        incoming.setAttribute("attr.name", "name");
        incoming.setAttribute("attr.type", "string");
        root.addContent((Content)incoming);
        ArrayList<Element> edges2Add = new ArrayList<Element>();
        for (String mdd : mdds) {
            try {
                DataDefinition dd = MakumbaSystem.getDataDefinition(mdd);
                System.out.println(dd);
                MDDRelationVisualiser.addNode(root, dd.getName());
                Vector<String> fieldNames = dd.getFieldNames();
                for (String name : fieldNames) {
                    String name2;
                    FieldDefinition fd = dd.getFieldDefinition(name);
                    if (fd.isPointer()) {
                        name2 = fd.getPointedType().getName();
                        edges2Add.add(MDDRelationVisualiser.addEdge(root, dd.getName(), name2, 9));
                        continue;
                    }
                    if (fd.getIntegerType() != 12) continue;
                    name2 = fd.getPointedType().getName();
                    edges2Add.add(MDDRelationVisualiser.addEdge(root, dd.getName(), name2, 9));
                }
            }
            catch (DataDefinitionParseError e) {
                System.out.println("Skipping broken MDD " + mdd);
            }
        }
        for (Element element : edges2Add) {
            root.addContent((Content)element);
        }
        XMLOutputter serializer = new XMLOutputter();
        serializer.setFormat(Format.getPrettyFormat());
        serializer.output(graphml_tag, (OutputStream)new FileOutputStream(tmp));
        Graph graph = null;
        try {
            graph = new GraphMLReader().readGraph(tmp.getAbsoluteFile());
        }
        catch (DataIOException e) {
            e.printStackTrace();
            System.err.println("Error loading graph. Exiting...");
            System.exit(1);
        }
        Visualization m_vis = new Visualization();
        m_vis.add(tree, (TupleSet)graph);
        m_vis.setInteractive(treeNodes, null, false);
        LabelRenderer m_nodeRenderer = new LabelRenderer("name");
        m_nodeRenderer.setRenderType(2);
        m_nodeRenderer.setHorizontalAlignment(2);
        m_nodeRenderer.setRoundedCorner(8, 8);
        EdgeRenderer m_edgeRenderer = new EdgeRenderer();
        m_edgeRenderer.setDefaultLineWidth(1.0);
        DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)m_nodeRenderer);
        rf.add((Predicate)new InGroupPredicate(treeEdges), (Renderer)m_edgeRenderer);
        m_vis.setRendererFactory((RendererFactory)rf);
        ColorAction text = new ColorAction(treeNodes, VisualItem.TEXTCOLOR, ColorLib.gray((int)0));
        ColorAction edges = new ColorAction(treeEdges, VisualItem.STROKECOLOR, ColorLib.gray((int)200));
        ActionList color = new ActionList();
        color.add((Action)text);
        color.add((Action)edges);
        SquarifiedTreeMapLayout graphLayout = new SquarifiedTreeMapLayout(tree);
        m_vis.putAction("circleLayout", (Action)graphLayout);
        ActionList layout = new ActionList(7500L);
        ForceDirectedLayout l = new ForceDirectedLayout(tree);
        layout.add((Action)l);
        layout.add((Action)new RepaintAction());
        m_vis.putAction("color", (Action)color);
        m_vis.putAction("layout", (Action)layout);
        Display display = new Display(m_vis);
        display.setSize(1200, 800);
        display.addControlListener((Control)new DragControl());
        display.addControlListener((Control)new PanControl());
        display.addControlListener((Control)new ZoomControl());
        JFrame frame = new JFrame("prefuse example");
        frame.setDefaultCloseOperation(3);
        frame.add((Component)display);
        frame.pack();
        frame.setVisible(true);
        m_vis.run("color");
        m_vis.run("layout");
    }

    private static void addNode(Element root, String name) {
        Element elem = new Element("node").setAttribute("id", "" + name);
        elem.addContent((Content)new Element("data").setAttribute("key", "name").setText(name));
        root.addContent((Content)elem);
    }

    private static Element addEdge(Element root, String from, String to, Integer count) {
        Element elem = new Element("edge");
        elem.setAttribute("source", "" + from);
        elem.setAttribute("target", "" + to);
        elem.setAttribute("directed", "true");
        return elem;
    }
}

