/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.makumba.CompositeValidationException;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.ValidationRule;
import org.makumba.commons.attributes.HttpParameters;
import org.makumba.commons.attributes.RequestAttributes;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.forms.html.FieldEditor;
import org.makumba.forms.html.binaryEditor;
import org.makumba.forms.html.booleanEditor;
import org.makumba.forms.html.charEditor;
import org.makumba.forms.html.charEnumEditor;
import org.makumba.forms.html.dateEditor;
import org.makumba.forms.html.errorEditor;
import org.makumba.forms.html.intEditor;
import org.makumba.forms.html.intEnumEditor;
import org.makumba.forms.html.ptrEditor;
import org.makumba.forms.html.realEditor;
import org.makumba.forms.html.setEditor;
import org.makumba.forms.html.setcharEnumEditor;
import org.makumba.forms.html.setintEnumEditor;
import org.makumba.forms.html.textEditor;
import org.makumba.providers.datadefinition.makumba.validation.ComparisonValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordEditor
extends RecordFormatter {
    private static final long serialVersionUID = 1L;
    String database;
    String[] db;
    Map<String, String>[] query;

    protected RecordEditor() {
    }

    public RecordEditor(DataDefinition ri, Hashtable<String, String> h, String database, boolean isSearchForm, Object formIdentifier) {
        super(ri, h, isSearchForm, formIdentifier);
        this.database = database;
        this.db = new String[ri.getFieldNames().size()];
        this.query = new Map[ri.getFieldNames().size()];
    }

    public ArrayList<InvalidValueException> getUnassignedExceptions(CompositeValidationException e, ArrayList<InvalidValueException> unassignedExceptions, String suffix) {
        for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            Collection<InvalidValueException> exceptions = e.getExceptions(FieldEditor.getInputName((RecordFormatter)this, i, suffix));
            if (exceptions == null) continue;
            for (InvalidValueException invalidValueException : exceptions) {
                unassignedExceptions.remove(invalidValueException);
            }
        }
        return unassignedExceptions;
    }

    public Dictionary<String, Object> readFrom(HttpServletRequest req, String suffix, boolean applyValidationRules, HashMap<String, String> lazyEvaluatedInputs) {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        Vector<InvalidValueException> exceptions = new Vector<InvalidValueException>();
        Hashtable<Integer, Object> validatedFields = new Hashtable<Integer, Object>();
        Hashtable<String, Object> validatedFieldsNameCache = new Hashtable<String, Object>();
        Hashtable<FieldDefinition, Object> validatedFieldsFdCache = new Hashtable<FieldDefinition, Object>();
        for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            FieldEditor fe = (FieldEditor)this.formatterArray[i];
            String inputName = FieldEditor.getInputName((RecordFormatter)this, i, suffix);
            if (inputName == null) continue;
            Object o = null;
            try {
                FieldDefinition fd = this.dd.getFieldDefinition(i);
                o = fe.readFrom(this, i, RequestAttributes.getParameters(req), suffix);
                if (o != null) {
                    o = fd.checkValue(o);
                } else {
                    boolean lazyEvaluation = lazyEvaluatedInputs.containsValue(inputName.substring(0, inputName.indexOf(suffix)));
                    if (applyValidationRules && fd.isNotNull() && !lazyEvaluation) {
                        String error = fd.getNotNullErrorMessage();
                        if (error == null) {
                            error = "A non-null value is required for this field";
                        }
                        throw new InvalidValueException(inputName, error);
                    }
                    o = fd.getNull();
                }
                if (applyValidationRules && fd.isNotEmpty() && fd.isStringType() && StringUtils.isEmpty((String)o.toString())) {
                    String error = fd.getNotEmptyErrorMessage();
                    if (error == null) {
                        error = "A non-empty value is required for this field";
                    }
                    throw new InvalidValueException(inputName, error);
                }
                validatedFields.put(new Integer(i), o);
                validatedFieldsNameCache.put(inputName, o);
                validatedFieldsFdCache.put(fd.getOriginalFieldDefinition(), o);
                continue;
            }
            catch (InvalidValueException e) {
                exceptions.add(e);
            }
        }
        ArrayList validatedFieldsOrdered = new ArrayList(validatedFields.keySet());
        Collections.sort(validatedFieldsOrdered);
        LinkedHashMap<org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule, FieldDefinition> multiFieldValidationRules = new LinkedHashMap<org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule, FieldDefinition>();
        for (int index = 0; index < validatedFieldsOrdered.size(); ++index) {
            int i = (Integer)validatedFieldsOrdered.get(index);
            FieldDefinition fieldDefinition = this.dd.getFieldDefinition(i);
            Object o = validatedFields.get(validatedFieldsOrdered.get(index));
            Collection<ValidationRule> validationRules = fieldDefinition.getValidationRules();
            if (validationRules != null && applyValidationRules) {
                Iterator<ValidationRule> i$ = validationRules.iterator();
                while (i$.hasNext()) {
                    ValidationRule validationRule;
                    ValidationRule rule = validationRule = i$.next();
                    try {
                        if (rule instanceof ComparisonValidationRule && !((ComparisonValidationRule)rule).isCompareToExpression()) {
                            FieldDefinition otherFd = ((ComparisonValidationRule)rule).getOtherFd();
                            Object otherValue = validatedFieldsNameCache.get(otherFd.getName());
                            if (otherValue == null) {
                                for (String field : this.dd.getFieldNames()) {
                                    FieldDefinition fd = this.dd.getFieldDefinition(field).getOriginalFieldDefinition();
                                    if (otherFd != fd) continue;
                                    otherValue = o;
                                    break;
                                }
                            }
                            if (otherValue == null) continue;
                            rule.validate(new Object[]{o, otherValue});
                            continue;
                        }
                        if (rule instanceof org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule) {
                            org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule c = (org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule)rule;
                            multiFieldValidationRules.put(c, fieldDefinition);
                            continue;
                        }
                        rule.validate(o);
                    }
                    catch (InvalidValueException e) {
                        exceptions.add(e);
                    }
                }
            }
            RequestAttributes.setAttribute(req, FieldEditor.getInputName((RecordFormatter)this, i, suffix) + "_type", fieldDefinition);
            String inputName = FieldEditor.getInputName((RecordFormatter)this, i, "");
            if (fieldDefinition.isFileType() && o != null) {
                HttpParameters parameters = RequestAttributes.getParameters(req);
                Integer length = (Integer)parameters.getParameter(inputName + "_contentLength");
                if (length > 0) {
                    ((Dictionary)data).put(inputName + ".content", o);
                    ((Dictionary)data).put(inputName + ".contentType", parameters.getParameter(inputName + "_contentType"));
                    ((Dictionary)data).put(inputName + ".contentLength", parameters.getParameter(inputName + "_contentLength"));
                    ((Dictionary)data).put(inputName + ".originalName", parameters.getParameter(inputName + "_filename"));
                    ((Dictionary)data).put(inputName + ".name", parameters.getParameter(inputName + "_filename"));
                    if (parameters.getParameter(inputName + "_imageWidth") != null) {
                        ((Dictionary)data).put(inputName + ".imageWidth", parameters.getParameter(inputName + "_imageWidth"));
                    }
                    if (parameters.getParameter(inputName + "_imageHeight") != null) {
                        ((Dictionary)data).put(inputName + ".imageHeight", parameters.getParameter(inputName + "_imageHeight"));
                    }
                }
            } else {
                ((Dictionary)data).put(inputName, o);
            }
            RequestAttributes.setAttribute(req, FieldEditor.getInputName((RecordFormatter)this, i, suffix), o);
        }
        for (org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule r : multiFieldValidationRules.keySet()) {
            LinkedHashMap values = new LinkedHashMap();
            boolean validate = true;
            for (String fieldName : r.getValidationRuleArguments()) {
                if (validatedFieldsNameCache.containsKey(fieldName + suffix)) {
                    values.put(fieldName, validatedFieldsNameCache.get(fieldName + suffix));
                    continue;
                }
                DataDefinition ruleDD = r.getDataDefinition();
                FieldDefinition ruleFd = ruleDD.getFieldOrPointedFieldDefinition(fieldName);
                Object o = validatedFieldsFdCache.get(ruleFd);
                if (o != null) {
                    values.put(fieldName, o);
                    continue;
                }
                validate = false;
            }
            if (!validate) continue;
            try {
                r.validate(values);
            }
            catch (InvalidValueException e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new CompositeValidationException(exceptions);
        }
        return data;
    }

    public void config() {
        for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            ((FieldEditor)this.formatterArray[i]).onStartup(this, i);
        }
    }

    @Override
    public void initFormatters() {
        this.formatterArray = new FieldFormatter[this.dd.getFieldNames().size()];
        block18: for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            FieldDefinition fd = this.dd.getFieldDefinition(i);
            if (fd.isFileType()) {
                this.formatterArray[i] = binaryEditor.getInstance();
                continue;
            }
            switch (fd.getIntegerType()) {
                case 0: {
                    this.formatterArray[i] = ptrEditor.getInstance();
                    continue block18;
                }
                case 2: 
                case 13: {
                    this.formatterArray[i] = FieldEditor.getInstance();
                    continue block18;
                }
                case 4: {
                    this.formatterArray[i] = intEditor.getInstance();
                    continue block18;
                }
                case 5: {
                    this.formatterArray[i] = intEnumEditor.getInstance();
                    continue block18;
                }
                case 6: {
                    this.formatterArray[i] = charEditor.getInstance();
                    continue block18;
                }
                case 7: {
                    this.formatterArray[i] = charEnumEditor.getInstance();
                    continue block18;
                }
                case 8: {
                    this.formatterArray[i] = textEditor.getInstance();
                    continue block18;
                }
                case 18: {
                    this.formatterArray[i] = binaryEditor.getInstance();
                    continue block18;
                }
                case 19: {
                    this.formatterArray[i] = booleanEditor.getInstance();
                    continue block18;
                }
                case 9: {
                    this.formatterArray[i] = dateEditor.getInstance();
                    continue block18;
                }
                case 12: {
                    this.formatterArray[i] = setEditor.getInstance();
                    continue block18;
                }
                case 15: {
                    this.formatterArray[i] = realEditor.getInstance();
                    continue block18;
                }
                case 16: {
                    this.formatterArray[i] = setcharEnumEditor.getInstance();
                    continue block18;
                }
                case 17: {
                    this.formatterArray[i] = setintEnumEditor.getInstance();
                    continue block18;
                }
                case 10: 
                case 11: {
                    if (this.isSearchForm) {
                        this.formatterArray[i] = dateEditor.getInstance();
                        continue block18;
                    }
                    this.formatterArray[i] = errorEditor.getInstance();
                    continue block18;
                }
                case 1: 
                case 3: {
                    this.formatterArray[i] = errorEditor.getInstance();
                    continue block18;
                }
                default: {
                    throw new RuntimeException("Internal Makumba error: Unknown FieldDefinition type lead to invalid formatter content. Please report to developers.");
                }
            }
        }
    }
}

