/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.xml.transform.TransformerConfigurationException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.makumba.MakumbaSystem;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NameResolver;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.db.hibernate.MddToClass;
import org.makumba.db.hibernate.MddToMapping;
import org.makumba.providers.Configuration;
import org.makumba.providers.TransactionProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSFManager {
    private static final String DEFAULT_PREFIX = "makumbaGeneratedMappings";
    private static final String DEFAULT_SEED = "Makumba.conf";
    public static final String HIBERNATE_TRANSACTION_FACTORY = "hibernate.transaction.factory_class";
    public static final String HIBERNATE_CURRENT_SESSION_CONTEXT = "hibernate.current_session_context_class";
    private static Vector<String> externalConfigurationResources = new Vector();
    private static HashMap<String, Vector<Class>> externalClasses = new HashMap();
    private static org.hibernate.cfg.Configuration configuredConfiguration;
    private static Vector<String> generatedClasses;
    private static NameResolver nr;
    public static int sessionFactories;

    public static String findClassesRootFolder(String locatorSeed) {
        String rootFolder = "";
        try {
            rootFolder = new File(ClassResource.get(locatorSeed).getFile()).getParentFile().getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rootFolder;
    }

    public static SessionFactory getSF(String dataSource) {
        return (SessionFactory)NamedResources.getStaticCache(sessionFactories).getResource(dataSource);
    }

    private static SessionFactory makeSF(String dataSource) {
        StringTokenizer st;
        Map<String, String> properties = Configuration.getDataSourceConfiguration(dataSource);
        Properties p = new Properties();
        for (String property : properties.keySet()) {
            String value = properties.get(property);
            if (property.startsWith("connection.")) {
                property = "hibernate." + property;
            }
            if (value == null) continue;
            p.put(property, value);
        }
        Logger.getLogger("org.makumba.hibernate.sf").info("Makumba Hibernate SessionFactory manager, Hibernate " + MakumbaSystem.getHibernateVersionNumber());
        AnnotationConfiguration cfg = new AnnotationConfiguration().setProperties(p);
        HashMap classes = new HashMap();
        for (String res : externalConfigurationResources) {
            if (res.indexOf("hbm.xml") > -1) {
                cfg.addResource(res);
                continue;
            }
            String packageName = res.substring(0, res.lastIndexOf("."));
            if (!classes.containsKey(packageName)) {
                classes.put(packageName, new Vector());
            }
            try {
                ((Vector)classes.get(packageName)).add(Class.forName(res));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (String packageName : classes.keySet()) {
            AnnotationConfiguration cfg1 = cfg.addPackage(packageName);
            Vector packageClasses = (Vector)classes.get(packageName);
            for (int i = 0; i < packageClasses.size(); ++i) {
                cfg1.addAnnotatedClass((Class)packageClasses.get(i));
            }
        }
        String seed = cfg.getProperty("makumba.seed");
        if (seed == null) {
            seed = DEFAULT_SEED;
        }
        String seedDir = HibernateSFManager.findClassesRootFolder(seed);
        String prefix = cfg.getProperty("makumba.prefix");
        if (prefix == null) {
            prefix = DEFAULT_PREFIX;
        }
        Vector<Object> dds = new Vector();
        String mddList = cfg.getProperty("makumba.mdd.list");
        if (mddList != null) {
            dds = new Vector();
            Logger.getLogger("org.makumba.hibernate.sf").info("Working with the MDDs " + mddList);
            st = new StringTokenizer(mddList, ",");
            while (st.hasMoreTokens()) {
                dds.addElement(st.nextToken().trim());
            }
        } else {
            mddList = cfg.getProperty("makumba.mdd.additionalList");
            if (mddList != null) {
                dds = HibernateSFManager.getDefaultMDDs((org.hibernate.cfg.Configuration)cfg);
                Logger.getLogger("org.makumba.hibernate.sf").info("Working with additional MDDs " + mddList);
                st = new StringTokenizer(mddList, ",");
                while (st.hasMoreTokens()) {
                    dds.addElement(st.nextToken().trim());
                }
            } else {
                dds = HibernateSFManager.getDefaultMDDs((org.hibernate.cfg.Configuration)cfg);
            }
        }
        dds.add("org.makumba.controller.ErrorLog");
        dds.add("org.makumba.controller.MultipleSubmit");
        dds.add("org.makumba.devel.relations.Relation");
        dds.add("org.makumba.devel.relations.RelationOrigin");
        dds.add("org.makumba.devel.relations.WebappDatabase");
        Logger.getLogger("org.makumba.hibernate.sf").info("Generating classes under " + seedDir);
        nr = new NameResolver(p);
        try {
            new MddToClass(dds, seedDir, nr);
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.getLogger("org.makumba.hibernate.sf").info("Generating mappings under " + seedDir + File.separator + prefix);
        try {
            new MddToMapping(dds, (org.hibernate.cfg.Configuration)cfg, HibernateSFManager.findClassesRootFolder(seed), prefix, nr);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        Logger.getLogger("org.makumba.hibernate.sf").info("building session factory");
        SessionFactory sessionFactory = cfg.buildSessionFactory();
        if ("true".equals(cfg.getProperty("makumba.schemaUpdate"))) {
            Logger.getLogger("org.makumba.hibernate.sf").info("Peforming schema update");
            SchemaUpdate schemaUpdate = new SchemaUpdate((org.hibernate.cfg.Configuration)cfg);
            schemaUpdate.execute(true, true);
            Logger.getLogger("org.makumba.hibernate.sf").info("Schema update finished");
        } else {
            Logger.getLogger("org.makumba.hibernate.sf").info("skipping schema update");
        }
        configuredConfiguration = cfg;
        generatedClasses = dds;
        Logger.getLogger("org.makumba.hibernate.sf").info("Generated the classes " + dds);
        return sessionFactory;
    }

    private static Vector<String> getDefaultMDDs(org.hibernate.cfg.Configuration cfg) {
        String mddRoot = cfg.getProperty("mdd.root");
        if (mddRoot == null) {
            mddRoot = "dataDefinitions";
        }
        Logger.getLogger("org.makumba.hibernate.sf").info("Working with the MDDs under " + mddRoot);
        Vector<String> dds = MakumbaSystem.mddsInDirectory(mddRoot);
        return dds;
    }

    public static synchronized SessionFactory getSF() {
        String dataSource = TransactionProvider.getInstance().getDefaultDataSourceName();
        Logger.getLogger("org.makumba.hibernate.sf").info("Initializing configuration from " + dataSource);
        return HibernateSFManager.getSF(dataSource);
    }

    public static org.hibernate.cfg.Configuration getConfiguration(String cfgFilePath) {
        org.hibernate.cfg.Configuration cfg = new org.hibernate.cfg.Configuration().configure(cfgFilePath);
        return cfg;
    }

    public static org.hibernate.cfg.Configuration getConfiguredConfiguration() {
        return configuredConfiguration;
    }

    public static void setExternalConfigurationResources(Vector<String> resources) {
        externalConfigurationResources = resources;
    }

    public static void setExternalMappingClasses(HashMap<String, Vector<Class>> mappingClasses) {
        externalClasses = mappingClasses;
    }

    public static String getFullyQualifiedName(String className) {
        return (String)configuredConfiguration.getImports().get(nr.arrowToDoubleUnderscore(className));
    }

    public static Vector<String> getGeneratedClasses() {
        return generatedClasses;
    }

    static {
        sessionFactories = NamedResources.makeStaticCache("hibernate session factory", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            protected Object makeResource(Object nm, Object hashName) throws Exception {
                return HibernateSFManager.makeSF((String)nm);
            }
        }, false);
    }
}

