/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.type.Type;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.HibernateSFManager;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NoSuchFieldException;
import org.makumba.NullObject;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.commons.ArrayMap;
import org.makumba.commons.NameResolver;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.StacktraceUtil;
import org.makumba.db.TransactionImplementation;
import org.makumba.db.hibernate.HibernateCRUDOperationProvider;
import org.makumba.db.hibernate.HibernatePointer;
import org.makumba.db.hibernate.HibernateTransactionProvider;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.query.hql.HqlAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTransaction
extends TransactionImplementation {
    public Transaction t;
    private boolean useCurrentSession = false;
    public Session s;
    private DataDefinitionProvider ddp;
    private String dataSource;
    private static NameResolver nr = new NameResolver();
    static Pattern namedParam = Pattern.compile("\\:[a-zA-Z]\\w*");

    public HibernateTransaction(TransactionProvider tp) {
        super(tp);
    }

    public HibernateTransaction(String dataSource, DataDefinitionProvider ddp, HibernateTransactionProvider hibernateTransactionProvider) {
        this(hibernateTransactionProvider);
        this.dataSource = dataSource;
        this.ddp = ddp;
        this.useCurrentSession = Configuration.getDataSourceConfiguration(dataSource).containsKey("hibernate.current_session_context_class");
        if (this.useCurrentSession) {
            this.s = ((SessionFactory)hibernateTransactionProvider.getHibernateSessionFactory(dataSource)).getCurrentSession();
        } else {
            this.s = ((SessionFactory)hibernateTransactionProvider.getHibernateSessionFactory(dataSource)).openSession();
            this.s.setCacheMode(CacheMode.IGNORE);
        }
        this.beginTransaction();
    }

    @Override
    public void close() {
        this.setContext(null);
        this.t.commit();
        if (!this.useCurrentSession) {
            this.s.close();
        }
    }

    @Override
    public void commit() {
        this.t.commit();
        this.t = this.s.beginTransaction();
    }

    protected StringBuffer writeReadQuery(Pointer p, Enumeration e) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        String separator = "";
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            DataDefinition r = this.ddp.getDataDefinition(p.getType());
            if (!(o instanceof String)) {
                throw new NoSuchFieldException(r, "Dictionaries passed to makumba DB operations should have String keys. Key <" + o + "> is of type " + o.getClass() + r.getName());
            }
            FieldDefinition fieldDefinition = r.getFieldDefinition((String)o);
            if (fieldDefinition == null) {
                throw new NoSuchFieldException(r, (String)o);
            }
            String s = (String)o;
            sb.append(separator).append("p.");
            if (fieldDefinition.getType().equals("ptrIndex")) {
                sb.append("id");
            } else {
                sb.append(s);
                if (fieldDefinition.getType().startsWith("ptr")) {
                    sb.append(".id");
                }
            }
            sb.append(" as ").append(s);
            separator = ",";
        }
        sb.append(" FROM " + nr.arrowToDoubleUnderscore(p.getType()) + " p WHERE p.id=?");
        return sb;
    }

    protected Vector executeReadQuery(Pointer p, StringBuffer sb) {
        return this.executeQuery(sb.toString(), p);
    }

    @Override
    protected int executeUpdate(String type, String set, String where, Object args) {
        String hql = new String();
        hql = set == null ? "DELETE FROM " + type.replaceAll("->", "__") + " WHERE " + where : "UPDATE " + type.replaceAll("->", "__") + " SET " + set + " WHERE " + where;
        Query q = this.s.createQuery(hql);
        q.setCacheable(false);
        if (set != null && set.indexOf(63) != -1 || where != null && where.indexOf(63) != -1) {
            Object[] argsArray = this.treatParam(args);
            for (int i = 0; i < argsArray.length; ++i) {
                q.setParameter(i, this.weaklyTreatParamType(argsArray[i]));
            }
        } else {
            Map<String, Object> args1 = this.paramsToMap(args);
            for (String key : args1.keySet()) {
                q.setParameter(key, this.weaklyTreatParamType(args1.get(key)));
            }
        }
        return q.executeUpdate();
    }

    private Object weaklyTreatParamType(Object object) {
        if (object instanceof Pointer) {
            Pointer p = (Pointer)object;
            for (String s : HibernateSFManager.getGeneratedClasses()) {
                if (!s.equals(p.getType())) continue;
                return new Integer(p.getId());
            }
            Class<?> recordClass = null;
            try {
                Method m;
                recordClass = Class.forName(HibernateSFManager.getFullyQualifiedName(p.getType()));
                String idMethodName = "getprimaryKey";
                if (!HibernateCRUDOperationProvider.isGenerated(recordClass)) {
                    idMethodName = "getId";
                }
                if (HibernateCRUDOperationProvider.isInteger((m = recordClass.getMethod(idMethodName, new Class[0])).getReturnType().getName())) {
                    return new Integer(p.getId());
                }
                if (HibernateCRUDOperationProvider.isLong(m.getReturnType().getName())) {
                    return p.longValue();
                }
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    @Override
    public String getName() {
        throw new MakumbaError("Not implemented");
    }

    @Override
    public void lock(String symbol) {
        throw new MakumbaError("Not implemented");
    }

    @Override
    public void rollback() {
        this.t.rollback();
    }

    @Override
    public void unlock(String symbol) {
        throw new MakumbaError("Not implemented");
    }

    @Override
    public Vector<Dictionary<String, Object>> executeQuery(String query, Object args, int offset, int limit) {
        return this.execute(query, args, offset, limit);
    }

    @Override
    public Vector<Dictionary<String, Object>> executeQuery(String query, Object parameterValues) {
        return this.execute(query, parameterValues, 0, -1);
    }

    public Vector<Dictionary<String, Object>> execute(String query, Object args, int offset, int limit) {
        MakumbaSystem.getLogger("hibernate.query").fine("Executing hibernate query " + query);
        QueryAnalysisProvider qap = QueryProvider.getQueryAnalzyer("hql");
        query = qap.inlineFunctions(query);
        QueryAnalysis analyzer = qap.getQueryAnalysis(query);
        DataDefinition dataDef = analyzer.getProjectionType();
        DataDefinition paramsDef = analyzer.getParameterTypes();
        for (int i = 0; i < dataDef.getFieldNames().size(); ++i) {
            FieldDefinition fd = dataDef.getFieldDefinition(i);
            if (!fd.getType().equals("ptr") || fd.getDescription().equalsIgnoreCase("ID")) continue;
            throw new ProgrammerError("Invalid HQL query - you must not select the whole object '" + fd.getDescription() + "' in the query '" + query + "'!\nYou have to select '" + fd.getDescription() + ".id' instead.");
        }
        query = ((HqlAnalyzer)analyzer).getHackedQuery(query);
        Query q = this.s.createQuery(query);
        q.setCacheable(false);
        q.setFirstResult(offset);
        if (limit != -1) {
            q.setMaxResults(limit);
        }
        if (namedParam.matcher(query).find()) {
            args = this.paramsToMap(args);
        }
        if (args != null && args instanceof Map) {
            this.setNamedParameters(args, paramsDef, q);
        } else if (args != null) {
            this.setOrderedParameters(args, paramsDef, q);
        }
        Vector<Dictionary<String, Object>> results = null;
        try {
            results = this.getConvertedQueryResult(analyzer, q.list());
        }
        catch (Exception e) {
            throw new ProgrammerError("Error while trying to execute query " + q.getQueryString() + ":\n" + StacktraceUtil.getStackTrace(e));
        }
        return results;
    }

    private Vector<Dictionary<String, Object>> getConvertedQueryResult(QueryAnalysis analyzer, List list) {
        int i;
        DataDefinition dataDef = analyzer.getProjectionType();
        Vector<Dictionary<String, Object>> results = new Vector<Dictionary<String, Object>>(list.size());
        String[] projections = dataDef.getFieldNames().toArray(new String[dataDef.getFieldNames().size()]);
        Hashtable<String, Integer> keyIndex = new Hashtable<String, Integer>(projections.length);
        for (i = 0; i < projections.length; ++i) {
            ((Dictionary)keyIndex).put(projections[i], new Integer(i));
        }
        i = 1;
        for (Object resultRow : list) {
            Object[] resultFields = !(resultRow instanceof Object[]) ? new Object[]{resultRow} : (Object[])resultRow;
            for (int j = 0; j < resultFields.length; ++j) {
                if (resultFields[j] == null) continue;
                FieldDefinition fd = dataDef.getFieldDefinition(j);
                if (fd.getType().equals("ptr")) {
                    String ddName = fd.getPointedType().getName();
                    if (resultFields[j] instanceof Pointer) {
                        resultFields[j] = new HibernatePointer(ddName, ((Pointer)resultFields[j]).getId());
                        continue;
                    }
                    if (resultFields[j] instanceof Integer) {
                        resultFields[j] = new HibernatePointer(ddName, ((Integer)resultFields[j]).intValue());
                        continue;
                    }
                    if (resultFields[j] instanceof Long) {
                        resultFields[j] = new HibernatePointer(ddName, (Long)resultFields[j]);
                        continue;
                    }
                    throw new RuntimeWrappedException(new LogicException("Internal Makumba error: Detected an unknown type returned by a query. The projection index is " + j + ", the result class is " + resultFields[j].getClass() + ", it's content " + "is '" + resultFields[j] + "'and type analysis claims its type is " + fd.getPointedType().getName(), true));
                }
                resultFields[j] = resultFields[j];
            }
            ArrayMap dic = new ArrayMap(keyIndex, resultFields);
            results.add(dic);
            ++i;
        }
        return results;
    }

    private void setOrderedParameters(Object parameterValues, DataDefinition paramsDef, Query q) {
        Object[] argsArray = this.treatParam(parameterValues);
        for (int i = 0; i < argsArray.length; ++i) {
            Object paramValue = argsArray[i];
            FieldDefinition paramDef = paramsDef.getFieldDefinition(i);
            if (paramValue instanceof Date) {
                q.setDate(i, (Date)paramValue);
                continue;
            }
            if (paramValue instanceof Integer) {
                q.setInteger(i, ((Integer)paramValue).intValue());
                continue;
            }
            if (paramValue instanceof Pointer) {
                q.setParameter(i, (Object)new Integer(((Pointer)argsArray[i]).getId()));
                continue;
            }
            if (paramDef != null) {
                if (paramDef.getIntegerType() == 0 && paramValue instanceof String) {
                    Pointer p = new Pointer(paramDef.getPointedType().getName(), (String)paramValue);
                    q.setInteger(i, new Integer((int)p.longValue()).intValue());
                    continue;
                }
                q.setParameter(i, paramValue);
                continue;
            }
            q.setParameter(i, paramValue);
        }
    }

    private void setNamedParameters(Map args, DataDefinition paramsDef, Query q) {
        String[] queryParams = q.getNamedParameters();
        for (int i = 0; i < queryParams.length; ++i) {
            Number val;
            String paramName = queryParams[i];
            Object paramValue = args.get(paramName);
            FieldDefinition paramDef = paramsDef.getFieldDefinition(paramName);
            if (paramValue instanceof Vector) {
                q.setParameterList(paramName, (Collection)paramValue);
                continue;
            }
            if (paramValue instanceof Date) {
                q.setParameter(paramName, paramValue, (Type)Hibernate.TIMESTAMP);
                continue;
            }
            if (paramValue instanceof Integer) {
                q.setParameter(paramName, paramValue, (Type)Hibernate.INTEGER);
                continue;
            }
            if (paramValue instanceof Pointer) {
                q.setParameter(paramName, (Object)new Integer(((Pointer)paramValue).getId()), (Type)Hibernate.INTEGER);
                continue;
            }
            if (paramValue instanceof NullObject) {
                NullObject n = (NullObject)paramValue;
                if (n.equals(Pointer.Null)) {
                    q.setParameter(paramName, (Object)new Integer(-1), (Type)Hibernate.INTEGER);
                    continue;
                }
                if (n.equals(Pointer.NullInteger)) {
                    q.setParameter(paramName, (Object)new Integer(-1), (Type)Hibernate.INTEGER);
                    continue;
                }
                q.setParameter(paramName, null);
                continue;
            }
            if (paramDef.getIntegerType() == 0 && paramValue instanceof String) {
                Pointer p = new Pointer(paramDef.getPointedType().getName(), (String)paramValue);
                q.setParameter(paramName, (Object)new Integer(p.getId()), (Type)Hibernate.INTEGER);
                continue;
            }
            if (paramDef.getIntegerType() == 4) {
                val = paramValue instanceof String ? Integer.parseInt((String)paramValue) : (Integer)paramValue;
                q.setParameter(paramName, (Object)val);
                continue;
            }
            if (paramDef.getIntegerType() == 15) {
                val = paramValue instanceof String ? Double.parseDouble((String)paramValue) : (Double)paramValue;
                q.setParameter(paramName, (Object)val);
                continue;
            }
            q.setParameter(paramName, paramValue);
        }
    }

    @Override
    public Vector<Pointer> insert(String type, Collection<Dictionary<String, Object>> data) {
        return super.insert(type, data);
    }

    @Override
    public int insertFromQuery(String type, String OQL, Object parameterValues) {
        throw new MakumbaError("Not implemented");
    }

    @Override
    public String transformTypeName(String name) {
        return nr.arrowToDoubleUnderscore(name);
    }

    @Override
    public String getParameterName() {
        return "?";
    }

    @Override
    public String getPrimaryKeyName() {
        return ".id";
    }

    @Override
    public String getSetJoinSyntax() {
        return "JOIN";
    }

    @Override
    public String getPrimaryKeyName(String s) {
        return "id";
    }

    @Override
    public String getNullConstant() {
        return "null";
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    public Transaction beginTransaction() {
        this.t = this.s.beginTransaction();
        return this.t;
    }
}

