/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.collections.AST;
import org.makumba.MakumbaError;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.datadefinition.mdd.MakumbaDumpASTVisitor;

public class MqlTreePrinter {
    StringBuffer sb = new StringBuffer();
    QueryAnalysisProvider qp;
    MakumbaDumpASTVisitor v = new MakumbaDumpASTVisitor(false);

    public MqlTreePrinter(QueryAnalysisProvider qp) {
        this.qp = qp;
    }

    public String printTree(AST tree) {
        try {
            this.handleAST(tree);
        }
        catch (Throwable npe) {
            System.out.println("Error while printing MQL tree: " + npe.getMessage());
            npe.printStackTrace();
            this.v.visit(tree);
        }
        String result = this.sb.toString();
        this.sb = new StringBuffer();
        return result;
    }

    private void handleAST(AST a) {
        switch (a.getType()) {
            case 83: {
                this.handleQuery(a);
                break;
            }
            case 86: {
                this.handleSelectFrom(a);
                break;
            }
            case 22: {
                this.handleFrom(a);
                break;
            }
            case 45: {
                this.handleSelect(a);
                break;
            }
            case 53: {
                this.handleWhere(a);
                break;
            }
            case 24: {
                this.handleGroup(a);
                break;
            }
            case 25: {
                this.handleHaving(a);
                break;
            }
            case 41: {
                this.handleOrder(a);
                break;
            }
            case 54: {
                this.handleCase(a);
                break;
            }
            case 71: {
                this.handleCase2(a);
                break;
            }
            case 58: {
                this.handleWhen(a);
                break;
            }
            case 56: {
                this.handleElse(a);
                break;
            }
            case 10: {
                this.handleBetween(a);
                break;
            }
            case 34: {
                this.handleLike(a);
                break;
            }
            case 81: {
                this.handleNotLike(a);
                break;
            }
            case 79: {
                this.handleNotBetween(a);
                break;
            }
            case 26: {
                this.handleIn(a);
                break;
            }
            case 80: {
                this.handleNotIn(a);
                break;
            }
            case 12: {
                this.handleCount(a);
                break;
            }
            case 78: {
                this.handleMethodCall(a);
                break;
            }
            case 116: {
                this.handleColon(a);
                break;
            }
            case 7: {
                this.handleAs(a);
                break;
            }
            case 68: {
                this.handleAggregate(a);
                break;
            }
            case 4: {
                this.handleAll(a);
                break;
            }
            case 20: 
            case 49: 
            case 69: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 118: 
            case 119: 
            case 120: {
                this.out(a.getText());
                break;
            }
            case 6: 
            case 15: 
            case 40: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                this.handleAST(a.getFirstChild());
                this.printOperator(a);
                this.handleAST(a.getFirstChild().getNextSibling());
                break;
            }
            case 97: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                this.out("(");
                this.handleAST(a.getFirstChild());
                this.printOperator(a);
                this.handleAST(a.getFirstChild().getNextSibling());
                this.out(")");
                break;
            }
            case 76: 
            case 77: {
                this.handleAST(a.getFirstChild());
                this.printOperator(a);
                break;
            }
            case 5: 
            case 19: 
            case 38: 
            case 47: {
                this.printOperator(a);
                this.out("(");
                this.handleAST(a.getFirstChild());
                this.out(")");
                break;
            }
            case 18: 
            case 87: 
            case 88: {
                this.printOperator(a);
                this.handleAST(a.getFirstChild());
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 28: 
            case 85: {
                this.printOperator(a);
                break;
            }
            default: {
                throw new MakumbaError("AST type " + a.getType() + " not implemented!");
            }
        }
    }

    private void handleAll(AST a) {
        this.printOperator(a);
        if (a.getFirstChild() != null) {
            this.out("(");
            this.handleAST(a.getFirstChild());
            this.out(")");
        }
    }

    private void handleAggregate(AST a) {
        this.out(a.getText());
        this.out("(");
        this.handleAST(a.getFirstChild());
        this.out(")");
    }

    private void handleHaving(AST a) {
        this.out(" having ");
        this.handleAST(a.getFirstChild());
    }

    private void handleGroup(AST a) {
        this.out(" group by ");
        a = a.getFirstChild();
        this.handleAST(a);
        while (a.getNextSibling() != null) {
            this.out(", ");
            this.handleAST(a.getNextSibling());
            a = a.getNextSibling();
        }
    }

    private void handleAs(AST a) {
        this.handleAST(a.getFirstChild());
        this.sb.append(" as ");
        this.sb.append(a.getFirstChild().getNextSibling());
    }

    private void handleColon(AST a) {
        int sep = a.getFirstChild().getText().indexOf("###");
        this.out(this.qp.getParameterSyntax() + a.getFirstChild().getText().substring(0, sep));
    }

    private void handleCount(AST a) {
        this.out("count ");
        a = a.getFirstChild();
        if (a.getType() == 16 || a.getType() == 4) {
            this.handleAST(a);
            a = a.getNextSibling();
        }
        this.handleAST(a);
    }

    private void handleNotLike(AST a) {
        this.handleAST(a.getFirstChild());
        this.out(" not like ");
        this.handleAST(a.getFirstChild().getNextSibling());
        if (a.getFirstChild().getNextSibling().getNextSibling() != null) {
            this.handleAST(a.getFirstChild().getNextSibling().getNextSibling());
        }
    }

    private void handleLike(AST a) {
        this.handleAST(a.getFirstChild());
        this.out(" like ");
        this.handleAST(a.getFirstChild().getNextSibling());
        if (a.getFirstChild().getNextSibling().getNextSibling() != null) {
            this.handleAST(a.getFirstChild().getNextSibling().getNextSibling());
        }
    }

    private void handleIn(AST a) {
        this.handleAST(a.getFirstChild());
        this.out(" in ");
        if (a.getFirstChild().getNextSibling().getType() == 83) {
            this.handleQuery(a.getFirstChild().getNextSibling());
        } else {
            a = a.getFirstChild().getNextSibling();
            this.handleList(a);
        }
    }

    private void handleList(AST a) {
        this.out("(");
        this.handleAST(a);
        while (a.getNextSibling() != null) {
            this.out(", ");
            this.handleAST(a.getNextSibling());
            a = a.getNextSibling();
        }
        this.out(")");
    }

    private void handleNotIn(AST a) {
        this.handleAST(a.getFirstChild());
        this.out(" not in ");
        if (a.getFirstChild().getNextSibling().getType() == 83) {
            this.handleQuery(a.getFirstChild().getNextSibling());
        } else {
            a = a.getFirstChild().getNextSibling();
            this.handleList(a);
        }
    }

    private void handleBetween(AST a) {
        this.handleAST(a.getFirstChild());
        this.out(" between ");
        this.handleAST(a.getFirstChild().getNextSibling());
        this.out(" and ");
        this.handleAST(a.getFirstChild().getNextSibling().getNextSibling());
    }

    private void handleNotBetween(AST a) {
        this.handleAST(a.getFirstChild());
        this.out(" not between ");
        this.handleAST(a.getFirstChild().getNextSibling());
        this.out(" and ");
        this.handleAST(a.getFirstChild().getNextSibling().getNextSibling());
    }

    private void handleMethodCall(AST a) {
        this.handleAST(a.getFirstChild());
        this.out("(");
        AST arg = a.getFirstChild().getNextSibling().getFirstChild();
        if (arg != null) {
            this.handleAST(arg);
            while (arg.getNextSibling() != null) {
                this.out(", ");
                this.handleAST(arg.getNextSibling());
                arg = arg.getNextSibling();
            }
        }
        this.out(")");
    }

    private void handleCase(AST a) {
        this.out("case ");
        AST when = a.getFirstChild();
        this.handleAST(when);
        while (when.getNextSibling() != null) {
            this.handleAST(when.getNextSibling());
            when = when.getNextSibling();
        }
        this.out(" end");
    }

    private void handleWhen(AST a) {
        this.out(" when ");
        this.handleAST(a.getFirstChild());
        this.out(" then ");
        this.handleAST(a.getFirstChild().getNextSibling());
    }

    private void handleElse(AST a) {
        this.out(" else ");
        this.handleAST(a.getFirstChild());
    }

    private void handleCase2(AST a) {
        this.out("case ");
        this.handleAST(a.getFirstChild());
        AST when = a.getFirstChild().getNextSibling();
        while (when.getNextSibling() != null) {
            this.handleAST(when.getNextSibling());
            when = when.getNextSibling();
        }
        this.out(" end");
    }

    private void handleOrder(AST a) {
        this.out(" order by ");
        this.handleAST(a.getFirstChild());
        a = a.getFirstChild();
        while (a.getNextSibling() != null) {
            if (a.getNextSibling().getType() != 8 && a.getNextSibling().getType() != 14) {
                this.out(", ");
            }
            this.handleAST(a.getNextSibling());
            a = a.getNextSibling();
        }
    }

    private void handleWhere(AST a) {
        this.out(" where ");
        this.handleAST(a.getFirstChild());
    }

    private void handleSelect(AST a) {
        this.out("select ");
        this.handleAST(a.getFirstChild());
        a = a.getFirstChild();
        while (a.getNextSibling() != null) {
            this.out(", ");
            this.handleAST(a.getNextSibling());
            a = a.getNextSibling();
        }
    }

    private void handleFrom(AST a) {
        this.out(" from ");
        this.handleRange(a.getFirstChild());
    }

    private void handleRange(AST a) {
        this.handleAST(a.getFirstChild());
        this.space();
        this.handleAST(a.getFirstChild().getNextSibling());
        if (a.getNextSibling() != null) {
            this.sb.append(", ");
            this.handleRange(a.getNextSibling());
        }
    }

    private void handleSelectFrom(AST a) {
        if (a.getFirstChild().getNextSibling() != null) {
            this.handleSelect(a.getFirstChild().getNextSibling());
        }
        this.handleFrom(a.getFirstChild());
    }

    private void handleQuery(AST a) {
        boolean subquery;
        boolean bl = subquery = this.sb.length() > 0;
        if (subquery) {
            this.sb.append("(");
        }
        AST q = a.getFirstChild();
        this.handleAST(q);
        while (q.getNextSibling() != null) {
            this.handleAST(q.getNextSibling());
            q = q.getNextSibling();
        }
        if (subquery) {
            this.sb.append(")");
        }
    }

    private void printOperator(AST a) {
        switch (a.getType()) {
            case 15: {
                this.out(".");
                break;
            }
            case 110: {
                this.out("+");
                break;
            }
            case 111: {
                this.out("-");
                break;
            }
            case 113: {
                this.out("/");
                break;
            }
            case 112: {
                this.out("*");
                break;
            }
            case 87: {
                this.out("-");
                break;
            }
            case 88: {
                this.out("+");
                break;
            }
            case 6: {
                this.out(" and ");
                break;
            }
            case 40: {
                this.out(" or ");
                break;
            }
            case 38: {
                this.out("not ");
                break;
            }
            case 97: {
                this.out("=");
                break;
            }
            case 103: {
                this.out("!=");
                break;
            }
            case 105: {
                this.out("<");
                break;
            }
            case 106: {
                this.out(">");
                break;
            }
            case 107: {
                this.out("<=");
                break;
            }
            case 108: {
                this.out(">=");
                break;
            }
            case 8: {
                this.out(" asc");
                break;
            }
            case 14: {
                this.out(" desc");
                break;
            }
            case 76: {
                this.out(" is not null");
                break;
            }
            case 77: {
                this.out(" is null");
                break;
            }
            case 5: {
                this.out("any ");
                break;
            }
            case 47: {
                this.out("some ");
                break;
            }
            case 4: {
                this.out("all ");
                break;
            }
            case 19: {
                this.out("exists ");
                break;
            }
            case 18: {
                this.out(" escape ");
                break;
            }
            case 16: {
                this.out("distinct ");
                break;
            }
            case 85: {
                this.out("*");
                break;
            }
            case 28: {
                this.out("inner");
                break;
            }
            default: {
                throw new MakumbaError("Operator " + a.getText() + " not defined!");
            }
        }
    }

    private void space() {
        this.sb.append(" ");
    }

    private void out(String t) {
        this.sb.append(t);
    }
}

