/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.EhCache;
import org.hibernate.cache.Timestamper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger((Class)EhCacheProvider.class);
    private CacheManager manager;

    public Cache buildCache(String name, Properties properties) throws CacheException {
        try {
            net.sf.ehcache.Cache cache = this.manager.getCache(name);
            if (cache == null) {
                log.warn("Could not find configuration [" + name + "]; using defaults.");
                this.manager.addCache(name);
                cache = this.manager.getCache(name);
                log.debug("started EHCache region: " + name);
            }
            return new EhCache(cache);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException(e);
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
        if (this.manager != null) {
            log.warn("Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Using previously created EhCacheProvider. If this behaviour is required, consider using net.sf.ehcache.hibernate.SingletonEhCacheProvider.");
            return;
        }
        try {
            String configurationResourceName = null;
            if (properties != null) {
                configurationResourceName = (String)properties.get("hibernate.cache.provider_configuration_file_resource_path");
            }
            if (StringHelper.isEmpty(configurationResourceName)) {
                this.manager = new CacheManager();
            } else {
                URL url = this.loadResource(configurationResourceName);
                this.manager = new CacheManager(url);
            }
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Consider using net.sf.ehcache.hibernate.SingletonEhCacheProvider.", e);
            }
            throw e;
        }
    }

    private URL loadResource(String configurationResourceName) {
        URL url = ConfigHelper.locateConfig(configurationResourceName);
        if (log.isDebugEnabled()) {
            log.debug("Creating EhCacheProvider from a specified resource: " + configurationResourceName + " Resolved to URL: " + url);
        }
        return url;
    }

    public void stop() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.manager = null;
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

