/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.xml.binding.Immutable;
import org.jboss.xml.binding.metadata.ClassBinding;
import org.jboss.xml.binding.metadata.JavaValueBinding;

public class FieldBinding
extends ClassBinding
implements JavaValueBinding {
    private final String fieldName;
    private final Field field;
    private final Method getter;
    private final Method setter;

    public FieldBinding(Class ownerType, String fieldName, Class newInstanceType) {
        super(newInstanceType);
        this.fieldName = fieldName;
        Field field = null;
        Method getter = null;
        Method setter = null;
        String methodNameBase = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        try {
            getter = ownerType.getMethod("get" + methodNameBase, null);
            try {
                setter = ownerType.getMethod("set" + methodNameBase, getter.getReturnType());
            }
            catch (NoSuchMethodException e) {}
        }
        catch (NoSuchMethodException e) {
            try {
                field = ownerType.getField(fieldName);
            }
            catch (NoSuchFieldException endOfWorld) {
                throw new IllegalStateException("Throw niether getter/setter pair nor field were found for " + fieldName + " in " + ownerType);
            }
        }
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    /*
     * WARNING - void declaration
     */
    public Object get(Object owner, String name) {
        void var3_3;
        Object value;
        if (owner instanceof Immutable) {
            value = ((Immutable)owner).getChild(name);
        } else {
            if (this.field == null) {
                try {
                    value = this.getter.invoke(owner, null);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to get value of " + this.fieldName + " in " + this.cls + " from " + owner + " using getter " + this.getter.getName() + ": " + e.getMessage());
                }
            }
            try {
                value = this.field.get(owner);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to get value of " + this.fieldName + " in " + this.cls + " from " + owner + " using field " + this.field.getName() + ": " + e.getMessage());
            }
        }
        return var3_3;
    }

    public void set(Object owner, Object value, String name) {
        if (value instanceof Immutable) {
            value = ((Immutable)value).newInstance();
        }
        if (owner instanceof Immutable) {
            ((Immutable)owner).addChild(name, value);
        } else {
            if (this.field == null) {
                try {
                    this.setter.invoke(owner, value);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to set value of " + this.fieldName + " in " + this.cls + " to " + value + " for " + owner + " using setter " + this.setter.getName() + ": " + e.getMessage());
                }
            }
            try {
                this.field.set(owner, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to set value of " + this.fieldName + " in " + this.cls + " to " + value + " for " + owner + " using field " + this.field.getName() + ": " + e.getMessage());
            }
        }
    }
}

