/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.servlet.ResponseRecord;
import org.w3c.tidy.servlet.ResponseRecordRepository;
import org.w3c.tidy.servlet.properties.JTidyServletProperties;
import org.w3c.tidy.servlet.reports.Report;

public class TidyServlet
extends HttpServlet {
    private static final long serialVersionUID = 29137L;
    public static final String CONFIG_PROPERTIES_FILE_NAME = "properties.filename";
    public static final String PARAM_REQUEST_ID = "requestID";
    public static final String PARAM_ACTION = "action";
    public static final String ACTION_IMAGE = "image";
    public static final String ACTION_IMAGE_PARAM_SRC_ONLY = "srcOnly";
    public static final String ACTION_VIEW = "view";
    public static final String ACTION_REPORT = "report";
    public static final String ACTION_REPORT_PARAM_SRC_ORG = "src";
    public static final String ACTION_REPORT_PARAM_SRC_RESULT = "result";
    private static final String RESOURCE_PREFIX = "";
    private Log log = LogFactory.getLog((Class)(class$org$w3c$tidy$servlet$TidyServlet == null ? (class$org$w3c$tidy$servlet$TidyServlet = TidyServlet.class$("org.w3c.tidy.servlet.TidyServlet")) : class$org$w3c$tidy$servlet$TidyServlet));
    private JTidyServletProperties properties = JTidyServletProperties.getInstance();
    static /* synthetic */ Class class$org$w3c$tidy$servlet$TidyServlet;

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.properties.loadFile(this.getInitParameter(CONFIG_PROPERTIES_FILE_NAME));
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.selectAction(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.selectAction(request, response);
    }

    void selectAction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String action = request.getParameter(PARAM_ACTION);
        String id = request.getParameter(PARAM_REQUEST_ID);
        if (action == null) {
            return;
        }
        if (action.equalsIgnoreCase(ACTION_IMAGE)) {
            this.redirect2Image(request, response, id);
        } else if (action.equalsIgnoreCase(ACTION_REPORT)) {
            this.printReport(request, response, id, false);
        } else if (action.equalsIgnoreCase(ACTION_VIEW)) {
            this.printReport(request, response, id, true);
        }
    }

    void redirect2Image(HttpServletRequest request, HttpServletResponse response, String id) throws IOException, ServletException {
        String src;
        String imageNamePrefix = this.properties.getProperty("imageNamePrefix", "jtidy_html_32x26_");
        String imageNameExtension = this.properties.getProperty("imageNameExtension", ".png");
        ResponseRecordRepository rrr = JTidyServletProperties.getInstance().getRepositoryInstance(request.getSession());
        if (rrr == null) {
            this.log.info((Object)"No ResponseRecordRepository");
            response.setContentType("image/png");
            response.setContentLength(0);
            return;
        }
        Object key = rrr.getResponseID(id);
        ResponseRecord record = rrr.getRecord(key, this.properties.getIntProperty("imageGetTimeout", 2000));
        String imageName = "unknown";
        if (record != null) {
            imageName = record.getImageName();
        } else {
            this.log.debug((Object)("ResponseRecord not found for ID " + id));
        }
        StringBuffer imageURL = new StringBuffer(40);
        imageURL.append(imageNamePrefix).append(imageName).append(imageNameExtension);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ResultsDO for ID " + id + " -> " + imageURL));
        }
        if ((src = request.getParameter(ACTION_IMAGE_PARAM_SRC_ONLY)) != null) {
            PrintWriter out = response.getWriter();
            out.print(imageURL);
        } else if (!this.streamResource(imageURL.toString(), response)) {
            this.getServletContext().getRequestDispatcher(imageURL.toString()).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean streamResource(String resource, HttpServletResponse response) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(RESOURCE_PREFIX + resource);
        if (in == null) {
            in = this.getServletContext().getResourceAsStream("/" + resource);
        }
        if (in == null) {
            this.log.warn((Object)("resource not found:" + resource));
            return false;
        }
        if (resource.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (resource.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (resource.endsWith(".jpg") || resource.endsWith(".jpeg")) {
            response.setContentType("image/jpeg");
        } else {
            in.close();
            return false;
        }
        int BUFFER_SIZE = 2048;
        byte[] buffer = new byte[2048];
        int r = 0;
        ServletOutputStream out = response.getOutputStream();
        while ((r = in.read(buffer)) != -1) {
            out.write(buffer, 0, r);
        }
        out.flush();
        in.close();
        return true;
    }

    void printReport(HttpServletRequest request, HttpServletResponse response, String id, boolean view) throws IOException {
        response.setContentType("text/html");
        Report report = new Report(request.getSession());
        report.setCompletePage(true);
        report.setView(view);
        if (request.getParameter(ACTION_REPORT_PARAM_SRC_ORG) != null) {
            report.setPrintSource(true);
        }
        if (request.getParameter(ACTION_REPORT_PARAM_SRC_RESULT) != null) {
            report.setPrintHtmlResult(true);
        }
        report.print(response.getWriter(), id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

