/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.swarmcache.ObjectCache;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoCache
implements ObjectCache {
    Log log = LogFactory.getLog(this.getClass());
    private String type;
    private Map cache = Collections.synchronizedMap(new ReferenceMap());

    public AutoCache() {
    }

    public AutoCache(String cacheType) {
        this.setType(cacheType);
    }

    public void setType(String cacheType) {
        this.log.debug((Object)("Cache type set to '" + cacheType + "'."));
        this.type = cacheType;
    }

    public String getType() {
        return this.type;
    }

    public void put(Serializable key, Object object) {
        this.cache.put(key, object);
        this.log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
    }

    public Object get(Serializable key) {
        Object object = this.cache.get(key);
        if (object != null) {
            this.log.debug((Object)("Got " + this.type + " #" + key + " from cache."));
        }
        return object;
    }

    public Object clear(Serializable key) {
        this.log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        return this.cache.remove(key);
    }

    public void clearAll() {
        this.log.debug((Object)("Cleared entire " + this.type + " cache."));
        this.cache = Collections.synchronizedMap(new WeakHashMap());
    }
}

