/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.html;

import java.net.URLEncoder;
import java.util.Dictionary;
import org.apache.commons.lang.StringUtils;
import org.makumba.HtmlUtils;
import org.makumba.MakumbaSystem;
import org.makumba.Text;
import org.makumba.commons.SingletonReleaser;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.InvalidValueException;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.list.html.FieldViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class textViewer
extends FieldViewer {
    static String[] params = new String[]{"default", "empty", "lineSeparator", "longLineLength", "html", "format"};
    static String[][] paramValues = new String[][]{null, null, null, null, {"true", "false", "auto"}, {"raw", "htmlescape", "stripHTML", "urlencode", "wiki", "auto"}};
    static int screenLength = 30;

    @Override
    public String[] getAcceptedParams() {
        return params;
    }

    @Override
    public String[][] getAcceptedValue() {
        return paramValues;
    }

    private textViewer() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    @Override
    public String formatNotNull(RecordFormatter rf, int fieldIndex, Object o, Dictionary<String, Object> formatParams) {
        int n;
        if (o instanceof Text) {
            o = ((Text)o).getString();
        }
        String txt = o.toString();
        String html = (String)formatParams.get("html");
        String format = (String)formatParams.get("format");
        if (html != null && format != null) {
            throw new InvalidValueException(rf.expr[fieldIndex], "invalid combination of parameters 'html' and 'format'. 'html' is deprecated, please use only 'format'.");
        }
        if (StringUtils.equals((String)html, (String)"true") || StringUtils.equals((String)format, (String)"raw") || StringUtils.equals((String)html, (String)"auto") && HtmlUtils.detectHtml(txt) || StringUtils.equals((String)format, (String)"auto") && HtmlUtils.detectHtml(txt)) {
            return txt;
        }
        if (StringUtils.equals((String)html, (String)"wiki") || StringUtils.equals((String)format, (String)"wiki")) {
            return MakumbaSystem.getWikiFormatter().wiki2html(txt);
        }
        if (StringUtils.equals((String)format, (String)"urlencode")) {
            return URLEncoder.encode(txt);
        }
        if (StringUtils.equals((String)format, (String)"stripHTML")) {
            txt = HtmlUtils.stripHTMLTags(txt);
        }
        String startSeparator = "<p>";
        String endSeparator = "</p>";
        String s = (String)formatParams.get("lineSeparator");
        if (s != null) {
            startSeparator = s;
            endSeparator = "";
        }
        if ((n = this.getIntParam(rf, fieldIndex, formatParams, "longLineLength")) == -1) {
            n = screenLength;
        }
        if (HtmlUtils.maxLineLength(txt) > n) {
            return HtmlUtils.text2html(txt, startSeparator, endSeparator);
        }
        if (txt.indexOf(10) < 0) {
            return HtmlUtils.string2html(txt);
        }
        return "<pre style=\"margin:0px\">" + HtmlUtils.string2html(txt) + "</pre>";
    }

    private static final class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        static FieldFormatter singleton = new textViewer();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

