/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import antlr.collections.AST;
import java.net.URL;
import java.util.HashMap;
import org.makumba.MakumbaError;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.FunctionNode;
import org.makumba.providers.datadefinition.mdd.MDDAnalyzeBaseWalker;
import org.makumba.providers.datadefinition.mdd.MDDFactory;
import org.makumba.providers.datadefinition.mdd.MDDNode;
import org.makumba.providers.datadefinition.mdd.MDDParser;
import org.makumba.providers.datadefinition.mdd.MDDProvider;
import org.makumba.providers.datadefinition.mdd.ValidationRuleNode;
import org.makumba.providers.datadefinition.mdd.ValidationType;
import org.makumba.providers.datadefinition.mdd.validation.ComparisonValidationRule;
import org.makumba.providers.datadefinition.mdd.validation.MultiUniquenessValidationRule;
import org.makumba.providers.datadefinition.mdd.validation.RangeValidationRule;
import org.makumba.providers.datadefinition.mdd.validation.RegExpValidationRule;

public class MDDAnalyzeWalker
extends MDDAnalyzeBaseWalker {
    private MDDFactory factory = null;
    private MDDParser parser = null;
    protected HashMap<String, FieldNode> typeShorthands = new HashMap();
    private boolean strictTypeCheck;

    public MDDAnalyzeWalker(String typeName, URL origin, MDDFactory factory, MDDParser parser, boolean strictTypeCheck) {
        this.origin = origin;
        this.typeName = typeName;
        this.mdd = new MDDNode(typeName, origin);
        this.factory = factory;
        this.parser = parser;
        this.strictTypeCheck = strictTypeCheck;
    }

    protected void checkFieldType(AST type, FieldNode field) {
        if (type == null) {
            return;
        }
        switch (type.getType()) {
            case 65: {
                int l;
                AST length = type.getFirstChild();
                if (length == null || (l = Integer.parseInt(length.getText())) <= 255) break;
                this.factory.doThrow(this.typeName, "char has a maximum length of 255", type);
                break;
            }
            case 78: {
                this.checkPointed(type);
                break;
            }
            case 79: {
                this.checkPointed(type);
                this.checkModifiers(type, field);
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                this.checkModifiers(type, field);
            }
        }
    }

    private void checkModifiers(AST type, FieldNode field) {
        if (field.unique) {
            this.factory.doThrow(this.typeName, "sets can't be unique", type);
        }
    }

    private void checkPointed(AST type) {
        URL u;
        AST pointedType = type.getFirstChild();
        if (this.strictTypeCheck && (u = MDDProvider.findDataDefinition(pointedType.getText(), "mdd")) == null) {
            this.factory.doThrow(this.typeName, "could not find type " + pointedType.getText(), pointedType);
        }
    }

    protected void checkSubFieldType(AST type, FieldNode field) {
        this.checkFieldType(type, field);
    }

    protected void checkSubFieldName(String parentName, AST name) {
        if (parentName != null && name != null && !parentName.equals(name.getText())) {
            this.factory.doThrow(this.typeName, "The subfield '" + name.getText() + "'" + " should have as parent name " + parentName, name);
        }
    }

    protected FieldNode getParentField(AST parentField) {
        FieldNode f = null;
        if (parentField.getText().indexOf("->") > -1) {
            String path = parentField.getText();
            MDDNode searchMDD = this.mdd;
            while (path.indexOf("->") > -1) {
                String p = path.substring(0, path.indexOf("->"));
                path = path.substring(path.indexOf("->") + 2, path.length());
                FieldNode parent = searchMDD.fields.get(p);
                if (parent == null) {
                    this.factory.doThrow(this.typeName, "Field " + p + " does not exist.", parentField);
                }
                searchMDD = parent.subfield;
            }
            f = searchMDD.fields.get(path);
        } else {
            f = this.mdd.fields.get(parentField.getText());
        }
        if (f == null) {
            this.factory.doThrow(this.typeName, "Field " + parentField.getText() + " does not exist.", parentField);
        }
        f.initSubfield();
        return f;
    }

    protected void addTypeShorthand(AST name, FieldNode fieldType) {
        this.typeShorthands.put(name.getText(), fieldType);
    }

    protected void addModifier(FieldNode field, String modifier) {
        if (modifier.equals("unique")) {
            field.unique = true;
        } else if (modifier.equals("not null")) {
            field.notNull = true;
        } else if (modifier.equals("fixed")) {
            field.fixed = true;
        } else if (modifier.equals("not empty")) {
            field.notEmpty = true;
        } else {
            throw new MakumbaError("Modifier " + modifier + " invalid");
        }
    }

    protected void addField(MDDNode mdd, FieldNode field) {
        FieldNode previous = mdd.fields.get(field.name);
        if (previous != null && (previous.wasIncluded || field.wasIncluded)) {
            mdd.fields.remove(field.name);
            mdd.addField(field);
        } else if (previous != null && !previous.wasIncluded && !field.wasIncluded) {
            this.factory.doThrow(this.typeName, "Duplicated field definition for field " + field.name, (AST)field);
        } else {
            mdd.addField(field);
        }
    }

    protected void addSubfield(FieldNode parent, FieldNode field) {
        FieldNode previous = parent.subfield.fields.get(field.name);
        if (previous != null && (previous.wasIncluded || field.wasIncluded || parent.wasIncluded)) {
            parent.subfield.fields.remove(field.name);
            parent.subfield.addField(field);
        } else if (!(previous == null || previous.wasIncluded || field.wasIncluded || parent.wasIncluded)) {
            this.factory.doThrow(this.typeName, "Duplicated field definition for subfield " + field.name, (AST)field);
        } else {
            parent.subfield.addField(field);
        }
    }

    protected void addFunction(MDDNode mdd, FunctionNode function, AST originalFunctionDeclaration, FieldNode subField) {
        MDDNode mddNode = null;
        mddNode = subField != null ? subField.subfield : mdd;
        if (mddNode.functions.containsKey(function.name)) {
            this.factory.doThrow(this.typeName, "Duplicate function " + function.name, (AST)function);
        }
        mddNode.addFunction(function, this.parser.parsedFunctions.get(originalFunctionDeclaration));
    }

    protected void addMultiUniqueKey(ValidationRuleNode v, AST path) {
        v.multiUniquenessFields.add(path.getText());
    }

    protected ValidationRuleNode createMultiFieldValidationRule(AST originAST, ValidationType type, FieldNode subField) {
        switch (type) {
            case UNIQUENESS: {
                MultiUniquenessValidationRule n = new MultiUniquenessValidationRule(this.mdd, originAST, type, subField);
                return n;
            }
            case COMPARISON: {
                ComparisonValidationRule comparison = new ComparisonValidationRule(this.mdd, originAST, type, subField);
                return comparison;
            }
        }
        throw new RuntimeException("no matching validation rule found!");
    }

    protected ValidationRuleNode createSingleFieldValidationRule(AST originAST, String fieldName, ValidationType type, FieldNode subField) {
        FieldNode f = null;
        if (subField != null) {
            f = subField.subfield.fields.get(fieldName);
            if (f == null) {
                this.factory.doThrow(this.typeName, "Subfield " + fieldName + " does not exist in field " + subField.subfield.getName(), originAST);
            }
        } else {
            f = this.mdd.fields.get(fieldName);
            if (f == null) {
                this.factory.doThrow(this.typeName, "Field " + fieldName + " does not exist in type " + this.mdd.getName(), originAST);
            }
        }
        switch (type) {
            case RANGE: 
            case LENGTH: {
                return new RangeValidationRule(this.mdd, originAST, f, type);
            }
            case REGEX: {
                return new RegExpValidationRule(this.mdd, originAST, f, type);
            }
        }
        throw new RuntimeException("no matching validation rule found");
    }

    protected void addValidationRuleArgument(String name, ValidationRuleNode n) {
        n.arguments.add(name);
    }

    protected void checkRuleApplicability(ValidationRuleNode validation) {
        try {
            validation.checkApplicability();
        }
        catch (Throwable t) {
            this.factory.doThrow(this.typeName, t.getMessage(), (AST)validation);
        }
    }

    protected void addNativeValidationRuleMessage(AST fieldName, AST errorType, String message) {
        FieldNode f = this.mdd.fields.get(fieldName.getText());
        if (f == null) {
            this.factory.doThrow(this.typeName, "Field " + fieldName.getText() + " does not exist", fieldName);
        }
        switch (errorType.getType()) {
            case 85: {
                f.uniqueError = message;
                break;
            }
            case 87: {
                f.notNullError = message;
                break;
            }
            case 88: {
                f.NaNError = message;
                break;
            }
            case 89: {
                f.notEmptyError = message;
                break;
            }
            case 90: {
                f.notIntError = message;
                break;
            }
            case 91: {
                f.notRealError = message;
                break;
            }
            case 92: {
                f.notBooleanError = message;
            }
        }
    }
}

