/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.analyser.engine.JavaParseData;
import org.makumba.analyser.engine.SourceSyntaxPoints;
import org.makumba.analyser.engine.SyntaxPoint;
import org.makumba.analyser.engine.TomcatJsp;
import org.makumba.commons.ClassResource;
import org.makumba.commons.StringUtils;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.JavaSourceAnalyzer;
import org.makumba.devel.LineViewer;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;

public class javaViewer
extends LineViewer {
    public static Map<String, String> javaSyntaxProperties = Configuration.getJavaViewerSyntaxStyles();
    private static DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    private boolean compiledJSP = false;
    private boolean haveFile = false;
    private SourceSyntaxPoints syntaxPoints;
    private SyntaxPoint[] sourceSyntaxPoints;
    private JavaParseData javaParseData;

    public javaViewer(HttpServletRequest req) throws Exception {
        super(true, req);
        this.jspClasspath = TomcatJsp.getContextCompiledJSPDir(this.request.getSession().getServletContext());
        this.contextPath = req.getContextPath();
        this.virtualPath = DevelUtils.getVirtualPath(req, Configuration.getJavaViewerLocation());
        this.virtualPath = this.virtualPath == null ? "/" : this.virtualPath.substring(1);
        URL url = this.virtualPath.endsWith(".java") ? ClassResource.get(this.virtualPath) : ClassResource.get(this.virtualPath.replace('.', '/') + ".java");
        if (url != null) {
            this.setSearchLevels(false, false, false, true);
            this.haveFile = true;
        } else {
            String filePath = this.jspClasspath + "/" + this.virtualPath.replace('.', '/') + ".java";
            File jspClassFile = new File(filePath);
            if (jspClassFile.exists()) {
                url = new URL("file://" + filePath);
                this.setSearchLevels(false, false, false, true);
                this.compiledJSP = true;
                this.haveFile = true;
            } else {
                String s = this.virtualPath;
                if (s.startsWith("/")) {
                    s = s.substring(1);
                }
                url = ClassResource.get(s.replace('.', '/'));
            }
        }
        if (this.haveFile) {
            this.javaParseData = JavaParseData.getParseData("/", url.getFile(), JavaSourceAnalyzer.getInstance());
            this.javaParseData.getAnalysisResult(null);
            this.syntaxPoints = this.javaParseData.getSyntaxPoints();
            this.sourceSyntaxPoints = this.javaParseData.getSyntaxPoints().getSyntaxPoints();
            this.addImportedPackages(this.javaParseData.getImportedPackages());
            this.importedClasses = this.javaParseData.getImportedClasses();
        }
        this.readFromURL(url);
    }

    public String parseLine(String s) {
        if (s.length() == 0 || s.trim().length() == 0) {
            return s;
        }
        String result = super.parseLine(s);
        if (this.compiledJSP) {
            return result;
        }
        for (String keyWord : javaSyntaxProperties.keySet()) {
            String substitute = keyWord + " ";
            if (javaSyntaxProperties.get(keyWord) == null || !result.contains(substitute)) continue;
            result = result.replaceAll(substitute, "<span style=\"" + javaSyntaxProperties.get(keyWord) + "\">" + keyWord + "</span> ");
        }
        return result;
    }

    public void parseText(PrintWriter writer) throws IOException {
        long begin = System.currentTimeMillis();
        this.printPageBegin(writer);
        SyntaxPoint lastSyntaxPoint = null;
        int insideComment = 0;
        for (int j = 0; this.sourceSyntaxPoints != null && j < this.sourceSyntaxPoints.length; ++j) {
            SyntaxPoint currentSyntaxPoint = this.sourceSyntaxPoints[j];
            String type = currentSyntaxPoint.getType();
            int currentLine = currentSyntaxPoint.getLine();
            if (type.equals("TextLine") && currentSyntaxPoint.isBegin()) {
                if (this.printLineNumbers) {
                    writer.print("\n");
                    if (!this.hideLineNumbers) {
                        writer.print("<a style=\"font-style: normal; \" name=\"" + currentLine + "\" href=\"#" + currentLine + "\" class=\"lineNo\">" + currentLine + ":\t</a>");
                    }
                }
            } else {
                String beforeSyntaxPoint = this.syntaxPoints.getLineText(currentLine).substring(lastSyntaxPoint.getColumn() - 1, currentSyntaxPoint.getColumn() - 1);
                if (type.equals("TextLine") && !currentSyntaxPoint.isBegin()) {
                    writer.print(this.parseLine(this.htmlEscape(beforeSyntaxPoint)));
                } else if (currentSyntaxPoint.isBegin()) {
                    if (JavaParseData.isCommentSyntaxPoint(currentSyntaxPoint.getType())) {
                        ++insideComment;
                    }
                    writer.print(this.parseLine(this.htmlEscape(beforeSyntaxPoint)));
                    if (!(JavaParseData.isClassUsageSyntaxPoint(currentSyntaxPoint.getType()) || insideComment > 0 && currentSyntaxPoint.getType().equals("JavaStringLiteral") || javaSyntaxProperties.get(type) == null)) {
                        writer.print("<span style=\"" + javaSyntaxProperties.get(type) + "; \">");
                    }
                } else {
                    if (JavaParseData.isCommentSyntaxPoint(currentSyntaxPoint.getType())) {
                        --insideComment;
                    }
                    if (JavaParseData.isClassUsageSyntaxPoint(currentSyntaxPoint.getType())) {
                        Class<?> webappClass = this.findClass(beforeSyntaxPoint);
                        String classLink = null;
                        if (webappClass == null) {
                            webappClass = this.findClassSimple(beforeSyntaxPoint);
                        }
                        if (webappClass != null) {
                            classLink = this.formatClassLink(webappClass, null, beforeSyntaxPoint);
                        }
                        if (classLink != null) {
                            writer.print(classLink);
                        } else {
                            writer.print(beforeSyntaxPoint);
                        }
                        writer.print("</a>");
                    } else if (currentSyntaxPoint.getType().equals("JavaMethodInvocation")) {
                        String object = null;
                        String method = null;
                        String[] parts = null;
                        parts = beforeSyntaxPoint.indexOf(".") != -1 ? beforeSyntaxPoint.split("\\.") : this.syntaxPoints.getLineText(currentLine).substring(this.sourceSyntaxPoints[j - 2].getColumn() - 1, currentSyntaxPoint.getColumn() - 1).split("\\.");
                        if (parts.length > 1) {
                            object = parts[0];
                            method = parts[1];
                        }
                        Class<?> variableClass = null;
                        String classLink = null;
                        if (object.equals("super")) {
                            variableClass = this.findClass(this.javaParseData.getSuperClass());
                            classLink = this.formatClassLink(variableClass, method, beforeSyntaxPoint);
                        } else if (!object.equals("this")) {
                            String className = this.javaParseData.getDefinedObjectClassName(object, currentSyntaxPoint.getPosition());
                            if (className == null) {
                                className = object;
                            }
                            if (className != null) {
                                variableClass = this.findClass(className);
                                classLink = variableClass != null ? object + "." + this.formatClassLink(variableClass, method, method) : object + "." + method;
                            }
                        }
                        if (classLink != null) {
                            writer.print(classLink);
                        } else {
                            writer.print(beforeSyntaxPoint);
                        }
                        this.javaParseData.getViewedClass();
                    } else if (currentSyntaxPoint.getType().equals("MakumbaFormHandler")) {
                        String[] parts = this.splitHandlerMethodName(beforeSyntaxPoint);
                        DataDefinition dd = null;
                        if (parts != null) {
                            String mddName = this.findMddNameFromHandler(parts[1]);
                            try {
                                dd = ddp.getDataDefinition(mddName);
                                writer.print(parts[0] + "<a href=\"" + this.contextPath + Configuration.getMddViewerLocation() + dd.getName() + "\" title=\"'" + parts[2] + "'-handler for " + dd.getName() + "\" class=\"classLink\">" + parts[1] + "</a>");
                            }
                            catch (DataDefinitionNotFoundError e) {
                                mddName = this.findMddNameFromHandler(parts[1], true);
                                try {
                                    dd = ddp.getDataDefinition(mddName);
                                    DataDefinition parentDd = dd.getParentField().getDataDefinition();
                                    writer.print(parts[0] + "<a href=\"" + this.contextPath + Configuration.getMddViewerLocation() + "/" + parentDd.getName() + "\" title=\"'" + parts[2] + "'-handler for " + dd.getName() + "\" class=\"classLink\">" + parts[1] + "</a>");
                                }
                                catch (DataDefinitionNotFoundError e1) {
                                }
                                catch (NullPointerException e1) {
                                    // empty catch block
                                }
                            }
                        }
                        if (dd == null) {
                            writer.print(this.parseLine(this.htmlEscape(beforeSyntaxPoint)));
                        }
                    } else {
                        writer.print(this.parseLine(this.htmlEscape(beforeSyntaxPoint)));
                        if (!(insideComment > 0 && currentSyntaxPoint.getType().equals("JavaStringLiteral") || javaSyntaxProperties.get(type) == null)) {
                            writer.print("</span>");
                        }
                    }
                }
            }
            lastSyntaxPoint = currentSyntaxPoint;
        }
        this.printPageEnd(writer);
        double timeTaken = System.currentTimeMillis() - begin;
        Logger.getLogger("org.makumba.org.makumba.devel.sourceViewer").info("Java sourcecode viewer took :" + timeTaken / 1000.0 + " seconds");
    }

    private String findMddNameFromHandler(String encodedMddName) {
        return this.findMddNameFromHandler(encodedMddName, false);
    }

    private String findMddNameFromHandler(String encodedMddName, boolean upperCaseSecondButLast) {
        String mddName = "";
        ArrayList<String> partList = new ArrayList<String>();
        Pattern camelCase = Pattern.compile("[A-Z]");
        Matcher m = camelCase.matcher(encodedMddName);
        int currentPos = 0;
        while (m.find()) {
            if (m.start() <= currentPos) continue;
            String s = encodedMddName.substring(currentPos, m.start());
            partList.add(s);
            currentPos = m.start();
        }
        partList.add(encodedMddName.substring(currentPos));
        String[] parts = partList.toArray(new String[partList.size()]);
        for (int i = 0; i < parts.length; ++i) {
            if (upperCaseSecondButLast) {
                if (i + 2 < parts.length) {
                    mddName = mddName + StringUtils.lowerCaseBeginning(parts[i]) + ".";
                    continue;
                }
                if (i + 2 == parts.length) {
                    mddName = mddName + parts[i] + ".";
                    continue;
                }
                mddName = mddName + StringUtils.lowerCaseBeginning(parts[i]);
                continue;
            }
            mddName = i + 1 < parts.length ? mddName + StringUtils.lowerCaseBeginning(parts[i]) + "." : mddName + parts[i];
        }
        return mddName;
    }

    private String[] splitHandlerMethodName(String handlerName) {
        String encodedMddName = null;
        String[] formTypes = new String[]{"on_new", "on_edit", "on_add", "on_delete"};
        for (int i = 0; encodedMddName == null && i < formTypes.length; ++i) {
            if (handlerName.indexOf(formTypes[i]) == -1) continue;
            encodedMddName = handlerName.substring(formTypes[i].length());
        }
        String type = handlerName.substring(handlerName.indexOf("on_") + "on_".length(), handlerName.indexOf(encodedMddName));
        return new String[]{handlerName.substring(0, handlerName.indexOf(encodedMddName)), encodedMddName, type.substring(0, 1).toUpperCase() + type.substring(1)};
    }

    public void intro(PrintWriter w) {
        w.println("<td align=\"right\" >");
        this.printFileRelations(w);
        w.println("&nbsp;&nbsp;&nbsp;");
        w.println("<span style=\"color:lightblue; background-color: darkblue; padding: 5px;\">Java</span>");
        String p = this.virtualPath;
        if (p.endsWith(".java")) {
            p = p.substring(0, p.indexOf(".java"));
        }
        p = p.replaceAll("\\.", "/");
        String path = this.contextPath + Configuration.getJavaViewerLocation() + p.substring(0, p.lastIndexOf(47) + 1);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        w.println("&nbsp;&nbsp;&nbsp;");
        w.println("<a href=\"/" + path + "\"><font color=\"darkblue\">browse</font></a>");
        w.println("&nbsp;&nbsp;&nbsp;");
        DevelUtils.writeDevelUtilLinks(w, "javaViewer", this.contextPath);
        w.println("</td>");
    }
}

