/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.util.StringLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class FocusControl
extends ControlAdapter {
    private String group = Visualization.FOCUS_ITEMS;
    protected String activity;
    protected VisualItem curFocus;
    protected int ccount;
    protected int button = 16;
    protected Predicate filter = null;

    public FocusControl() {
        this(1);
    }

    public FocusControl(String focusGroup) {
        this(1);
        this.group = focusGroup;
    }

    public FocusControl(int clicks) {
        this.ccount = clicks;
    }

    public FocusControl(String focusGroup, int clicks) {
        this.ccount = clicks;
        this.group = focusGroup;
    }

    public FocusControl(int clicks, String act) {
        this.ccount = clicks;
        this.activity = act;
    }

    public FocusControl(String focusGroup, int clicks, String act) {
        this.ccount = clicks;
        this.activity = act;
        this.group = focusGroup;
    }

    public void setFilter(Predicate p) {
        this.filter = p;
    }

    public Predicate getFilter() {
        return this.filter;
    }

    protected boolean filterCheck(VisualItem item) {
        if (this.filter == null) {
            return true;
        }
        try {
            return this.filter.getBoolean(item);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).warning(e.getMessage() + "\n" + StringLib.getStackTrace(e));
            return false;
        }
    }

    public void itemEntered(VisualItem item, MouseEvent e) {
        if (!this.filterCheck(item)) {
            return;
        }
        Display d = (Display)e.getSource();
        d.setCursor(Cursor.getPredefinedCursor(12));
        if (this.ccount == 0) {
            Visualization vis = item.getVisualization();
            TupleSet ts = vis.getFocusGroup(this.group);
            ts.setTuple(item);
            this.curFocus = item;
            this.runActivity(vis);
        }
    }

    public void itemExited(VisualItem item, MouseEvent e) {
        if (!this.filterCheck(item)) {
            return;
        }
        Display d = (Display)e.getSource();
        d.setCursor(Cursor.getDefaultCursor());
        if (this.ccount == 0) {
            this.curFocus = null;
            Visualization vis = item.getVisualization();
            TupleSet ts = vis.getFocusGroup(this.group);
            ts.removeTuple(item);
            this.runActivity(vis);
        }
    }

    public void itemClicked(VisualItem item, MouseEvent e) {
        if (!this.filterCheck(item)) {
            return;
        }
        if (UILib.isButtonPressed(e, this.button) && e.getClickCount() == this.ccount) {
            if (item != this.curFocus) {
                Visualization vis = item.getVisualization();
                TupleSet ts = vis.getFocusGroup(this.group);
                boolean ctrl = e.isControlDown();
                if (!ctrl) {
                    this.curFocus = item;
                    ts.setTuple(item);
                } else if (ts.containsTuple(item)) {
                    ts.removeTuple(item);
                } else {
                    ts.addTuple(item);
                }
                this.runActivity(vis);
            } else if (e.isControlDown()) {
                Visualization vis = item.getVisualization();
                TupleSet ts = vis.getFocusGroup(this.group);
                ts.removeTuple(item);
                this.curFocus = null;
                this.runActivity(vis);
            }
        }
    }

    private void runActivity(Visualization vis) {
        if (this.activity != null) {
            vis.run(this.activity);
        }
    }
}

