/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.condition;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.condition.Condition;
import com.thoughtworks.selenium.condition.ConditionRunner;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class DefaultConditionRunner
implements ConditionRunner {
    private final Monitor monitor;
    private final Selenium selenium;
    private final int initialDelay;
    private final int interval;
    private final int timeout;

    public DefaultConditionRunner(Monitor monitor, Selenium selenium, int initialDelay, int interval, int timeout) {
        this.monitor = monitor;
        this.selenium = selenium;
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.timeout = timeout;
    }

    public DefaultConditionRunner(Monitor monitor, Selenium selenium, int interval, int timeout) {
        this(new NoOpMonitor(), selenium, interval, interval, timeout);
    }

    public DefaultConditionRunner(Selenium selenium, int initialDelay, int interval, int timeout) {
        this(new NoOpMonitor(), selenium, initialDelay, interval, timeout);
    }

    public DefaultConditionRunner(Selenium selenium, int interval, int timeout) {
        this(new NoOpMonitor(), selenium, interval, timeout);
    }

    public DefaultConditionRunner(Selenium selenium) {
        this(new NoOpMonitor(), selenium, 500, 45000);
    }

    public void waitFor(Condition condition) {
        this.waitFor("", condition);
    }

    public void waitFor(String narrative, Condition condition) {
        ContextImpl context = new ContextImpl();
        SeleniumException seleniumException = null;
        try {
            this.monitor.waitHasBegun(context, condition);
            this.threadSleep(this.initialDelay);
            while (context.elapsed() < (long)context.timeout()) {
                seleniumException = null;
                try {
                    if (condition.isTrue(context)) {
                        this.monitor.conditionWasReached(context, condition);
                        return;
                    }
                }
                catch (SeleniumException se) {
                    seleniumException = se;
                }
                this.threadSleep(this.interval);
            }
        }
        catch (RuntimeException e) {
            this.throwAssertionException("Exception while waiting for '" + condition.toString() + "'", e);
        }
        if (seleniumException != null) {
            this.throwAssertionException("SeleniumException while waiting for '" + condition.toString() + "' (otherwise timed out)", seleniumException);
        }
        String message = context.failureMessage(narrative, condition);
        this.monitor.conditionFailed(context, condition, message);
        this.throwAssertionException(message);
    }

    private void threadSleep(int interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void throwAssertionException(String message) {
        throw new RuntimeException(message);
    }

    protected void throwAssertionException(String message, Throwable throwable) {
        throw new RuntimeException(message, throwable);
    }

    private final class ContextImpl
    implements ConditionRunner.Context {
        private final long start;
        private List<String> info = new ArrayList<String>();
        private String lastInfo;

        public ContextImpl() {
            this.start = this.now();
        }

        private long now() {
            return System.currentTimeMillis();
        }

        public void info(String info) {
            if (!info.equals(this.lastInfo)) {
                this.info.add(info);
            }
            this.lastInfo = info;
        }

        public long elapsed() {
            return this.now() - this.start;
        }

        public Selenium getSelenium() {
            return DefaultConditionRunner.this.selenium;
        }

        public ConditionRunner getConditionRunner() {
            return DefaultConditionRunner.this;
        }

        private String failureMessage(String narrative, Condition condition) {
            String message = condition.toString() + " failed to become true within " + this.timeout() + " msec";
            message = message + (narrative.equals("") ? "" : "; " + narrative);
            if (!this.info.isEmpty()) {
                message = message + "; " + this.info;
            }
            return message;
        }

        private int timeout() {
            return DefaultConditionRunner.this.timeout;
        }
    }

    public static final class Log4jMonitor
    implements Monitor {
        private static final Logger logger = Logger.getLogger(DefaultConditionRunner.class.getName());

        public void conditionWasReached(ConditionRunner.Context context, Condition condition) {
            this.log("Reached " + condition.toString());
        }

        public void waitHasBegun(ConditionRunner.Context context, Condition condition) {
            this.log("Waiting for " + condition.toString());
        }

        public void conditionFailed(ConditionRunner.Context context, Condition condition, String message) {
            this.log(message);
        }

        protected void log(String message) {
            logger.info(new Date() + " - " + message);
        }
    }

    public static final class NoOpMonitor
    implements Monitor {
        public void waitHasBegun(ConditionRunner.Context context, Condition condition) {
        }

        public void conditionWasReached(ConditionRunner.Context context, Condition condition) {
        }

        public void conditionFailed(ConditionRunner.Context context, Condition condition, String message) {
        }
    }

    public static interface Monitor {
        public void waitHasBegun(ConditionRunner.Context var1, Condition var2);

        public void conditionWasReached(ConditionRunner.Context var1, Condition var2);

        public void conditionFailed(ConditionRunner.Context var1, Condition var2, String var3);
    }
}

