///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: CodeGeneratorTemplate.java 3596 2009-01-08 02:07:19Z rosso_nero $
//  $Name$
/////////////////////////////////////

package org.makumba.devel;

import java.util.Map;
import java.util.Properties;

import org.makumba.commons.MakumbaJspAnalyzer;

/**
 * This class defines a template for JSP files generated by the code generator. Templates are stored and read from
 * {@link Properties} files. Makumba defines some code templates internally; custom templates can be defined by users
 * and put into a directory called <code>codeTemplates</code> in the classes path of the web application.
 * 
 * @author rudi
 * @version $Id: CodeGeneratorTemplate.java 3596 2009-01-08 02:07:19Z rosso_nero $
 */
public class CodeGeneratorTemplate {
    static final String DEFAULT_STYLE_HEADER = "<%@ taglib uri=\"http://java.sun.com/jstl/core_rt\" prefix=\"c\" %>\n";

    String afterField;

    String afterFieldName;

    String afterFieldTag;

    String afterFormBegin;

    String beforeField;

    String beforeFieldName;

    String beforeFieldTag;

    String beforeFormEnd;

    String footer;

    String header;

    String beforePageHeader;

    String afterPageHeader;

    String beforePageHeaderLevel2;

    String afterPageHeaderLevel2;

    public CodeGeneratorTemplate() {
    }

    public CodeGeneratorTemplate(Map<String, String> props, String queryLanguage) {
        if (queryLanguage.equals(MakumbaJspAnalyzer.QL_OQL)) {
            header = CodeGenerator.OQL_TLD_DEFINITION;
        } else if (queryLanguage.equals(MakumbaJspAnalyzer.QL_HQL)) {
            header = CodeGenerator.HQL_TLD_DEFINITION;
        }
        header += "\n";
        header += (String) getProperty(props, "header", DEFAULT_STYLE_HEADER);
        footer = (String) getProperty(props, "footer");
        afterFormBegin = (String) getProperty(props, "afterFormBegin");
        beforeFormEnd = (String) getProperty(props, "beforeFormEnd");
        beforeField = (String) getProperty(props, "beforeField");
        afterField = (String) getProperty(props, "afterField");
        beforeFieldName = (String) getProperty(props, "beforeFieldName");
        afterFieldName = (String) getProperty(props, "afterFieldName");
        beforeFieldTag = (String) getProperty(props, "beforeFieldTag");
        afterFieldTag = (String) getProperty(props, "afterFieldTag");
        beforePageHeader = (String) getProperty(props, "beforePageHeader");
        afterPageHeader = (String) getProperty(props, "afterPageHeader");
        beforePageHeaderLevel2 = (String) getProperty(props, "beforePageHeaderLevel2", beforePageHeader);
        afterPageHeaderLevel2 = (String) getProperty(props, "afterPageHeaderLevel2", afterPageHeader);
    }

    String getProperty(Map<String, String> map, String key) {
        return getProperty(map, key, "");
    }

    String getProperty(Map<String, String> map, String key, String defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        } else {
            return defaultValue;
        }
    }
}
