package com.ecyrd.jspwiki;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

public class BestTranslatorReader extends TranslatorReader {

    public BestTranslatorReader(Reader in) {
        super(in);
        // TODO Auto-generated constructor stub
    }

    /**
     * @param args
     * @throws IOException
     * @throws WikiException
     */
    public static void main(String[] args) throws IOException, WikiException {
        TestEngine testEngine;
        Properties props = new Properties();
        props.put("jspwiki.workDir", ".");
        props.put("jspwiki.pageProvider",
                "com.ecyrd.jspwiki.providers.FileSystemProvider");
        props.put("jspwiki.fileSystemProvider.pageDir", "@tests.pagedir@");
        // props.load( TestEngine.findTestProperties() );

        testEngine = new TestEngine(props);

        // new BestTranslatorReader(new StringReader("bla|bla|bla|bla")).;
        WikiContext context = new WikiContext(testEngine, new WikiPage(
                "TestPage"));
        String t = "!!Planned meetings and activities by ITC during GA 06:\n"
                + "!!! Meetings organised\n"
                + "# BAS meeting\n"
                + "** details pending (time, attendance)\n"
                + "# Design of Duplicate accounts\n"
                + "** details pending (time, attendance)\n"
                + "# [Wiki meeting|WikiGA06] - 22nd Lunch\n"
                + "# Makumba party\n"
                + "** details pending (time, attendance)\n"
                + "\n"
                + "!!!Proposed meetings:\n"
                + "# Accessability comformance to ITC developed systems presentation by Vilius\n"
                + "** idea is to show 10 min PPT presentation for developers and designers on accessibility requirements defined by [Web Content Accessibility Guidelines 2.0|http://www.w3.org/WAI/GL/WCAG20] and gather instant feedback. Timing - lunch, dinner, or coffee break. [Drafts of slides|PA:archive/doc/l0hnf89/ITC+session+of+Accessibility+on+GA06.ppt]\n"
                + "    \n" + "!!!Materials prepared:\n"
                + "# Infrastructure Maps: [PA:archive/doc/l0hncjy]\n" + "\n"
                + "!!!Trainings\n" + "# Makumba (Rudi)\n" + "# Design (Joao)\n"
                + "!!!Sessions\n" + "#\n" + "#\n" + "#\n" + "!!!Proposals\n";

        TranslatorReader r = new TranslatorReader(context, new BufferedReader(
                new StringReader(t)));
        System.out.println(r.ready());

        String result = FileUtil.readContents(r);
        System.out.println(result);

    }

}
