/*
 * Decompiled with CFR 0.152.
 */
package org.securityfilter.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.securityfilter.filter.SavedRequest;
import org.securityfilter.realm.SecurityRealmInterface;

public class SecurityRequestWrapper
extends HttpServletRequestWrapper {
    public static final String PRINCIPAL_SESSION_KEY = (class$org$securityfilter$filter$SecurityRequestWrapper == null ? (class$org$securityfilter$filter$SecurityRequestWrapper = SecurityRequestWrapper.class$("org.securityfilter.filter.SecurityRequestWrapper")) : class$org$securityfilter$filter$SecurityRequestWrapper).getName() + ".PRINCIPAL";
    private HttpServletRequest currentRequest;
    private SecurityRealmInterface realm;
    private SavedRequest savedRequest;
    private String authType;
    private String matchableURL;
    static /* synthetic */ Class class$org$securityfilter$filter$SecurityRequestWrapper;

    public SecurityRequestWrapper(HttpServletRequest request, SavedRequest savedRequest, SecurityRealmInterface realm, String authType) {
        super(request);
        this.currentRequest = request;
        this.realm = realm;
        this.savedRequest = savedRequest;
        this.authType = authType;
        this.initMatchableURL();
    }

    public HttpServletRequest getCurrentRequest() {
        return this.currentRequest;
    }

    public String getParameter(String s) {
        String[] valueArray;
        if (this.savedRequest == null) {
            return this.currentRequest.getParameter(s);
        }
        String value = this.currentRequest.getParameter(s);
        if (value == null && (valueArray = (String[])this.savedRequest.getParameterMap().get(s)) != null) {
            value = valueArray[0];
        }
        return value;
    }

    public Map getParameterMap() {
        if (this.savedRequest == null) {
            return this.currentRequest.getParameterMap();
        }
        HashMap map = new HashMap(this.savedRequest.getParameterMap());
        map.putAll(this.currentRequest.getParameterMap());
        return Collections.unmodifiableMap(map);
    }

    public Enumeration getParameterNames() {
        if (this.savedRequest == null) {
            return this.currentRequest.getParameterNames();
        }
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String s) {
        if (this.savedRequest == null) {
            return this.currentRequest.getParameterValues(s);
        }
        String[] values = this.currentRequest.getParameterValues(s);
        if (values == null) {
            values = (String[])this.savedRequest.getParameterMap().get(s);
        }
        return values;
    }

    public void setRequest(ServletRequest request) {
        super.setRequest(request);
        this.currentRequest = (HttpServletRequest)request;
    }

    public boolean isUserInRole(String role) {
        return this.realm.isUserInRole(this.getUserPrincipal(), role);
    }

    public String getRemoteUser() {
        String username = null;
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            username = principal.getName();
        }
        return username;
    }

    public Principal getUserPrincipal() {
        return (Principal)this.currentRequest.getSession().getAttribute(PRINCIPAL_SESSION_KEY);
    }

    public ServletInputStream getInputStream() throws IOException {
        ServletInputStream stream = super.getInputStream();
        if (stream == null) {
            stream = this.currentRequest.getInputStream();
        }
        return stream;
    }

    public void setUserPrincipal(Principal principal) {
        this.currentRequest.getSession().setAttribute(PRINCIPAL_SESSION_KEY, (Object)principal);
    }

    public String getAuthType() {
        if (this.getUserPrincipal() != null) {
            return this.authType;
        }
        return null;
    }

    public String getMethod() {
        if (this.savedRequest != null) {
            return this.savedRequest.getMethod();
        }
        return super.getMethod();
    }

    public String getMatchableURL() {
        return this.matchableURL;
    }

    private void initMatchableURL() {
        this.matchableURL = this.currentRequest.getServletPath();
        String pathInfo = this.currentRequest.getPathInfo();
        if (pathInfo != null) {
            this.matchableURL = this.matchableURL + pathInfo;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

