/*
 * Decompiled with CFR 0.152.
 */
package org.securityfilter.filter;

import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.securityfilter.config.SecurityConstraint;
import org.securityfilter.config.WebResourceCollection;

public class URLPattern
implements Comparable {
    public static final int EXACT_TYPE = 1;
    public static final int PATH_TYPE = 2;
    public static final int EXTENSION_TYPE = 3;
    public static final int DEFAULT_TYPE = 4;
    protected String pattern;
    protected String convertedPattern;
    protected Pattern compiledPattern;
    protected SecurityConstraint constraint;
    protected WebResourceCollection resourceCollection;
    protected int order;
    protected int patternType;
    protected int pathLength;

    public URLPattern(String pattern, SecurityConstraint constraint, WebResourceCollection resourceCollection, int order, PatternCompiler compiler) throws Exception {
        this.pattern = pattern;
        this.constraint = constraint;
        this.resourceCollection = resourceCollection;
        this.order = order;
        this.initPatternType();
        this.initPathLength();
        this.initConvertedPattern();
        this.initCompiledPattern(compiler);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getCompiledPattern() {
        return this.compiledPattern;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public int getPathLength() {
        return this.pathLength;
    }

    public SecurityConstraint getSecurityConstraint() {
        return this.constraint;
    }

    public int getOrder() {
        return this.order;
    }

    public WebResourceCollection getWebResourceCollection() {
        return this.resourceCollection;
    }

    protected void initPatternType() {
        this.patternType = "/".equals(this.pattern) ? 4 : (this.pattern.startsWith("*.") ? 3 : (this.pattern.startsWith("/") && this.pattern.endsWith("/*") ? 2 : 1));
    }

    protected void initPathLength() {
        this.pathLength = -1;
        int pos = this.pattern.indexOf(47);
        while (pos != -1) {
            ++this.pathLength;
            pos = this.pattern.indexOf(47, pos + 1);
        }
    }

    protected void initConvertedPattern() {
        if (this.patternType == 4) {
            this.convertedPattern = ".*";
        } else {
            StringBuffer buf = new StringBuffer(this.pattern);
            int pos = buf.toString().indexOf(46);
            while (pos != -1) {
                buf.insert(pos, "\\");
                pos = buf.toString().indexOf(46, pos + 2);
            }
            pos = buf.toString().indexOf(42);
            while (pos != -1) {
                buf.replace(pos, pos + 1, ".*");
                pos = buf.toString().indexOf(42, pos + 2);
            }
            pos = buf.toString().indexOf(47);
            while (pos != -1) {
                buf.replace(pos, pos + 1, "/+");
                pos = buf.toString().indexOf(47, pos + 2);
            }
            switch (this.patternType) {
                case 2: {
                    buf.insert(0, '^');
                    buf.insert(buf.length() - 4, "(");
                    buf.append(")?$");
                    break;
                }
                case 3: {
                    buf.append('$');
                    break;
                }
                case 1: {
                    buf.insert(0, '^');
                    buf.append('$');
                }
            }
            this.convertedPattern = buf.toString();
        }
    }

    protected void initCompiledPattern(PatternCompiler compiler) throws Exception {
        this.compiledPattern = compiler.compile(this.convertedPattern, 32768);
    }

    public boolean equals(Object obj) {
        if (obj instanceof URLPattern) {
            URLPattern otherPattern = (URLPattern)obj;
            return this.constraint.equals(otherPattern.getSecurityConstraint()) && this.resourceCollection.equals(otherPattern.getWebResourceCollection()) && this.pattern.equals(otherPattern.getPattern());
        }
        return false;
    }

    public int compareTo(Object obj) throws ClassCastException {
        URLPattern other = (URLPattern)obj;
        if (this.equals(other)) {
            return 0;
        }
        int c = this.patternType - other.patternType;
        if (c == 0) {
            switch (this.patternType) {
                case 2: {
                    c = other.pathLength - this.pathLength;
                    if (c != 0) break;
                }
                case 1: 
                case 3: 
                case 4: {
                    c = this.order - other.order;
                }
            }
        }
        return c;
    }
}

