/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.attributes;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpParameters {
    HttpServletRequest request;
    Hashtable<Object, Object> atStart;
    Map<Object, Object> reloadedParameters = null;

    public boolean knownAtStart(String s) {
        return this.atStart.get(s) != null;
    }

    public HttpParameters(HttpServletRequest req) {
        this.request = req;
        this.computeAtStart();
    }

    public HttpParameters(HttpServletRequest req, Map<Object, Object> additionalParams) {
        this.request = req;
        this.reloadedParameters = additionalParams;
        this.computeAtStart();
        this.atStart.putAll(additionalParams);
    }

    void computeAtStart() {
        this.atStart = new Hashtable();
        Object dummy = new Object();
        Enumeration e = this.request.getParameterNames();
        while (e.hasMoreElements()) {
            this.atStart.put(e.nextElement(), dummy);
        }
    }

    public Object getParameter(String s) {
        Vector value = null;
        ArrayList<String> param = new ArrayList<String>();
        String[] params = this.request.getParameterValues(s);
        if (params != null) {
            for (String p : params) {
                param.add(p);
            }
        }
        if (this.reloadedParameters != null) {
            if (this.reloadedParameters.get(s) instanceof String) {
                param.add((String)this.reloadedParameters.get(s));
            } else if (this.reloadedParameters.get(s) instanceof String[]) {
                String[] paramValues;
                for (String v : paramValues = (String[])this.reloadedParameters.get(s)) {
                    param.add(v);
                }
            }
        }
        if (param.size() == 0) {
            return null;
        }
        if (param.size() == 1) {
            value = (Vector)param.get(0);
        } else {
            Vector v;
            value = v = new Vector();
            for (int i = 0; i < param.size(); ++i) {
                v.addElement(param.get(i));
            }
        }
        return value;
    }

    public ArrayList<String> getParametersStartingWith(String s) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration parameterNames = this.request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String param = (String)parameterNames.nextElement();
        }
        if (this.reloadedParameters != null) {
            for (String string : this.reloadedParameters.keySet()) {
                if (!string.startsWith(s)) continue;
                result.add(string);
            }
        }
        return result;
    }

    public String toString() {
        if (this.reloadedParameters == null) {
            return this.request.getParameterMap().toString();
        }
        return this.request.getParameterMap().toString() + this.reloadedParameters.toString();
    }
}

