/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import org.makumba.providers.datadefinition.mdd.FieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ValidationType {
    COMPARISON("comparison rule", new FieldType[0]),
    UNIQUENESS("uniqueness rule", FieldType.CHAR, FieldType.BOOLEAN, FieldType.DATE, FieldType.INT, FieldType.PTR, FieldType.TEXT),
    RANGE("range rule", FieldType.INT, FieldType.REAL),
    LENGTH("length rule", FieldType.CHAR, FieldType.TEXT),
    REGEX("regular expression rule", FieldType.CHAR, FieldType.TEXT);

    private FieldType[] fieldTypes;
    private String description;

    private ValidationType(String description, FieldType ... fieldType) {
        this.description = description;
        this.fieldTypes = fieldType;
    }

    public boolean checkApplicability(FieldType fieldType) {
        for (FieldType t : this.fieldTypes) {
            if (!t.equals((Object)fieldType)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public String getApplicableTypes() {
        String s = "";
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            if (i + 1 == this.fieldTypes.length && this.fieldTypes.length != 1) {
                s = s + " and ";
            }
            s = s + this.fieldTypes[i].getTypeName();
            if (i + 1 >= this.fieldTypes.length || i + 1 == this.fieldTypes.length - 1) continue;
            s = s + ", ";
        }
        return s;
    }
}

