/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.hql;

import antlr.ANTLRException;
import antlr.collections.AST;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import org.hibernate.hql.ast.HqlParser;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.FieldDefinition;
import org.makumba.OQLParseError;
import org.makumba.commons.NameResolver;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.query.hql.ExprTypeAST;
import org.makumba.providers.query.hql.HqlAnalyzeWalker;
import org.makumba.providers.query.hql.MddObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HqlAnalyzer
implements QueryAnalysis {
    private DataDefinition projTypes;
    private DataDefinition paramTypes;
    private Map<String, DataDefinition> computedLabelTypes;
    private DataDefinitionProvider ddp;
    private static final Map<Integer, String> integerTypeMap = new HashMap<Integer, String>();
    private String query;
    private HqlAnalyzeWalker walker;
    private AST parsedHQL;

    public HqlAnalyzer(String query1) {
        Date d;
        block7: {
            this.ddp = DataDefinitionProvider.getInstance();
            d = new Date();
            this.query = query1;
            HqlParser parser = HqlParser.getInstance((String)query1);
            try {
                AST t1;
                parser.statement();
                ParseErrorHandler parseErrorHandler = parser.getParseErrorHandler();
                if (parseErrorHandler.getErrorCount() > 0) {
                    parseErrorHandler.throwQueryException();
                }
                if ((t1 = (this.parsedHQL = parser.getAST())) == null) break block7;
                this.walker = new HqlAnalyzeWalker();
                this.walker.typeComputer = new MddObjectType();
                try {
                    this.walker.setDebug(query1);
                    this.walker.statement(t1);
                }
                catch (RuntimeWrappedException e1) {
                    throw new OQLParseError(" during analysis of query: " + query1, e1.getCause());
                }
                catch (RuntimeException e) {
                    throw new OQLParseError(" during analysis of query: " + query1, e);
                }
            }
            catch (QuerySyntaxException g) {
                throw new OQLParseError("during analysis of query: " + query1, g);
            }
            catch (ANTLRException f) {
                throw new OQLParseError("during analysis of query: " + query1, f);
            }
        }
        long diff = new Date().getTime() - d.getTime();
        Logger.getLogger("org.makumba.db.query.compilation").fine("HQL to SQL: " + diff + " ms: " + this.query);
    }

    @Override
    public synchronized DataDefinition getProjectionType() {
        if (this.projTypes != null) {
            return this.projTypes;
        }
        this.projTypes = this.ddp.getVirtualDataDefinition("Projections for " + this.query);
        try {
            for (int i = 0; i < this.walker.getResult().size(); ++i) {
                ExprTypeAST atom = (ExprTypeAST)((Object)this.walker.getResult().get(i));
                String name = atom.getIdentifier();
                if (name == null) {
                    name = "col" + (i + 1);
                }
                this.projTypes.addField(this.makeField(name, atom, null));
            }
        }
        catch (RuntimeWrappedException e1) {
            throw new OQLParseError(" during analysis of query: " + this.query, e1.getCause());
        }
        catch (RuntimeException e) {
            throw new OQLParseError(" during analysis of query: " + this.query, e);
        }
        return this.projTypes;
    }

    @Override
    public DataDefinition getLabelType(String labelName) {
        String labelTypeName = this.walker.getLabelTypes().get(labelName);
        if (labelTypeName == null) {
            throw new OQLParseError(" unknown label " + labelName + " in query " + this.query);
        }
        return this.ddp.getDataDefinition(labelTypeName);
    }

    @Override
    public DataDefinition getParameterTypes() {
        if (this.paramTypes != null) {
            return this.paramTypes;
        }
        this.paramTypes = this.ddp.getVirtualDataDefinition("Parameters for " + this.query);
        try {
            int parameterCounter = 0;
            for (Map.Entry e : this.walker.getParameterTypes().entrySet()) {
                this.paramTypes.addField(this.makeField((String)e.getKey(), (ExprTypeAST)((Object)e.getValue()), parameterCounter));
                ++parameterCounter;
            }
        }
        catch (RuntimeWrappedException e1) {
            throw new OQLParseError(" during analysis of query: " + this.query, e1.getCause());
        }
        catch (RuntimeException e) {
            throw new OQLParseError("during analysis of query: " + this.query, e);
        }
        return this.paramTypes;
    }

    private FieldDefinition makeField(String name, ExprTypeAST expr, Integer count) {
        FieldDefinition fd = null;
        if (expr.getObjectType() == null) {
            fd = expr.getExtraTypeInfo() != null ? this.ddp.makeFieldWithName(name, (FieldDefinition)expr.getExtraTypeInfo(), expr.getDescription()) : this.ddp.makeFieldOfType(name, this.getTypeName(expr.getDataType()), expr.getDescription());
        } else {
            if (name.equals("?")) {
                if (count == null) {
                    throw new OQLParseError("Unexpected projection name during HQL query analysis");
                }
                name = "param" + count.toString();
            }
            fd = this.ddp.makeFieldDefinition(name, "ptr " + expr.getObjectType() + ";" + expr.getDescription());
        }
        return fd;
    }

    @Override
    public int parameterNumber() {
        return this.walker.getParameterTypes().size();
    }

    @Override
    public int parameterAt(int index) {
        throw new UnsupportedOperationException("parameterAt");
    }

    String getTypeName(int i) {
        return integerTypeMap.get(new Integer(i));
    }

    public String toString() {
        String result = "Query:\n" + this.getQuery() + "\n";
        Vector<String> w = this.getProjectionType().getFieldNames();
        result = result + "Number of projections: " + w.size() + "\n";
        for (int i = 0; i < w.size(); ++i) {
            result = result + i + " FieldDef Name: " + this.getProjectionType().getFieldDefinition(i).getName() + "\n";
            result = result + i + " FieldDef Type: " + this.getProjectionType().getFieldDefinition(i).getType() + "\n";
            result = result + i + " FieldDef Comment: " + this.getProjectionType().getFieldDefinition(i).getDescription() + "\n";
        }
        return result;
    }

    private AST getSection(String sectionName) {
        boolean found = false;
        AST child = this.parsedHQL.getFirstChild();
        if (child == null) {
            return null;
        }
        while (!child.getText().equals(sectionName) || !found) {
            if ((child = child.getNextSibling()) == null) {
                return null;
            }
            if (!child.getText().equals(sectionName)) continue;
            found = true;
        }
        return found ? child : null;
    }

    public String getHackedQuery(String query) {
        if (this.getSection("order") == null) {
            return query;
        }
        String selectFrom = query.substring(7, query.toLowerCase().indexOf("from")).toLowerCase();
        Hashtable<String, String> translator = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(selectFrom, ",");
        while (st.hasMoreTokens()) {
            String[] split = st.nextToken().trim().split("\\s[a|A][s|S]\\s");
            String beforeAS = split[0];
            String afterAS = split[1];
            translator.put(afterAS, beforeAS);
        }
        String newOrderBy = new String();
        boolean done = false;
        AST arg = this.getSection("order").getFirstChild();
        while (!done) {
            newOrderBy = newOrderBy + (String)translator.get(arg.getText());
            if ((arg = arg.getNextSibling()).getText().toUpperCase().equals("ASC") || arg.getText().toUpperCase().equals("DESC")) {
                newOrderBy = newOrderBy + " " + arg.getText();
                break;
            }
            newOrderBy = newOrderBy + ", ";
        }
        int afterOrderByIndex = query.toLowerCase().indexOf("order by") + 8;
        String result = query.substring(0, afterOrderByIndex) + " " + newOrderBy;
        return result;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Map<String, DataDefinition> getLabelTypes() {
        if (this.computedLabelTypes != null) {
            return this.computedLabelTypes;
        }
        this.computedLabelTypes = new HashMap<String, DataDefinition>();
        for (String label : this.walker.getLabelTypes().keySet()) {
            DataDefinition type = null;
            try {
                type = this.ddp.getDataDefinition(this.walker.getLabelTypes().get(label));
            }
            catch (DataDefinitionNotFoundError ddnfe) {
                throw new RuntimeException("Could not find data definition for type " + this.walker.getLabelTypes().get(label) + " of label " + label + " in query " + this.getQuery());
            }
            this.computedLabelTypes.put(label, type);
        }
        return this.computedLabelTypes;
    }

    @Override
    public String writeInSQLQuery(NameResolver nr) {
        throw new RuntimeException("not implemented");
    }

    static {
        integerTypeMap.put(new Integer(0), "ptr");
        integerTypeMap.put(new Integer(1), "ptrRel");
        integerTypeMap.put(new Integer(2), "ptrOne");
        integerTypeMap.put(new Integer(3), "ptrIndex");
        integerTypeMap.put(new Integer(4), "int");
        integerTypeMap.put(new Integer(5), "intEnum");
        integerTypeMap.put(new Integer(6), "char");
        integerTypeMap.put(new Integer(7), "charEnum");
        integerTypeMap.put(new Integer(8), "text");
        integerTypeMap.put(new Integer(9), "date");
        integerTypeMap.put(new Integer(10), "dateCreate");
        integerTypeMap.put(new Integer(11), "dateModify");
        integerTypeMap.put(new Integer(12), "set");
        integerTypeMap.put(new Integer(13), "setComplex");
        integerTypeMap.put(new Integer(14), "nil");
        integerTypeMap.put(new Integer(15), "real");
        integerTypeMap.put(new Integer(16), "setcharEnum");
        integerTypeMap.put(new Integer(17), "setintEnum");
        integerTypeMap.put(new Integer(100), "parameter");
    }
}

