/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.util.Hashtable;
import java.util.Vector;
import org.makumba.MakumbaError;

public abstract class DefinitionParseError
extends MakumbaError {
    private static final long serialVersionUID = 1L;
    protected int column;
    protected Vector<DefinitionParseError> components;
    protected String line;
    protected Hashtable<String, DefinitionParseError> lines;
    protected String typeName;

    public static StringBuffer pointError(int column) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < column; ++i) {
            sb.append(' ');
        }
        return sb.append('^');
    }

    protected static String showTypeName(String typeName) {
        if (typeName.startsWith("temp")) {
            return "";
        }
        return typeName + ": ";
    }

    public DefinitionParseError() {
    }

    public DefinitionParseError(String typeName, String reason, String line) {
        this(DefinitionParseError.showTypeName(typeName) + reason + "\n" + line);
        this.typeName = typeName;
        this.line = line;
    }

    public DefinitionParseError(String explanation) {
        super(explanation);
    }

    public DefinitionParseError(Throwable reason) {
        super(reason);
    }

    public DefinitionParseError(Throwable reason, String expl) {
        super(reason, expl);
    }

    public void add(DefinitionParseError e) {
        if (this.components == null) {
            this.components = new Vector();
        }
        this.components.addElement(e);
        if (e.line != null) {
            if (this.lines == null) {
                this.lines = new Hashtable();
            }
            this.lines.put(e.line, e);
        }
    }

    public String getMessage() {
        if (this.isSingle()) {
            return super.getMessage();
        }
        StringBuffer sb = new StringBuffer();
        for (DefinitionParseError definitionParseError : this.components) {
            sb.append('\n').append(definitionParseError.getMessage()).append('\n');
        }
        return sb.toString();
    }

    public boolean isSingle() {
        return this.components == null || this.components.isEmpty();
    }

    public String getTypeName() {
        return this.typeName;
    }
}

