/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.LogicException;
import org.makumba.Pointer;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.StringUtils;
import org.makumba.commons.attributes.HttpParameters;
import org.makumba.commons.attributes.RequestAttributes;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.responder.ResponderOperation;
import org.makumba.forms.tags.FormTagBase;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.datadefinition.makumba.FieldInfo;

public class SearchTag
extends FormTagBase {
    private static final long serialVersionUID = 1L;
    public static final String ATTRIBUTE_NAME_DONE = "Done";
    public static final String ATTRIBUTE_NAME_QUERYSTRING = "QueryString";
    public static final String ATTRIBUTE_NAME_VARIABLE_FROM = "VariableFrom";
    public static final String ATTRIBUTE_NAME_WHERE = "Where";
    public static final String MATCH_AFTER = "after";
    public static final String MATCH_BEFORE = "before";
    public static final String MATCH_BEGINS = "begins";
    public static final String MATCH_BETWEEN = "between";
    public static final String MATCH_BETWEEN_INCLUSIVE = "betweenInclusive";
    public static final String MATCH_CONTAINS = "contains";
    public static final String MATCH_ENDS = "ends";
    public static final String MATCH_EQUALS = "equals";
    public static final String MATCH_GREATER = "greaterThan";
    public static final String MATCH_LESS = "lessThan";
    public static final String MATCH_EQUAL_GREATER = "equalGreaterThan";
    public static final String MATCH_EQUAL_LESS = "equalLessThan";
    private static final String[] MATCH_AFTER_GREATER = new String[]{"after", "greaterThan"};
    private static final String[] MATCH_BEFORE_LESS = new String[]{"before", "lessThan"};
    private static final String[] MATCH_BETWEEN_ALL = new String[]{"betweenInclusive", "between"};
    private static final Hashtable<String, String[]> MATCH_BETWEEN_OPERATORS = new Hashtable();
    private static final String RANGE_END = "RangeEnd";
    public static final String SUFFIX_INPUT_MATCH = "Match";
    public static final String OBJECT_NAME = "o";
    DataDefinition in = null;
    private ArrayList<String> inputNames = new ArrayList();
    private static final ResponderOperation searchOp;

    private void fillFormAction() {
        if (this.formAction == null) {
            String requestURI = ((HttpServletRequest)this.pageContext.getRequest()).getRequestURI();
            if (requestURI.indexOf("/") != -1) {
                requestURI = requestURI.substring(requestURI.lastIndexOf("/") + 1);
            }
            this.formAction = requestURI;
        }
    }

    public DataDefinition getDataTypeAtAnalysis(PageCache pageCache) {
        return this.in;
    }

    public ResponderOperation getResponderOperation(String operation) {
        return searchOp;
    }

    public void initialiseState() {
        this.fillFormAction();
        super.initialiseState();
        if (this.in != null) {
            this.responder.setSearchType(this.in);
        }
        if (this.formMessage == null) {
            this.responder.setMessage("Search done!");
        }
        this.responder.setFormName(this.formName);
    }

    public void setAction(String s) {
        this.formAction = s;
        this.fillFormAction();
    }

    public void setIn(String s) {
        this.in = this.ddp.getDataDefinition(s);
    }

    public void setTagKey(PageCache pageCache) {
        this.tagKey = new MultipleKey(new Object[]{this.formName});
    }

    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.in = null;
        this.inputNames = null;
    }

    public boolean containsInput(String inputName) {
        if (this.inputNames.contains(inputName)) {
            return true;
        }
        this.inputNames.add(inputName);
        return false;
    }

    static {
        MATCH_BETWEEN_OPERATORS.put(MATCH_BETWEEN_INCLUSIVE, new String[]{">=", "<="});
        MATCH_BETWEEN_OPERATORS.put(MATCH_BETWEEN, new String[]{">", "<"});
        searchOp = new ResponderOperation(){
            private static final long serialVersionUID = 1L;

            private boolean notEmpty(Object value) {
                if (value instanceof Vector) {
                    return ((Vector)value).size() > 0;
                }
                return this.isSingleValue(value);
            }

            private boolean isSingleValue(Object value) {
                return value != null && !(value instanceof Vector) && !Pointer.isNullObject(value) && value.toString().length() > 0 && !value.equals(FieldInfo.emptyDate);
            }

            public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
                Dictionary<String, Object> data = resp.getHttpData(req, suffix);
                RequestAttributes attributes = RequestAttributes.getAttributes(req);
                HttpParameters parameters = RequestAttributes.getParameters(req);
                DataDefinition dd = DataDefinitionProvider.getInstance().getDataDefinition(resp.getSearchType());
                req.setAttribute("__makumba__formReload__", (Object)"true");
                req.setAttribute(resp.getFormName() + "From", (Object)(resp.getSearchType() + " " + SearchTag.OBJECT_NAME));
                HashSet<String> variableFroms = new HashSet<String>(1);
                String where = "";
                StringBuffer queryString = new StringBuffer();
                Enumeration<String> enumeration = data.keys();
                while (enumeration.hasMoreElements()) {
                    String inputName = enumeration.nextElement();
                    Object value = attributes.getAttribute(inputName);
                    if (this.notEmpty(value) || value == Pointer.NullDate) {
                        if (value instanceof Date || value == Pointer.NullDate) {
                            ArrayList<String> params = parameters.getParametersStartingWith(inputName + "_");
                            Collections.sort(params);
                            for (String param : params) {
                                this.appendParams(queryString, param, parameters.getParameter(param));
                            }
                        } else {
                            this.appendParams(queryString, inputName, value);
                        }
                    }
                    if (inputName.endsWith(SearchTag.RANGE_END)) {
                        if (this.notEmpty(attributes.getAttribute(this.getRangeBeginName(inputName)))) continue;
                        inputName = this.getRangeBeginName(inputName);
                    }
                    if (!this.notEmpty(value)) continue;
                    String[] multiFieldSearchCriterion = resp.getMultiFieldSearchCriterion(inputName);
                    FieldDefinition fd = DataDefinitionProvider.getFieldDefinition(dd, inputName, inputName);
                    if (where.length() > 0) {
                        where = where + " AND ";
                    }
                    String attributeName = inputName;
                    Object matchMode = parameters.getParameter(inputName + SearchTag.SUFFIX_INPUT_MATCH);
                    if (StringUtils.notEmpty(matchMode)) {
                        this.appendParams(queryString, inputName + SearchTag.SUFFIX_INPUT_MATCH, matchMode);
                    } else {
                        matchMode = resp.getDefaultMatchMode(inputName);
                    }
                    String whereThisField = "";
                    for (int i = 0; i < multiFieldSearchCriterion.length; ++i) {
                        String finalFieldName;
                        FieldDefinition thisFd;
                        String objectName = SearchTag.OBJECT_NAME;
                        String fieldName = multiFieldSearchCriterion[i];
                        if (whereThisField.length() > 0) {
                            whereThisField = whereThisField + " OR ";
                        }
                        if ((thisFd = dd.getFieldOrPointedFieldDefinition(finalFieldName = fieldName)).getDataDefinition() != dd) {
                            int lastIndexOf = finalFieldName.lastIndexOf(thisFd.getName());
                            String subfieldName = inputName.substring(0, lastIndexOf - 1);
                            objectName = "o_" + subfieldName.replace('.', '_');
                            variableFroms.add("o." + subfieldName + " " + objectName);
                            finalFieldName = thisFd.getName();
                        }
                        whereThisField = StringUtils.equalsAny(matchMode, MATCH_BETWEEN_ALL) ? whereThisField + this.computeRangeQuery(attributes, objectName, finalFieldName, attributeName, matchMode) : whereThisField + this.computeTypeSpecificQuery(req, value, objectName, finalFieldName, attributeName, matchMode, fd);
                    }
                    if (whereThisField.trim().length() <= 0) continue;
                    where = where + " (" + whereThisField + ") ";
                    if (!fd.isSetType()) continue;
                    variableFroms.add("o." + inputName + " " + SearchTag.OBJECT_NAME + "_" + inputName.replace(".", "_"));
                }
                this.appendParams(queryString, "__makumba__responder__", parameters.getParameter("__makumba__responder__"));
                Hashtable<String, Object> searchResults = new Hashtable<String, Object>(4);
                searchResults.put(resp.getFormName() + SearchTag.ATTRIBUTE_NAME_WHERE, where);
                searchResults.put(resp.getFormName() + SearchTag.ATTRIBUTE_NAME_VARIABLE_FROM, StringUtils.toString(variableFroms, false));
                searchResults.put(resp.getFormName() + SearchTag.ATTRIBUTE_NAME_QUERYSTRING, queryString.toString());
                searchResults.put(resp.getFormName() + SearchTag.ATTRIBUTE_NAME_DONE, Boolean.TRUE);
                for (String key : searchResults.keySet()) {
                    req.setAttribute(key, searchResults.get(key));
                    Logger.getLogger("org.makumba.searchForm").fine("Set search form result attribute '" + key + "': " + req.getAttribute(key));
                }
                return searchResults;
            }

            private void appendParams(StringBuffer link, String inputName, Object value) {
                if (link.length() > 0) {
                    link.append("&");
                }
                if (value instanceof Vector) {
                    Vector vector = (Vector)value;
                    for (int i = 0; i < vector.size(); ++i) {
                        link.append(inputName).append("=").append(this.treatValue(inputName, vector.get(i)));
                        if (i + 1 >= vector.size()) continue;
                        link.append("&");
                    }
                } else {
                    link.append(inputName).append("=").append(this.treatValue(inputName, value));
                }
            }

            private String treatValue(String inputName, Object value) {
                if (value instanceof Pointer) {
                    return ((Pointer)value).toExternalForm();
                }
                return value.toString();
            }

            private String computeRangeQuery(RequestAttributes attributes, String objectName, String fieldName, String attributeName, Object advancedMatch) {
                boolean haveEnd;
                String where = "";
                String attributeNameEnd = attributeName + SearchTag.RANGE_END;
                boolean haveBegin = true;
                Object attributeValueBegin = null;
                Object attributeValueEnd = null;
                try {
                    attributeValueBegin = attributes.getAttribute(attributeName);
                }
                catch (LogicException e) {
                    // empty catch block
                }
                try {
                    attributeValueEnd = attributes.getAttribute(attributeName + SearchTag.RANGE_END);
                }
                catch (LogicException e) {
                    // empty catch block
                }
                boolean bl = haveEnd = fieldName.endsWith(SearchTag.RANGE_END) || this.notEmpty(attributeValueEnd);
                if (!this.notEmpty(attributeValueBegin)) {
                    haveBegin = false;
                }
                if (haveBegin) {
                    where = where + objectName + "." + fieldName + ((String[])MATCH_BETWEEN_OPERATORS.get(advancedMatch))[0] + "$" + attributeName;
                }
                if (haveBegin && haveEnd) {
                    where = where + " AND ";
                }
                if (haveEnd) {
                    where = where + objectName + "." + fieldName + ((String[])MATCH_BETWEEN_OPERATORS.get(advancedMatch))[1] + "$" + attributeNameEnd;
                }
                return where;
            }

            public String verify(Responder resp) {
                return null;
            }

            private String computeTypeSpecificQuery(HttpServletRequest req, Object value, String objectName, String fieldName, String attributeName, Object matchMode, FieldDefinition fd) throws LogicException {
                String where = "";
                if (value instanceof Vector || fd.isSetType()) {
                    String labelName = !fd.isSetType() ? objectName + "." + fieldName : objectName + "_" + fieldName;
                    where = where + labelName + " IN SET ($" + attributeName + ")";
                } else if (this.isSingleValue(value)) {
                    where = where + objectName + "." + fieldName;
                    if (matchMode == null || matchMode.equals(SearchTag.MATCH_EQUALS)) {
                        where = where + "=$" + attributeName;
                    } else if (fd.isStringType()) {
                        String keyLike = attributeName + "__Like";
                        if (matchMode.equals(SearchTag.MATCH_CONTAINS)) {
                            value = "%" + value + "%";
                        } else if (matchMode.equals(SearchTag.MATCH_BEGINS)) {
                            value = value + "%";
                        } else if (matchMode.equals(SearchTag.MATCH_ENDS)) {
                            value = "%" + value;
                        }
                        req.setAttribute(keyLike, value);
                        where = where + " LIKE $" + keyLike + "";
                    } else if (fd.isDateType() || fd.isNumberType()) {
                        if (StringUtils.equalsAny(matchMode, MATCH_BEFORE_LESS)) {
                            where = where + "<$" + attributeName;
                        } else if (StringUtils.equalsAny(matchMode, MATCH_AFTER_GREATER)) {
                            where = where + ">$" + attributeName;
                        } else if (matchMode.equals(SearchTag.MATCH_EQUAL_GREATER)) {
                            where = where + ">=$" + attributeName;
                        } else if (matchMode.equals(SearchTag.MATCH_EQUAL_LESS)) {
                            where = where + "<=$" + attributeName;
                        }
                    }
                }
                return where;
            }

            private String getRangeBeginName(String fieldName) {
                return fieldName.substring(0, fieldName.length() - SearchTag.RANGE_END.length());
            }
        };
    }
}

