/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.IdentityLock;
import org.jgroups.blocks.MethodCall;

public class UnlockInterceptor
extends Interceptor {
    Map lock_table = null;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.lock_table = cache.getLockTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Object object;
        Transaction tx = this.getInvocationContext().getTransaction();
        try {
            object = super.invoke(m);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block9: {
                block8: {
                    Object var5_5 = null;
                    if (tx == null || !this.isValid(tx)) break block8;
                    if (!this.log.isTraceEnabled()) break block9;
                    this.log.trace((Object)"Do not do anything; we have a transaction running or node locking is optimistic.");
                    break block9;
                }
                List locks = (List)this.lock_table.get(Thread.currentThread());
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Attempting to release locks on current thread.  Lock table is " + this.lock_table));
                }
                if (locks == null || locks.size() <= 0) break block9;
                this.releaseLocks(locks);
                this.lock_table.remove(Thread.currentThread());
            }
            throw throwable;
        }
        if (tx != null && this.isValid(tx)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Do not do anything; we have a transaction running or node locking is optimistic.");
            }
        } else {
            List locks = (List)this.lock_table.get(Thread.currentThread());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Attempting to release locks on current thread.  Lock table is " + this.lock_table));
            }
            if (locks != null && locks.size() > 0) {
                this.releaseLocks(locks);
                this.lock_table.remove(Thread.currentThread());
            }
        }
        return object;
    }

    private void releaseLocks(List locks) {
        if (locks != null) {
            ListIterator it = locks.listIterator(locks.size());
            while (it.hasPrevious()) {
                IdentityLock lock = (IdentityLock)it.previous();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("releasing lock for " + lock.getFqn() + ": " + lock));
                }
                lock.release(Thread.currentThread());
            }
            locks.clear();
        }
    }
}

