/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.openqa.selenium.server.commands.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaptureNetworkTrafficCommand
extends Command {
    private static List<Entry> entries = new ArrayList<Entry>();
    private String type;

    public static void clear() {
        entries.clear();
    }

    public static void capture(Entry entry) {
        entries.add(entry);
    }

    public CaptureNetworkTrafficCommand(String type) {
        this.type = type;
    }

    @Override
    public String execute() {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        if ("json".equalsIgnoreCase(this.type)) {
            sb.append("[");
            Iterator<Entry> iterator = entries.iterator();
            while (iterator.hasNext()) {
                Entry entry = iterator.next();
                sb.append("{\n");
                sb.append("    statusCode: ").append(entry.statusCode).append(",\n");
                sb.append("    method: ").append(this.json(entry.method)).append(",\n");
                sb.append("    url: ").append(this.json(entry.url)).append(",\n");
                sb.append("    bytes: ").append(entry.bytes).append(",\n");
                sb.append("    start: '").append(sdf.format(entry.start)).append("',\n");
                sb.append("    end: '").append(sdf.format(entry.end)).append("',\n");
                sb.append("    timeInMillis: ").append(entry.end.getTime() - entry.start.getTime()).append(",\n");
                sb.append("    requestHeaders:[");
                this.jsonHeaders(sb, entry.requestHeaders);
                sb.append("],\n");
                sb.append("    responseHeaders:[");
                this.jsonHeaders(sb, entry.responseHeaders);
                sb.append("]\n");
                sb.append("}");
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append("]\n");
        } else if ("xml".equalsIgnoreCase(this.type)) {
            sb.append("<traffic>\n");
            for (Entry entry : entries) {
                sb.append("<entry ");
                sb.append("statusCode=\"").append(entry.statusCode).append("\" ");
                sb.append("method=\"").append(this.json(entry.method)).append("\" ");
                sb.append("url=\"").append(this.xml(entry.url)).append("\" ");
                sb.append("bytes=\"").append(entry.bytes).append("\" ");
                sb.append("start=\"").append(sdf.format(entry.start)).append("\" ");
                sb.append("end=\"").append(sdf.format(entry.end)).append("\" ");
                sb.append("timeInMillis=\"").append(entry.end.getTime() - entry.start.getTime()).append("\">\n");
                sb.append("    <requestHeaders>\n");
                this.xmlHeaders(sb, entry.requestHeaders);
                sb.append("    </requestHeaders>\n");
                sb.append("    <responseHeaders>\n");
                this.xmlHeaders(sb, entry.requestHeaders);
                sb.append("    </responseHeaders>\n");
                sb.append("</entry>\n");
            }
            sb.append("</traffic>\n");
        } else {
            for (Entry entry : entries) {
                sb.append(entry.statusCode).append(" ").append(entry.method).append(" ").append(entry.url).append("\n");
                sb.append(entry.bytes).append(" bytes\n");
                sb.append(entry.end.getTime() - entry.start.getTime()).append("ms (").append(sdf.format(entry.start)).append(" - ").append(sdf.format(entry.end)).append("\n");
                sb.append("\n");
                sb.append("Request Headers\n");
                for (Header header : entry.requestHeaders) {
                    sb.append(" - ").append(header.name).append(" => ").append(header.value).append("\n");
                }
                sb.append("Response Headers\n");
                for (Header header : entry.responseHeaders) {
                    sb.append(" - ").append(header.name).append(" => ").append(header.value).append("\n");
                }
                sb.append("================================================================\n");
                sb.append("\n");
            }
        }
        CaptureNetworkTrafficCommand.clear();
        return "OK," + sb.toString();
    }

    private void xmlHeaders(StringBuilder sb, List<Header> headers) {
        for (Header header : headers) {
            sb.append("        <header name=\"").append(this.xml(header.name)).append("\">").append(this.xml(header.value)).append("</header>\n");
        }
    }

    private void jsonHeaders(StringBuilder sb, List<Header> headers) {
        Iterator<Header> headItr = headers.iterator();
        while (headItr.hasNext()) {
            Header header = headItr.next();
            sb.append("{\n");
            sb.append("        name: ").append(this.json(header.name)).append(",\n");
            sb.append("        value: ").append(this.json(header.value)).append("\n");
            sb.append("    }");
            if (!headItr.hasNext()) continue;
            sb.append(",");
        }
    }

    private String xml(String s) {
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("\\<", "&lt;");
        s = s.replaceAll("\\>", "&gt;");
        return s;
    }

    private Object json(String s) {
        s = s.replaceAll("\\'", "\\\\'");
        s = s.replaceAll("\n", "\\\\n");
        return "'" + s + "'";
    }

    public static class Header {
        private String name;
        private String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class Entry {
        private String method;
        private String url;
        private int statusCode;
        private Date start;
        private Date end;
        private long bytes;
        private List<Header> requestHeaders = new ArrayList<Header>();
        private List<Header> responseHeaders = new ArrayList<Header>();

        public Entry(String method, String url) {
            this.method = method;
            this.url = url;
            this.start = new Date();
        }

        public void finish(int statusCode, long bytes) {
            this.statusCode = statusCode;
            this.bytes = bytes;
            this.end = new Date();
        }

        public void addRequestHeaders(HttpRequest request) {
            Enumeration names = request.getFieldNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = request.getField(name);
                this.requestHeaders.add(new Header(name, value));
            }
        }

        public void addResponseHeader(HttpResponse response) {
            Enumeration names = response.getFieldNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = response.getField(name);
                this.responseHeaders.add(new Header(name, value));
            }
        }

        public void setStart(Date start) {
            this.start = start;
        }

        public void setEnd(Date end) {
            this.end = end;
        }

        public String toString() {
            return this.method + "|" + this.statusCode + "|" + this.url + "|" + this.requestHeaders.size() + "|" + this.responseHeaders.size() + "\n";
        }
    }
}

