/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowResources {
    public static void main(String[] args) throws Exception {
        List<URL> resources = ShowResources.listResources(ShowResources.class.getClassLoader());
        if (args.length == 0) {
            for (URL url : resources) {
                System.out.println(url.toExternalForm());
            }
        } else {
            Iterator<URL> i$ = resources.iterator();
            block1: while (i$.hasNext()) {
                URL url2;
                URL url = url2 = i$.next();
                String urlString = url.toExternalForm();
                for (String element : args) {
                    if (urlString.indexOf(element) == -1) continue;
                    System.out.println("Found resource: " + urlString);
                    System.out.println("First few chars: " + ShowResources.readAFewChars(url));
                    System.out.println();
                    continue block1;
                }
            }
        }
    }

    private static List<URL> listResources(ClassLoader cl) throws IOException, MalformedURLException {
        ArrayList<URL> resources = new ArrayList<URL>();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls;
                URLClassLoader ucl = (URLClassLoader)cl;
                for (URL url : urls = ucl.getURLs()) {
                    File file;
                    if (url.getFile().endsWith(".jar")) {
                        ShowResources.listJarResources(new URL("jar:" + url.toExternalForm() + "!/"), resources);
                        continue;
                    }
                    if (!url.getProtocol().equals("file") || !(file = new File(url.getFile())).isDirectory()) continue;
                    ShowResources.listDirResources(file, resources);
                }
            }
            cl = cl.getParent();
        }
        return resources;
    }

    private static void listDirResources(File dir, List<URL> resources) throws MalformedURLException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            resources.add(file.toURL());
            if (!file.isDirectory()) continue;
            ShowResources.listDirResources(file, resources);
        }
    }

    private static void listJarResources(URL jarUrl, List<URL> resources) throws IOException, MalformedURLException {
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        Enumeration<JarEntry> entries = jarConnection.getJarFile().entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            resources.add(new URL(jarUrl, entry.getName()));
        }
    }

    private static String readAFewChars(URL url) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer(10);
        InputStreamReader reader = new InputStreamReader(url.openStream());
        for (int i = 0; i < 10 && (c = ((Reader)reader).read()) != -1; ++i) {
            buf.append((char)c);
        }
        ((Reader)reader).close();
        return buf.toString();
    }
}

