/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.util.ArrayList;
import java.util.Vector;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaSystem;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.DBConnectionWrapper;
import org.makumba.db.makumba.Database;
import org.makumba.db.makumba.MakumbaTransactionProvider;
import org.makumba.db.makumba.sql.SQLDBConnection;
import org.makumba.db.makumba.sql.TableManager;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;

public class checkForeignKeys {
    public static ArrayList<Throwable> errors = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Database d = null;
        try {
            d = argv.length == 0 ? MakumbaTransactionProvider.getDatabase(Configuration.getDefaultDataSourceName()) : MakumbaTransactionProvider.getDatabase(argv[0]);
            DBConnection connection = d.getDBConnection();
            if (connection instanceof DBConnectionWrapper) {
                connection = ((DBConnectionWrapper)connection).getWrapped();
            }
            SQLDBConnection sqlConnection = (SQLDBConnection)connection;
            Vector<String> mddsInDirectory = DataDefinitionProvider.getInstance().getDataDefinitionsInDefaultLocations("test.brokenMdds");
            String[] tables = mddsInDirectory.toArray(new String[mddsInDirectory.size()]);
            for (int i = 0; i < tables.length; ++i) {
                System.out.println("\n**** Checking foreign keys of MDD '" + tables[i] + "', #" + (i + 1) + " of " + tables.length + "\n");
                DataDefinition dd = MakumbaSystem.getDataDefinition(tables[i]);
                try {
                    TableManager table = (TableManager)d.getTable(dd.getName());
                    checkForeignKeys.processDataDefinition(d, sqlConnection, dd, table);
                    continue;
                }
                catch (Throwable t) {
                    System.out.println(t.getMessage());
                    t.printStackTrace();
                    errors.add(t);
                }
            }
        }
        finally {
            if (d != null) {
                d.close();
            }
        }
        System.out.println("\n\n\n=====================================================================");
        System.out.println("The following " + errors.size() + " errors occured:");
        for (Throwable e : errors) {
            System.out.println("\n" + e.getMessage() + "\n");
        }
    }

    private static void processDataDefinition(Database d, SQLDBConnection sqlConnection, DataDefinition dd, TableManager table) throws DBError {
        for (String string : dd.getFieldNames()) {
            FieldDefinition fi = dd.getFieldDefinition(string);
            String fieldName = fi.getName();
            String brief = dd.getName() + "#" + fieldName + " (" + fi.getDescription() + ")";
            if (fi.getType().startsWith("set") || fi.getType().equals("ptrOne")) {
                TableManager subTable = (TableManager)d.getTable(fi.getSubtable().getName());
                checkForeignKeys.processDataDefinition(d, sqlConnection, fi.getSubtable(), subTable);
                continue;
            }
            try {
                table.manageForeignKeys(fieldName, sqlConnection, brief);
            }
            catch (Throwable t) {
                System.out.println(t.getMessage());
                t.printStackTrace();
                errors.add(t);
            }
        }
    }
}

