/*
 * Decompiled with CFR 0.152.
 */
package org.securityfilter.authenticator.persistent;

import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.securityfilter.authenticator.persistent.PersistentLoginManagerInterface;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DefaultPersistentLoginManager
implements Serializable,
PersistentLoginManagerInterface {
    protected String cookieLife = "15";
    protected String protection = "all";
    protected String validationKey;
    protected String encryptionKey;
    protected String useIP = "true";
    protected String encryptionAlgorithm = "DES";
    protected String encryptionMode = "ECB";
    protected String encryptionPadding = "PKCS5Padding";
    protected String cipherParameters;
    protected String valueBeforeMD5 = "";
    protected String valueAfterMD5 = "";
    protected SecretKey secretKey;
    protected static final String COOKIE_USERNAME = "username";
    protected static final String COOKIE_PASSWORD = "password";
    protected static final String COOKIE_REMEMBERME = "rememberme";
    protected static final String COOKIE_VALIDATION = "validation";
    protected static final String PROTECTION_ALL = "all";
    protected static final String PROTECTION_VALIDATION = "validation";
    protected static final String PROTECTION_ENCRYPTION = "encryption";
    protected static final String PROTECTION_NONE = "none";

    public DefaultPersistentLoginManager() {
        this.initCypherParameters();
    }

    public void rememberLogin(HttpServletRequest request, HttpServletResponse response, String username, String password) throws IOException, ServletException {
        if (this.protection.equals(PROTECTION_ALL) || this.protection.equals(PROTECTION_ENCRYPTION)) {
            username = this.encryptText(username);
            password = this.encryptText(password);
            if (username == null || password == null) {
                System.out.println("ERROR!!");
                System.out.println("There was a problem encrypting the username or password!!");
                System.out.println("Remember Me function will be disabled!!");
                return;
            }
        }
        Cookie usernameCookie = new Cookie(COOKIE_USERNAME, username);
        usernameCookie.setMaxAge(86400 * Integer.parseInt(this.cookieLife));
        response.addCookie(usernameCookie);
        Cookie passwdCookie = new Cookie(COOKIE_PASSWORD, password);
        passwdCookie.setMaxAge(86400 * Integer.parseInt(this.cookieLife));
        response.addCookie(passwdCookie);
        Cookie rememberCookie = new Cookie(COOKIE_REMEMBERME, "true");
        rememberCookie.setMaxAge(86400 * Integer.parseInt(this.cookieLife));
        response.addCookie(rememberCookie);
        if (this.protection.equals(PROTECTION_ALL) || this.protection.equals("validation")) {
            String validationHash = this.getValidationHash(username, password, request.getRemoteAddr());
            if (validationHash != null) {
                Cookie validationCookie = new Cookie("validation", validationHash);
                validationCookie.setMaxAge(86400 * Integer.parseInt(this.cookieLife));
                response.addCookie(validationCookie);
            } else {
                System.out.println("WARNING!!! WARNING!!!");
                System.out.println("PROTECTION=ALL or PROTECTION=VALIDATION was specified");
                System.out.println("but Validation Hash could NOT be generated");
                System.out.println("Validation has been disabled!!!!");
            }
        }
    }

    public void forgetLogin(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.removeCookie(request, response, COOKIE_USERNAME);
        this.removeCookie(request, response, COOKIE_PASSWORD);
        this.removeCookie(request, response, COOKIE_REMEMBERME);
        this.removeCookie(request, response, "validation");
    }

    public boolean rememberingLogin(HttpServletRequest request) {
        return DefaultPersistentLoginManager.getCookieValue(request.getCookies(), COOKIE_REMEMBERME, "false").equals("true");
    }

    public String getRememberedUsername(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String username = DefaultPersistentLoginManager.getCookieValue(request.getCookies(), COOKIE_USERNAME, "false");
        String password = DefaultPersistentLoginManager.getCookieValue(request.getCookies(), COOKIE_PASSWORD, "false");
        String validationHash = DefaultPersistentLoginManager.getCookieValue(request.getCookies(), "validation", "false");
        if (!username.equals("false")) {
            if (!validationHash.equals("false")) {
                String calculatedHash = this.getValidationHash(username, password, request.getRemoteAddr());
                if (validationHash.equals(calculatedHash)) {
                    if (this.protection.equals(PROTECTION_ALL) || this.protection.equals(PROTECTION_ENCRYPTION)) {
                        username = this.decryptText(username);
                    }
                    return username;
                }
                System.out.println("!remember-me cookie validation hash mismatch! ");
                System.out.println("!remember-me cookie has been tampered with! ");
                System.out.println("!remember-me cookie is being deleted! ");
                this.removeCookie(request, response, COOKIE_USERNAME);
                this.removeCookie(request, response, COOKIE_PASSWORD);
                this.removeCookie(request, response, COOKIE_REMEMBERME);
                this.removeCookie(request, response, "validation");
                return null;
            }
            if (this.protection.equals(PROTECTION_ALL) || this.protection.equals(PROTECTION_ENCRYPTION)) {
                username = this.decryptText(username);
            }
            return username;
        }
        return null;
    }

    public String getRememberedPassword(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String username = DefaultPersistentLoginManager.getCookieValue(request.getCookies(), COOKIE_USERNAME, "false");
        String password = DefaultPersistentLoginManager.getCookieValue(request.getCookies(), COOKIE_PASSWORD, "false");
        String validationHash = DefaultPersistentLoginManager.getCookieValue(request.getCookies(), "validation", "false");
        if (!password.equals("false")) {
            if (!validationHash.equals("false")) {
                String calculatedHash = this.getValidationHash(username, password, request.getRemoteAddr());
                if (validationHash.equals(calculatedHash)) {
                    if (this.protection.equals(PROTECTION_ALL) || this.protection.equals(PROTECTION_ENCRYPTION)) {
                        password = this.decryptText(password);
                    }
                    return password;
                }
                System.out.println("!remember-me cookie validation hash mismatch! ");
                System.out.println("!remember-me cookie has been tampered with! ");
                System.out.println("!remember-me cookie is being deleted! ");
                this.removeCookie(request, response, COOKIE_USERNAME);
                this.removeCookie(request, response, COOKIE_PASSWORD);
                this.removeCookie(request, response, COOKIE_REMEMBERME);
                this.removeCookie(request, response, "validation");
                return null;
            }
            if (this.protection.equals(PROTECTION_ALL) || this.protection.equals(PROTECTION_ENCRYPTION)) {
                password = this.decryptText(password);
            }
            return password;
        }
        return null;
    }

    public void setCookieLife(String cookieLife) {
        this.cookieLife = cookieLife;
    }

    public void setProtection(String protection) {
        if (protection.toLowerCase().trim().equals(PROTECTION_ALL) || protection.toLowerCase().trim().equals("validation") || protection.toLowerCase().trim().equals(PROTECTION_ENCRYPTION) || protection.toLowerCase().trim().equals(PROTECTION_NONE)) {
            this.protection = protection.toLowerCase().trim();
        } else {
            System.out.println("*ERROR - Invalid protection setting!!!" + protection);
            System.out.println("*ERROR - setting protection to default -->=all");
            this.protection = PROTECTION_ALL;
        }
    }

    public void setValidationKey(String validationkey) {
        this.validationKey = validationkey;
    }

    public void setEncryptionKey(String encryptionkey) {
        this.encryptionKey = encryptionkey;
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(this.encryptionAlgorithm);
            byte[] desKeyData = encryptionkey.getBytes();
            DESKeySpec desKeySpec = new DESKeySpec(desKeyData);
            this.secretKey = keyFactory.generateSecret(desKeySpec);
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
        }
    }

    public void setUseIP(String useIP) {
        this.useIP = useIP.toLowerCase().trim();
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm.trim();
        this.initCypherParameters();
    }

    public void setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode.trim();
        this.initCypherParameters();
    }

    public void setEncryptionPadding(String encryptionPadding) {
        this.encryptionPadding = encryptionPadding.trim();
        this.initCypherParameters();
    }

    private void initCypherParameters() {
        this.cipherParameters = this.encryptionAlgorithm + "/" + this.encryptionMode + "/" + this.encryptionPadding;
    }

    private static String getCookieValue(Cookie[] cookies, String cookieName, String defaultValue) {
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return defaultValue;
    }

    private static Cookie getCookie(Cookie[] cookies, String cookieName) {
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    private void removeCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = DefaultPersistentLoginManager.getCookie(request.getCookies(), cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private String getValidationHash(String username, String password, String clientIP) {
        if (this.validationKey == null) {
            System.out.println("ERROR! >> validationKey not spcified....");
            System.out.println("ERROR! >> you are REQUIRED to specify the validatonkey in the config xml");
            return null;
        }
        MessageDigest md5 = null;
        StringBuffer sbValueBeforeMD5 = new StringBuffer();
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Error: " + e);
        }
        try {
            sbValueBeforeMD5.append(username.toString());
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(password.toString());
            sbValueBeforeMD5.append(":");
            if (this.useIP.equals("true")) {
                sbValueBeforeMD5.append(clientIP.toString());
                sbValueBeforeMD5.append(":");
            }
            sbValueBeforeMD5.append(this.validationKey.toString());
            this.valueBeforeMD5 = sbValueBeforeMD5.toString();
            md5.update(this.valueBeforeMD5.getBytes());
            byte[] array = md5.digest();
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < array.length; ++j) {
                int b = array[j] & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            this.valueAfterMD5 = sb.toString();
        }
        catch (Exception e) {
            System.out.println("Error:" + e);
        }
        return this.valueAfterMD5;
    }

    private String encryptText(String clearText) {
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            Cipher c1 = Cipher.getInstance(this.cipherParameters);
            if (this.secretKey != null) {
                c1.init(1, this.secretKey);
                byte[] clearTextBytes = clearText.getBytes();
                byte[] encryptedText = c1.doFinal(clearTextBytes);
                String encryptedEncodedText = encoder.encode(encryptedText);
                return encryptedEncodedText;
            }
            System.out.println("ERROR! >> SecretKey not generated ....");
            System.out.println("ERROR! >> you are REQUIRED to specify the encryptionKey in the config xml");
            return null;
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
            return null;
        }
    }

    private String decryptText(String encryptedText) {
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] decodedEncryptedText = decoder.decodeBuffer(encryptedText);
            Cipher c1 = Cipher.getInstance(this.cipherParameters);
            c1.init(2, this.secretKey);
            byte[] decryptedText = c1.doFinal(decodedEncryptedText);
            String decryptedTextString = new String(decryptedText);
            return decryptedTextString;
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
            return null;
        }
    }
}

