/*
 * Decompiled with CFR 0.152.
 */
package org.securityfilter.config;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.securityfilter.authenticator.persistent.PersistentLoginManagerInterface;
import org.securityfilter.config.SecurityConstraint;
import org.securityfilter.realm.SecurityRealmInterface;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SecurityConfig {
    private String loginPage = null;
    private String errorPage = null;
    private String logoutPage = null;
    private String defaultPage = null;
    private ArrayList securityConstraints = null;
    private SecurityRealmInterface realm = null;
    private PersistentLoginManagerInterface persistentLoginManager;
    private Object lastRealm = null;
    private boolean validating;
    private String authMethod;
    private String realmName;
    static /* synthetic */ Class class$java$lang$Object;

    public SecurityConfig(boolean validating) {
        this.validating = validating;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public String getLogoutPage() {
        return this.logoutPage;
    }

    public void setLogoutPage(String logoutPage) {
        this.logoutPage = logoutPage;
    }

    public String getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public SecurityRealmInterface getRealm() {
        return this.realm;
    }

    public synchronized void addRealm(Object realm) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.realm == null) {
            this.realm = (SecurityRealmInterface)realm;
            this.lastRealm = realm;
        } else {
            Method addMethod = this.lastRealm.getClass().getMethod("setRealm", class$java$lang$Object == null ? (class$java$lang$Object = SecurityConfig.class$("java.lang.Object")) : class$java$lang$Object);
            addMethod.invoke(this.lastRealm, realm);
            this.lastRealm = realm;
        }
    }

    public List getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void addSecurityConstraint(SecurityConstraint constraint) {
        this.securityConstraints.add(constraint);
    }

    public void setPersistentLoginManager(PersistentLoginManagerInterface persistentLoginManager) {
        this.persistentLoginManager = persistentLoginManager;
    }

    public PersistentLoginManagerInterface getPersistentLoginManager() {
        return this.persistentLoginManager;
    }

    public void loadConfig(URL configURL) throws IOException, SAXException {
        this.securityConstraints = new ArrayList();
        Digester digester = new Digester();
        this.registerLocalDTDs(digester);
        digester.push((Object)this);
        digester.setUseContextClassLoader(true);
        digester.setValidating(this.validating);
        digester.addObjectCreate("securityfilter-config/realm", null, "className");
        digester.addSetProperty("securityfilter-config/realm/realm-param", "name", "value");
        digester.addSetNext("securityfilter-config/realm", "addRealm", "java.lang.Object");
        digester.addCallMethod("securityfilter-config/login-config/auth-method", "setAuthMethod", 0);
        digester.addCallMethod("securityfilter-config/login-config/realm-name", "setRealmName", 0);
        digester.addCallMethod("securityfilter-config/login-config/form-login-config/form-login-page", "setLoginPage", 0);
        digester.addCallMethod("securityfilter-config/login-config/form-login-config/form-error-page", "setErrorPage", 0);
        digester.addCallMethod("securityfilter-config/login-config/form-login-config/form-logout-page", "setLogoutPage", 0);
        digester.addCallMethod("securityfilter-config/login-config/form-login-config/form-default-page", "setDefaultPage", 0);
        digester.addObjectCreate("securityfilter-config/login-config/form-login-config/remember-me", null, "className");
        digester.addSetProperty("securityfilter-config/login-config/form-login-config/remember-me/remember-me-param", "name", "value");
        digester.addSetNext("securityfilter-config/login-config/form-login-config/remember-me", "setPersistentLoginManager", "org.securityfilter.authenticator.persistent.PersistentLoginManagerInterface");
        digester.addObjectCreate("securityfilter-config/security-constraint", "org.securityfilter.config.SecurityConstraint");
        digester.addSetNext("securityfilter-config/security-constraint", "addSecurityConstraint", "org.securityfilter.config.SecurityConstraint");
        digester.addObjectCreate("securityfilter-config/security-constraint/auth-constraint", "org.securityfilter.config.AuthConstraint");
        digester.addSetNext("securityfilter-config/security-constraint/auth-constraint", "setAuthConstraint", "org.securityfilter.config.AuthConstraint");
        digester.addCallMethod("securityfilter-config/security-constraint/auth-constraint/role-name", "addRole", 0);
        digester.addObjectCreate("securityfilter-config/security-constraint/web-resource-collection", "org.securityfilter.config.WebResourceCollection");
        digester.addSetNext("securityfilter-config/security-constraint/web-resource-collection", "addWebResourceCollection", "org.securityfilter.config.WebResourceCollection");
        digester.addCallMethod("securityfilter-config/security-constraint/web-resource-collection/url-pattern", "addURLPattern", 0);
        digester.addCallMethod("securityfilter-config/security-constraint/web-resource-collection/http-method", "addHttpMethod", 0);
        InputSource input = new InputSource(configURL.openStream());
        digester.parse(input);
    }

    protected void registerLocalDTDs(Digester digester) {
        URL dtd2_0;
        URL dtd1_1;
        URL dtd1_0 = this.getClass().getResource("/org/securityfilter/resources/securityfilter-config_1_0.dtd");
        if (dtd1_0 != null) {
            digester.register("-//SecurityFilter.org//DTD Security Filter Configuration 1.0//EN", dtd1_0.toString());
        }
        if ((dtd1_1 = this.getClass().getResource("/org/securityfilter/resources/securityfilter-config_1_1.dtd")) != null) {
            digester.register("-//SecurityFilter.org//DTD Security Filter Configuration 1.1//EN", dtd1_1.toString());
        }
        if ((dtd2_0 = this.getClass().getResource("/org/securityfilter/resources/securityfilter-config_2_0.dtd")) != null) {
            digester.register("-//SecurityFilter.org//DTD Security Filter Configuration 2.0//EN", dtd2_0.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

