/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import ch.ubique.inieditor.IniEditor;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.makumba.ConfigurationError;
import org.makumba.commons.FileUtils;
import org.makumba.providers.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakumbaINIFileReader
extends IniEditor {
    private URL url;
    private MakumbaINIFileReader defaultProperty;

    public MakumbaINIFileReader(URL url, MakumbaINIFileReader defaultProperty) throws IOException {
        this(url);
        this.defaultProperty = defaultProperty;
    }

    public MakumbaINIFileReader(URL url) throws IOException {
        super(true);
        this.url = url;
        this.load(FileUtils.getInputStream(url));
    }

    public String getStringProperty(String section, String property, MakumbaINIFileReader otherConfig) {
        return this.get(section, property) != null ? this.get(section, property) : otherConfig.get(section, property);
    }

    public String getProperty(String section, String property) {
        return this.get(section, property) != null ? this.get(section, property) : (this.defaultProperty != null && this.defaultProperty.getProperty(section, property) != null ? this.defaultProperty.getProperty(section, property) : "PROPERTY_NOT_SET");
    }

    public boolean getBooleanProperty(String section, String property, MakumbaINIFileReader otherConfig) {
        return Boolean.parseBoolean(this.get(section, property) != null ? this.get(section, property) : otherConfig.get(section, property));
    }

    public Map<String, String> getProperties(String section) {
        List optionNames = null;
        try {
            optionNames = this.optionNames(section);
        }
        catch (IniEditor.NoSuchSectionException nsse) {
            throw new ConfigurationError("Section " + section + " does not exist in Makumba.conf");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Object object : optionNames) {
            ret.put((String)object, this.getProperty(section, (String)object));
        }
        return ret;
    }

    public Map<String, String> getProperties(String section, MakumbaINIFileReader defaultConfig) {
        Map<String, String> defaults = defaultConfig.getProperties(section);
        if (this.hasSection(section)) {
            Map<String, String> application = this.getProperties(section);
            Set<String> keySet = application.keySet();
            for (String string : keySet) {
                if (application.get(string) == null) continue;
                defaults.put(string, application.get(string));
            }
        } else {
            Configuration.logger.info("No application specific config found for '" + section + "', using only internal defaults.");
        }
        return defaults;
    }

    public Map<String, Map<String, String>> getPropertiesStartingWith(String sectionPrefix) {
        LinkedHashMap<String, Map<String, String>> res = new LinkedHashMap<String, Map<String, String>>();
        List sectionNames = this.sectionNames();
        for (String section : sectionNames) {
            if (!section.startsWith(sectionPrefix)) continue;
            res.put(section.substring(sectionPrefix.length()), this.getProperties(section));
        }
        return res;
    }

    public String getSource() {
        return this.url.getPath();
    }
}

