/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet.jsp.tagext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.servlet.TidyProcessor;

public class TidyTag
extends BodyTagSupport {
    private static final long serialVersionUID = 29137L;
    private String config;
    private boolean validateOnly;
    private boolean bypass;

    public int doStartTag() throws JspException {
        if (this.bypass) {
            this.pageContext.setAttribute("JTidyIgnore", (Object)Boolean.TRUE);
            return 1;
        }
        if (this.pageContext.getRequest().getAttribute("JTidyIgnore") != null) {
            this.bypass = true;
            return 1;
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        if (!this.bypass) {
            TidyProcessor tidyProcessor = new TidyProcessor(this.pageContext.getSession(), (HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse());
            tidyProcessor.setValidateOnly(this.validateOnly);
            tidyProcessor.setDoubleValidation(true);
            tidyProcessor.setConfig(this.config);
            String html = this.getBodyContent().getString();
            ByteArrayInputStream in = new ByteArrayInputStream(html.getBytes());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            boolean useOut = tidyProcessor.parse(in, out, html);
            try {
                if (useOut && !this.validateOnly) {
                    this.pageContext.getOut().write(out.toString());
                } else {
                    this.pageContext.getOut().write(html);
                }
            }
            catch (Exception e) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"TidyTag write error", (Throwable)e);
                throw new JspException(e.getMessage());
            }
        }
        return 6;
    }

    public void release() {
        super.release();
        this.config = null;
        this.validateOnly = false;
        this.bypass = false;
    }

    public void setConfig(String configuration) {
        this.config = configuration;
    }

    public void setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
    }

    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }
}

