/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class BlockParentHandler
extends ExpressionHandler {
    private static final int[] CHECKED_CHILDREN = new int[]{10, 28, 6, 87};

    public BlockParentHandler(IndentationCheck aIndentCheck, String aName, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, aName, aAst, aParent);
    }

    protected DetailAST getToplevelAST() {
        return this.getMainAst();
    }

    protected void checkToplevelToken() {
        DetailAST toplevel = this.getToplevelAST();
        if (toplevel == null || this.getLevel().accept(this.expandedTabsColumnNo(toplevel))) {
            return;
        }
        if (!this.toplevelMustStartLine() && !this.startsLine(toplevel)) {
            return;
        }
        this.logError(toplevel, "", this.expandedTabsColumnNo(toplevel));
    }

    protected boolean toplevelMustStartLine() {
        return true;
    }

    protected boolean hasCurlys() {
        return this.getLCurly() != null && this.getRCurly() != null;
    }

    protected DetailAST getLCurly() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRCurly() {
        DetailAST slist = this.getMainAst().findFirstToken(7);
        if (slist == null) {
            return null;
        }
        return slist.findFirstToken(73);
    }

    protected void checkLCurly() {
        DetailAST lcurly = this.getLCurly();
        int lcurlyPos = this.expandedTabsColumnNo(lcurly);
        if (lcurly == null || this.curlyLevel().accept(lcurlyPos) || !this.startsLine(lcurly)) {
            return;
        }
        this.logError(lcurly, "lcurly", lcurlyPos);
    }

    private IndentLevel curlyLevel() {
        return new IndentLevel(this.getLevel(), this.getBraceAdjustement());
    }

    protected boolean rcurlyMustStart() {
        return true;
    }

    protected boolean childrenMayNest() {
        return false;
    }

    protected void checkRCurly() {
        DetailAST lcurly = this.getLCurly();
        DetailAST rcurly = this.getRCurly();
        int rcurlyPos = this.expandedTabsColumnNo(rcurly);
        if (rcurly == null || this.curlyLevel().accept(rcurlyPos) || !this.rcurlyMustStart() && !this.startsLine(rcurly) || BlockParentHandler.areOnSameLine(rcurly, lcurly)) {
            return;
        }
        this.logError(rcurly, "rcurly", rcurlyPos, this.curlyLevel());
    }

    protected DetailAST getNonlistChild() {
        return (DetailAST)this.getMainAst().findFirstToken(77).getNextSibling();
    }

    private void checkNonlistChild() {
        DetailAST nonlist = this.getNonlistChild();
        if (nonlist == null) {
            return;
        }
        IndentLevel expected = new IndentLevel(this.getLevel(), this.getBasicOffset());
        this.checkExpressionSubtree(nonlist, expected, false, false);
    }

    protected DetailAST getListChild() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRParen() {
        return this.getMainAst().findFirstToken(77);
    }

    protected DetailAST getLParen() {
        return this.getMainAst().findFirstToken(76);
    }

    protected void checkRParen() {
        DetailAST rparen = this.getRParen();
        if (rparen == null) {
            return;
        }
        int rparenLevel = this.expandedTabsColumnNo(rparen);
        if (this.getLevel().accept(rparenLevel) || !this.startsLine(rparen)) {
            return;
        }
        DetailAST lparen = this.getLParen();
        int lparenLevel = this.expandedTabsColumnNo(lparen);
        if (rparenLevel == lparenLevel + 1) {
            return;
        }
        this.logError(rparen, "rparen", this.expandedTabsColumnNo(rparen));
    }

    protected void checkLParen() {
        DetailAST lparen = this.getLParen();
        if (lparen == null || this.getLevel().accept(this.expandedTabsColumnNo(lparen)) || !this.startsLine(lparen)) {
            return;
        }
        this.logError(lparen, "lparen", this.expandedTabsColumnNo(lparen));
    }

    public void checkIndentation() {
        DetailAST listChild;
        this.checkToplevelToken();
        this.checkLParen();
        this.checkRParen();
        if (this.hasCurlys()) {
            this.checkLCurly();
            this.checkRCurly();
        }
        if ((listChild = this.getListChild()) != null) {
            if (!this.hasCurlys() || !BlockParentHandler.areOnSameLine(this.getLCurly(), this.getRCurly())) {
                this.checkChildren(listChild, CHECKED_CHILDREN, this.getChildrenExpectedLevel(), true, this.childrenMayNest());
            }
        } else {
            this.checkNonlistChild();
        }
    }

    protected IndentLevel getChildrenExpectedLevel() {
        return new IndentLevel(this.getLevel(), this.getBasicOffset());
    }
}

