/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.devel.DevelUtils;
import org.makumba.devel.SourceViewControllerHandler;
import org.makumba.providers.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakumbaResourceServlet
extends HttpServlet {
    private static final String resourceDirectory = "makumbaResources";
    private static final long serialVersionUID = 1L;
    public static final String RESOURCE_PATH_JAVASCRIPT = "javaScript/";
    public static final String RESOURCE_PATH_CSS = "css/";
    public static final String RESOURCE_PATH_IMAGES = "image/";
    public static final SimpleDateFormat dfLastModified = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    public static int makumbaResources = NamedResources.makeStaticCache("Makumba resources", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        public Object getHashObject(Object o) {
            return ClassResource.get(MakumbaResourceServlet.resourceDirectory + o);
        }

        public Object makeResource(Object o, Object hashName) throws Throwable {
            byte b;
            InputStream stream;
            if (hashName == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            URL url = (URL)hashName;
            if (url.toExternalForm().startsWith("jar:")) {
                JarFile jf = ((JarURLConnection)url.openConnection()).getJarFile();
                String[] jarURL = url.toExternalForm().split("!");
                JarEntry je = jf.getJarEntry(jarURL[1].substring(1));
                stream = jf.getInputStream(je);
            } else {
                stream = url.openStream();
            }
            if (MakumbaResourceServlet.isBinary(url)) {
                ArrayList<Byte> bytesList = new ArrayList<Byte>();
                byte[] b2 = new byte[16];
                int readBytes = -1;
                while ((readBytes = stream.read(b2)) != -1) {
                    for (int i = 0; i < readBytes; ++i) {
                        bytesList.add(b2[i]);
                    }
                }
                byte[] bytes = new byte[bytesList.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (Byte)bytesList.get(i);
                }
                return bytes;
            }
            BufferedReader bis = new BufferedReader(new InputStreamReader(stream));
            while ((b = (byte)bis.read()) != -1) {
                sb.append(String.valueOf((char)b));
            }
            return sb.toString();
        }
    }, true);
    public static final String[] imageContentTypes = new String[]{"jpg", "jpeg", "png", "gif", "pjpeg", "tiff", "bmp", "x-emf", "x-wmf", "x-xbitmap"};

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String servletPath = req.getContextPath() + Configuration.getMakumbaResourcesLocation();
        String requestURI = req.getRequestURI();
        String resource = requestURI.substring(requestURI.indexOf(servletPath) + servletPath.length());
        URL url = ClassResource.get(resourceDirectory + resource);
        try {
            Date lastModified;
            File file = null;
            ZipEntry jarEntry = null;
            JarFile jarFile = null;
            if (!url.toExternalForm().startsWith("jar:")) {
                file = new File(url.toURI());
            } else {
                jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                String[] jarURL = url.toExternalForm().split("!");
                jarEntry = jarFile.getJarEntry(jarURL[1].substring(1));
            }
            if (file != null && file.isDirectory()) {
                PrintWriter writer = resp.getWriter();
                resp.setContentType("text/html");
                DevelUtils.writePageBegin(writer);
                DevelUtils.writeTitleAndHeaderEnd(writer, "Makumba resources");
                if (DevelUtils.redirected(req, resp, resource)) {
                    return;
                }
                String relativeDirectory = file.getName();
                if (file.getAbsolutePath().indexOf(resourceDirectory) != -1) {
                    relativeDirectory = file.getAbsolutePath().substring(file.getAbsolutePath().indexOf(resourceDirectory));
                }
                SourceViewControllerHandler.printDirlistingHeader(writer, file.getCanonicalPath(), relativeDirectory, req.getContextPath(), null);
                if (!relativeDirectory.equals(resourceDirectory)) {
                    writer.println("<b><a href=\"../\">../</a></b> (up one level)");
                }
                SourceViewControllerHandler.processDirectory(writer, file, null);
                Object[] list = file.list();
                Arrays.sort(list);
                for (int i = 0; i < list.length; ++i) {
                    Object s = list[i];
                    File f = new File(file.getAbsolutePath() + File.separator + (String)s);
                    if (!f.isFile()) continue;
                    writer.println("<b><a href=\"" + (String)s + "\">" + (String)s + "</a></b>");
                }
                writer.println("</pre>");
                DevelUtils.writePageEnd(writer);
                resp.setHeader("Last-Modified", dfLastModified.format(new Date()));
                return;
            }
            if (jarEntry != null && jarEntry.isDirectory()) {
                Enumeration<JarEntry> entries = jarFile.entries();
                ArrayList<String> files = new ArrayList<String>();
                ArrayList<String> directories = new ArrayList<String>();
                PrintWriter writer = resp.getWriter();
                resp.setContentType("text/html");
                DevelUtils.writePageBegin(writer);
                DevelUtils.writeTitleAndHeaderEnd(writer, "Makumba resources");
                if (DevelUtils.redirected(req, resp, resource)) {
                    return;
                }
                String relativeDirectory = jarEntry.getName();
                SourceViewControllerHandler.printDirlistingHeader(writer, url.toExternalForm(), relativeDirectory, req.getContextPath(), null);
                if (!relativeDirectory.equals(resourceDirectory) && !relativeDirectory.equals("makumbaResources/")) {
                    writer.println("<b><a href=\"../\">../</a></b> (up one level)");
                }
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(relativeDirectory)) continue;
                    String s = entry.getName().substring(relativeDirectory.length());
                    while (s.length() > 0 && s.startsWith("/")) {
                        s = s.substring(1);
                    }
                    if (s.indexOf("/") == -1) {
                        if (s.length() <= 0) continue;
                        files.add(s);
                        continue;
                    }
                    if (s.indexOf("/") != s.lastIndexOf("/") || !s.endsWith("/")) continue;
                    if (s.endsWith("/")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    if (s.length() <= 0) continue;
                    directories.add(s);
                }
                for (String string : directories) {
                    writer.println("<b><a href=\"" + string + "/\">" + string + "/</a></b>");
                }
                for (String string : files) {
                    writer.println("<b><a href=\"" + string + "\">" + string + "</a></b>");
                }
                writer.println("</pre>");
                DevelUtils.writePageEnd(writer);
                resp.setHeader("Last-Modified", dfLastModified.format(new Date()));
                return;
            }
            if (jarEntry != null && jarEntry.getSize() == 0L && DevelUtils.redirected(req, resp, resource)) {
                return;
            }
            if (url.toExternalForm().startsWith("jar:")) {
                JarFile jf = ((JarURLConnection)url.openConnection()).getJarFile();
                String[] jarURL = url.toExternalForm().split("!");
                lastModified = new Date(jf.getJarEntry(jarURL[1].substring(1)).getTime());
            } else {
                lastModified = new Date(new File(url.toURI()).lastModified());
            }
            resp.setHeader("Last-Modified", dfLastModified.format(lastModified));
            resp.setContentType(MakumbaResourceServlet.getContentType(url));
            Object cachedResource = NamedResources.getStaticCache(makumbaResources).getResource(resource);
            ServletOutputStream outputStream = resp.getOutputStream();
            if (MakumbaResourceServlet.isBinary(url)) {
                for (int i = 0; i < ((byte[])cachedResource).length; ++i) {
                    outputStream.write((int)((byte[])cachedResource)[i]);
                }
            } else if (cachedResource.toString().contains("_CONTEXT_PATH_")) {
                outputStream.print(cachedResource.toString().replaceAll("_CONTEXT_PATH_", req.getContextPath()));
            } else if (cachedResource.toString().contains("_UNIQUENESS_SERVLET_PATH_")) {
                String uniquenessPath = req.getContextPath() + Configuration.getMakumbaUniqueLocation();
                outputStream.print(cachedResource.toString().replaceAll("_UNIQUENESS_SERVLET_PATH_", uniquenessPath));
            } else {
                outputStream.print(cachedResource.toString());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void printLineBreaks(String s, OutputStream o) throws IOException {
        byte[] bytes = s.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 10) {
                o.write(bytes[i]);
                continue;
            }
            o.write(10);
            o.write(bytes[i]);
        }
    }

    public static void writeResources(StringBuffer sb, String contextPath, Iterable<Object> resources) {
        for (Object object : resources) {
            String o = (String)object;
            String alternateLocation = Configuration.getResourceLocation(o);
            if (o.endsWith(".js")) {
                MakumbaResourceServlet.writeScriptsInHeader(sb, contextPath, o, alternateLocation);
                continue;
            }
            if (!o.endsWith(".css")) continue;
            MakumbaResourceServlet.writeStylesInHeader(sb, contextPath, o, alternateLocation);
        }
    }

    public static void writeStylesInHeader(StringBuffer sb, String contextPath, String styleSheet, String alternateLocation) {
        String filerefName = "fileref" + styleSheet.replace(".", "").replace("-", "_");
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("var " + filerefName + " = document.createElement('link');\n");
        sb.append(filerefName + ".setAttribute(\"media\",\"all\");\n");
        sb.append(filerefName + ".setAttribute(\"type\",\"text/css\");\n");
        String location = "";
        location = alternateLocation != "PROPERTY_NOT_SET" ? contextPath + "/" + alternateLocation : contextPath + Configuration.getMakumbaResourcesLocation() + "/" + RESOURCE_PATH_CSS + styleSheet;
        sb.append(filerefName + ".setAttribute(\"href\", '" + location + "');\n");
        sb.append(filerefName + ".setAttribute(\"rel\",\"StyleSheet\");\n");
        sb.append("if (typeof " + filerefName + " != \"undefined\")\n");
        sb.append("document.getElementsByTagName(\"head\")[0].appendChild(" + filerefName + ");\n");
        sb.append("</script>\n");
    }

    public static String getContentType(URL url) {
        for (int i = 0; i < imageContentTypes.length; ++i) {
            if (!url.getFile().endsWith("." + imageContentTypes[i])) continue;
            return "image / " + imageContentTypes[i];
        }
        if (url.getFile().endsWith(".css")) {
            return "text/css";
        }
        if (url.getFile().endsWith(".js")) {
            return "text/javascript";
        }
        return "text/html";
    }

    public static boolean isImageType(URL url) {
        for (int i = 0; i < imageContentTypes.length; ++i) {
            if (!url.getFile().endsWith("." + imageContentTypes[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isBinary(URL url) {
        return MakumbaResourceServlet.isImageType(url);
    }

    public static void writeScriptsInHeader(StringBuffer sb, String contextPath, String script, String alternateLocation) {
        String filerefName = "fileref" + script.replace(".", "").replace("-", "_");
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("var " + filerefName + " = document.createElement('script');\n");
        sb.append(filerefName + ".setAttribute(\"type\",\"text/javascript\");\n");
        String location = "";
        location = alternateLocation != "PROPERTY_NOT_SET" ? contextPath + "/" + alternateLocation : contextPath + Configuration.getMakumbaResourcesLocation() + "/" + RESOURCE_PATH_JAVASCRIPT + script;
        sb.append(filerefName + ".setAttribute(\"href\", '" + location + "');\n");
        sb.append(filerefName + ".setAttribute(\"src\", '" + contextPath + Configuration.getMakumbaResourcesLocation() + "/" + RESOURCE_PATH_JAVASCRIPT + script + "');\n");
        sb.append("document.getElementsByTagName(\"head\")[0].appendChild(" + filerefName + ");\n");
        sb.append("</script>\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExternalResource {
        PROTOTYPE("prototype", "prototype.js"),
        SCRIPTACULOUS("scriptaculous", "scriptaculous.js");

        String name;
        String key;

        private ExternalResource(String key, String name) {
            this.name = name;
            this.key = key;
        }

        String getKey() {
            return this.key;
        }

        String getName() {
            return this.name;
        }
    }
}

