/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.makumba.ConfigurationError;
import org.makumba.MakumbaError;
import org.makumba.Transaction;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.SingletonReleaser;
import org.makumba.db.makumba.DBConnectionWrapper;
import org.makumba.db.makumba.Database;
import org.makumba.db.makumba.MakumbaCRUDOperationProvider;
import org.makumba.providers.CRUDOperationProvider;
import org.makumba.providers.Configuration;
import org.makumba.providers.TransactionProvider;

public class MakumbaTransactionProvider
extends TransactionProvider {
    public static final String DATABASE_CLASS = "database_class";
    public static final String TABLE_CLASS = "table_class";
    public static final String CONNECTION_HOST = "host";
    public static final String CONNECTION_PORT = "port";
    public static final String CONNECTION_ENGINE = "engine";
    public static final String CONNECTION_DATABASE = "database";
    static Class<?>[] theProp = new Class[]{Properties.class};
    static int dbs = NamedResources.makeStaticCache("Databases open", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        protected Object makeResource(Object nm) {
            Properties p = new Properties();
            String name = (String)nm;
            Map<String, String> properties = Configuration.getDataSourceConfiguration(name);
            for (String property : properties.keySet()) {
                String value = properties.get(property);
                if (property.startsWith("connection.")) {
                    if ((property = property.substring("connection.".length())).equals("username")) {
                        property = "sql.user";
                    }
                    if (property.equals("password")) {
                        property = "sql.password";
                    }
                }
                p.put(property, value);
            }
            String jdbcURL = p.getProperty("url");
            if (jdbcURL != null) {
                if (!jdbcURL.startsWith("jdbc:")) {
                    throw new ConfigurationError("jdbcConnectionUrl of dataSource " + name + " invalid, should start with jdbc:");
                }
                p.put("jdbc_url", jdbcURL);
                String sqlEngine = jdbcURL.substring(5);
                sqlEngine = sqlEngine.substring(0, sqlEngine.indexOf(":"));
                p.put("#sqlEngine", sqlEngine);
            } else {
                String[] requiredProps;
                for (String prop : requiredProps = new String[]{MakumbaTransactionProvider.CONNECTION_HOST, MakumbaTransactionProvider.CONNECTION_DATABASE, MakumbaTransactionProvider.CONNECTION_ENGINE}) {
                    if (p.get(prop) != null) continue;
                    throw new ConfigurationError("Property " + prop + " not defined for dataSource " + name);
                }
                if (p.getProperty(MakumbaTransactionProvider.CONNECTION_PORT) != null) {
                    p.put("#host", p.getProperty(MakumbaTransactionProvider.CONNECTION_HOST) + ":" + p.getProperty(MakumbaTransactionProvider.CONNECTION_PORT));
                } else {
                    p.put("#host", p.getProperty(MakumbaTransactionProvider.CONNECTION_HOST));
                }
                p.put("#sqlEngine", p.getProperty(MakumbaTransactionProvider.CONNECTION_ENGINE));
                p.put("#database", p.getProperty(MakumbaTransactionProvider.CONNECTION_DATABASE));
            }
            try {
                String dbclass = (String)p.get(MakumbaTransactionProvider.DATABASE_CLASS);
                if (dbclass == null && (dbclass = org.makumba.db.makumba.sql.Database.getEngineProperty(p.getProperty("#sqlEngine") + "." + MakumbaTransactionProvider.DATABASE_CLASS)) == null) {
                    dbclass = "org.makumba.db.makumba.sql.Database";
                }
                p.put("db.name", name);
                Object[] pr = new Object[]{p};
                try {
                    Database d = (Database)Class.forName(dbclass).getConstructor(theProp).newInstance(pr);
                    d.dataSourceName = name;
                    d.tables = new NamedResources("Database tables for " + name, d.tableFactory);
                    return d;
                }
                catch (InvocationTargetException ite) {
                    throw new MakumbaError(ite.getTargetException());
                }
            }
            catch (Exception e) {
                throw new MakumbaError(e);
            }
        }
    });
    private Configuration.DataSourceType lastConnectionType = Configuration.DataSourceType.makumba;

    public static TransactionProvider getInstance() {
        return SingletonHolder.singleton;
    }

    private MakumbaTransactionProvider() {
    }

    public static Database getDatabase(String name) {
        try {
            return (Database)NamedResources.getStaticCache(dbs).getResource(name);
        }
        catch (RuntimeWrappedException e) {
            if (e.getCause() instanceof MakumbaError) {
                throw (MakumbaError)e.getCause();
            }
            throw e;
        }
    }

    public Transaction getConnectionTo(String name) {
        return super.getConnectionTo(name, this);
    }

    public static String getDatabaseProperty(String name, String propName) {
        return MakumbaTransactionProvider.getDatabase(name).getConfiguration(propName);
    }

    public void _copy(String sourceDB, String destinationDB, String[] typeNames, boolean ignoreDbsv) {
        MakumbaTransactionProvider.getDatabase(destinationDB).copyFrom(sourceDB, typeNames, ignoreDbsv);
    }

    public void _delete(String whereDB, String provenienceDB, String[] typeNames, boolean ignoreDbsv) {
        MakumbaTransactionProvider.getDatabase(whereDB).deleteFrom(provenienceDB, typeNames, ignoreDbsv);
    }

    public String getQueryLanguage() {
        return super.getQueryLanguage(this);
    }

    public CRUDOperationProvider getCRUD() {
        return super.getCRUD(this);
    }

    protected Transaction getTransaction(String name) {
        return (DBConnectionWrapper)MakumbaTransactionProvider.getDatabase(name).getDBConnection(name);
    }

    protected CRUDOperationProvider getCRUDInternal() {
        return CRUDOperationProviderSingletonHolder.singleton;
    }

    protected String getQueryLanguageInternal() {
        return "oql";
    }

    protected Configuration.DataSourceType getLastConnectionType() {
        return this.lastConnectionType;
    }

    protected void setLastConnectionType(Configuration.DataSourceType type) {
        this.lastConnectionType = type;
    }

    private static class CRUDOperationProviderSingletonHolder
    implements org.makumba.commons.SingletonHolder {
        private static CRUDOperationProvider singleton = new MakumbaCRUDOperationProvider();

        public void release() {
            singleton = null;
        }

        public CRUDOperationProviderSingletonHolder() {
            SingletonReleaser.register(this);
        }
    }

    private static class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        private static TransactionProvider singleton = new MakumbaTransactionProvider();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

