/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Vector;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.commons.ReservedKeywords;
import org.makumba.providers.datadefinition.mdd.MDDAST;
import org.makumba.providers.datadefinition.mdd.MDDBaseParser;
import org.makumba.providers.datadefinition.mdd.MDDExpressionParser;
import org.makumba.providers.datadefinition.mdd.MDDFactory;
import org.makumba.providers.datadefinition.mdd.MDDLexer;
import org.makumba.providers.query.mql.HqlParser;
import org.makumba.providers.query.mql.Node;

public class MDDParser
extends MDDBaseParser {
    private MDDFactory factory = null;
    protected Vector<String> includedFieldNames = new Vector();
    protected HashMap<AST, AST> parsedFunctions = new HashMap();
    private HashMap<String, AST> fieldsToDisable = new HashMap();

    public MDDParser(TokenStream lexer, MDDFactory factory, String typeName, boolean included) {
        super(lexer);
        this.factory = factory;
        this.typeName = typeName;
        this.included = included;
    }

    protected AST include(AST type) {
        AST included = null;
        try {
            included = this.factory.parseIncludedDataDefinition(type.getText()).getAST();
        }
        catch (DataDefinitionNotFoundError e) {
            this.factory.doThrow(type.getText(), "Could not find included data definition", type);
        }
        return included;
    }

    protected AST includeSubField(AST type, AST parentField) {
        AST included = this.include(type);
        return this.transformToSubfield(parentField, included);
    }

    private AST transformToSubfield(AST parentField, AST included) {
        MDDAST result = null;
        for (AST t = included; t != null; t = t.getNextSibling()) {
            MDDAST subfield = new MDDAST();
            subfield.setText("->!");
            subfield.setType(27);
            subfield.setLine(parentField.getLine());
            MDDAST parentFieldName = new MDDAST();
            parentFieldName.setText(parentField.getText());
            parentFieldName.setType(62);
            parentFieldName.setLine(parentField.getLine());
            subfield.setFirstChild((AST)parentFieldName);
            if (t.getType() == 51 || t.getType() == 52) {
                subfield.getFirstChild().setNextSibling(t);
            } else {
                t.getFirstChild().setType(63);
                this.includedFieldNames.add(t.getText());
                subfield.getFirstChild().setNextSibling(t.getFirstChild());
            }
            if (result == null) {
                result = subfield;
                continue;
            }
            this.getLastSibling((AST)result).setNextSibling((AST)subfield);
        }
        return result;
    }

    private AST getLastSibling(AST t) {
        while (t.getNextSibling() != null) {
            t = t.getNextSibling();
        }
        return t;
    }

    protected void disableField(AST field) {
        this.fieldsToDisable.put(field.getText(), field);
    }

    protected void postProcess() {
        AST t = this.getAST();
        AST prec = null;
        while (t != null && t.getNextSibling() != null) {
            prec = t;
            if ((t = t.getNextSibling()).getType() != 46 || !this.fieldsToDisable.containsKey(t.getText())) continue;
            prec.setNextSibling(t.getNextSibling());
            this.fieldsToDisable.remove(t.getText());
        }
        for (String key : this.fieldsToDisable.keySet()) {
            this.factory.doThrow(this.typeName, "Fields cannot have an empty body unless they override an included field", this.fieldsToDisable.get(key));
        }
    }

    protected AST parseExpression(AST expression) {
        AST tree;
        StringReader in = new StringReader(expression.getText());
        MDDLexer lexer = new MDDLexer(in);
        MDDExpressionParser parser = new MDDExpressionParser(lexer, this.factory, this.typeName, expression);
        parser.setASTNodeClass("org.makumba.providers.datadefinition.mdd.MDDAST");
        try {
            parser.expression();
        }
        catch (RecognitionException e) {
            e.column = expression.getColumn() + e.column;
            e.line = expression.getLine();
            this.factory.doThrow(e, expression, this.typeName);
        }
        catch (TokenStreamException e) {
            this.factory.doThrow(e, expression, this.typeName);
        }
        if (parser.error != null && parser.error instanceof RecognitionException) {
            RecognitionException e = parser.error;
            e.column = expression.getColumn() + e.column;
            e.line = expression.getLine();
            this.factory.doThrow(e, expression, this.typeName);
        }
        if ((tree = parser.getAST()) != null) {
            this.shift(tree, expression);
        }
        return parser.getAST();
    }

    protected AST parseFunctionBody(AST expression) {
        AST tree;
        boolean subquery = expression.getText().toUpperCase().startsWith("SELECT ");
        int offset = "SELECT ".length();
        if (subquery) {
            ++offset;
        }
        String query = "SELECT " + (subquery ? "(" : "") + expression.getText() + (subquery ? ")" : "") + " FROM " + this.typeName + " makumbaGeneratedAlias";
        HqlParser parser = HqlParser.getInstance(query);
        try {
            parser.statement();
        }
        catch (RecognitionException e) {
            e.column = expression.getColumn() + e.column;
            e.line = expression.getLine();
            this.factory.doThrow(e, expression, this.typeName);
        }
        catch (TokenStreamException e) {
            this.factory.doThrow(e, expression, this.typeName);
        }
        if (parser.getError() != null && parser.getError() instanceof RecognitionException) {
            RecognitionException e = (RecognitionException)((Object)parser.getError());
            e.column = expression.getColumn() + e.column - offset;
            e.line = expression.getLine();
            this.factory.doThrow(e, expression, this.typeName);
        }
        if ((tree = parser.getAST()) != null) {
            this.shiftHql(tree, expression, offset);
        }
        return parser.getAST();
    }

    private void shift(AST toShift, AST parent) {
        ((MDDAST)toShift).setLine(parent.getLine());
        ((MDDAST)toShift).setCol(parent.getColumn() + toShift.getColumn());
        if (toShift.getNextSibling() != null) {
            this.shift(toShift.getNextSibling(), parent);
        }
        if (toShift.getFirstChild() != null) {
            this.shift(toShift.getFirstChild(), parent);
        }
    }

    private void shiftHql(AST toShift, AST parent, int offset) {
        ((Node)toShift).setLine(parent.getLine());
        ((Node)toShift).setCol(parent.getColumn() + toShift.getColumn() + offset);
        if (toShift.getNextSibling() != null) {
            this.shiftHql(toShift.getNextSibling(), parent, offset);
        }
        if (toShift.getFirstChild() != null) {
            this.shiftHql(toShift.getFirstChild(), parent, offset);
        }
    }

    protected void errorNestedSubfield(AST s) {
        this.factory.doThrow(this.typeName, "Nested subtypes are not allowed", s);
    }

    protected void checkFieldName(AST fieldName) {
        String nm = fieldName.getText();
        for (int i = 0; i < nm.length(); ++i) {
            if ((i != 0 || Character.isJavaIdentifierStart(nm.charAt(i))) && (i <= 0 || Character.isJavaIdentifierPart(nm.charAt(i)))) continue;
            this.factory.doThrow(this.typeName, "Invalid character \"" + nm.charAt(i) + "\" in field name \"" + nm, fieldName);
        }
        if (ReservedKeywords.isReservedKeyword(nm)) {
            this.factory.doThrow(this.typeName, "Error: field name cannot be one of the reserved keywords " + ReservedKeywords.getKeywordsAsString(), fieldName);
        }
    }

    protected void addParsedFunction(AST a, AST b) {
        this.parsedFunctions.put(a, b);
    }
}

