/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.policy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freshcookies.security.policy.PolicyException;
import org.freshcookies.security.policy.SecurityTokenFactory;

public class PolicyReader {
    private static final Pattern COMMENTS_PATTERN = Pattern.compile("^\\s*\\/\\/.*$", 8);
    private static final Pattern KEYSTORE_PATTERN = Pattern.compile("^keystore \"(.*?)\";.*$", 2);
    private static final Pattern GRANT_PATTERN = Pattern.compile("grant(.*?) \\{ *(.*?) *\\};");
    private static final Pattern LINEBREAKS_PATTERN = Pattern.compile("[\\n|\\r\\n|\\u0085|\\u2028|\\u2029]", 8);
    private static final String PROP_JAVA_HOME = "java.home";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_JAVA_SECURITY_POLICY = "java.security.policy";
    private static final String REGEX_COMMA_DELIMITER = " *, *";
    private static final String REGEX_SEMICOLON_DELIMITER = " *; *";
    private static final String TOKEN_CODEBASE = "codeBase";
    private static final String TOKEN_PRINCIPAL = "principal";
    private static final String TOKEN_PERMISSION = "permission";
    private static final String TOKEN_SIGNEDBY = "signedBy";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String ONE_SPACE = " ";
    private static final String WHITESPACE = "\\s+";
    private static final int NOT_FOUND = -1;
    private final File policy;
    private final List domains;
    private KeyStore keystore = null;
    private File keystoreFile = null;
    private String policyString = null;
    private final List exceptions = new ArrayList();
    private SecurityTokenFactory tokenFactory = null;
    private boolean validPolicy = false;
    private final String charset;

    public PolicyReader(File file) throws FileNotFoundException {
        this(file, (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("file.encoding");
            }
        }));
    }

    public PolicyReader(File file, String charset) throws FileNotFoundException {
        this.policy = file;
        this.domains = new ArrayList();
        this.charset = charset;
        boolean exists = PolicyReader.secureExists(this.policy);
        if (!exists) {
            throw new IllegalArgumentException("File " + this.policy + " does not exist, or the SecurityManager prohibited access to it.");
        }
        this.tokenFactory = (SecurityTokenFactory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() throws SecurityException {
                return new SecurityTokenFactory(new URL[0]);
            }
        });
    }

    public static String findAlias(KeyStore ks, Certificate cert) {
        try {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Certificate keystoreCert;
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias) || !cert.equals(keystoreCert = ks.getCertificate(alias))) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    public ProtectionDomain[] getProtectionDomains() {
        return this.domains.toArray(new ProtectionDomain[this.domains.size()]);
    }

    public static PolicyReader[] findPolicies() {
        final HashSet files = new HashSet();
        final String fs = File.separator;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String policyProp;
                File userPolicy;
                File systemPolicy = new File(System.getProperty(PolicyReader.PROP_JAVA_HOME) + fs + "lib" + fs + "security" + fs + "java.policy");
                if (systemPolicy.exists()) {
                    files.add(systemPolicy);
                }
                if ((userPolicy = new File(System.getProperty(PolicyReader.PROP_USER_HOME) + fs + ".java.policy")).exists()) {
                    files.add(userPolicy);
                }
                if ((policyProp = System.getProperty(PolicyReader.PROP_JAVA_SECURITY_POLICY)) != null) {
                    File propertyPolicy;
                    if (policyProp.startsWith("file:")) {
                        policyProp = policyProp.substring(5);
                    }
                    if (policyProp.length() > 0 && PolicyReader.secureExists(propertyPolicy = new File(policyProp))) {
                        files.add(propertyPolicy);
                    }
                }
                return null;
            }
        });
        ArrayList<PolicyReader> readers = new ArrayList<PolicyReader>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            try {
                readers.add(new PolicyReader((File)it.next()));
            }
            catch (FileNotFoundException e) {}
        }
        return readers.toArray(new PolicyReader[readers.size()]);
    }

    public static Certificate getSigner(final Class clazz) {
        Certificate[] certs;
        CodeSource cs;
        ProtectionDomain pd = null;
        pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getProtectionDomain();
            }
        });
        if (pd != null && (cs = pd.getCodeSource()) != null && (certs = cs.getCertificates()) != null && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    public static boolean isSigned(Class clazz) {
        Certificate cert = PolicyReader.getSigner(clazz);
        return cert != null;
    }

    public File getFile() {
        return this.policy;
    }

    public KeyStore getKeyStore() throws IOException {
        if (this.keystore == null) {
            Matcher matcher;
            if (this.policyString == null) {
                this.loadPolicy(this.policy);
            }
            if ((matcher = KEYSTORE_PATTERN.matcher(this.policyString)).matches()) {
                String match = matcher.group(1);
                this.keystoreFile = new File(match);
                if (!this.keystoreFile.isAbsolute()) {
                    this.keystoreFile = new File(this.policy.getParentFile(), match);
                    if (!PolicyReader.secureExists(this.keystoreFile)) {
                        throw new IOException("Couldn't find keystore " + this.keystoreFile + ", or the SecurityManager prohibited access to it.");
                    }
                }
            }
            if (this.keystoreFile != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            try {
                                FileInputStream is = new FileInputStream(PolicyReader.this.keystoreFile);
                                PolicyReader.this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                                PolicyReader.this.keystore.load(is, null);
                                return null;
                            }
                            catch (CertificateException e) {
                                throw new IOException(e.getMessage());
                            }
                            catch (KeyStoreException e) {
                                throw new IOException(e.getMessage());
                            }
                            catch (NoSuchAlgorithmException e) {
                                throw new IOException(e.getMessage());
                            }
                            catch (SecurityException e) {
                                return new IOException("Security manager prohibited read access to " + PolicyReader.this.keystoreFile.getAbsolutePath());
                            }
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
            }
        }
        return this.keystore;
    }

    public void read() throws IOException {
        if (this.policyString == null) {
            this.loadPolicy(this.policy);
            this.getKeyStore();
        }
        this.domains.clear();
        Matcher m = GRANT_PATTERN.matcher(this.policyString);
        while (m.find()) {
            String granteeString = m.group(1).trim();
            String permissionString = m.group(2).trim();
            ProtectionDomain domain = this.parseProtectionDomain(granteeString, permissionString);
            this.domains.add(domain);
        }
        if (this.exceptions.size() > 0) {
            System.err.println("The parser returned these errors:");
            for (Exception e : this.exceptions) {
                System.err.println(e.getMessage());
            }
        } else {
            this.validPolicy = true;
        }
    }

    public List getMessages() {
        return Collections.unmodifiableList(this.exceptions);
    }

    protected void addMessage(Exception e) {
        this.exceptions.add(e);
    }

    protected void loadPolicy(final File file) throws IOException {
        int ch;
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException, UnsupportedEncodingException {
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), PolicyReader.this.charset));
                        return in;
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new SecurityException("Could not open policy " + file.getAbsolutePath() + "; access was denied by the SecurityManager.");
        }
        if (reader == null) {
            throw new IOException("Could not open policy " + file.getAbsolutePath() + "; it does not exist.");
        }
        while ((ch = reader.read()) != -1) {
            contents.append((char)ch);
        }
        reader.close();
        Matcher matcher = COMMENTS_PATTERN.matcher(contents);
        String contentsNoComments = matcher.replaceAll(ONE_SPACE);
        matcher = LINEBREAKS_PATTERN.matcher(contentsNoComments);
        String contentsNoLineBreaks = matcher.replaceAll(ONE_SPACE);
        this.policyString = contentsNoLineBreaks.replaceAll(WHITESPACE, ONE_SPACE).trim();
    }

    protected ProtectionDomain parseProtectionDomain(String granteeString, String permissionString) {
        URL codeBaseUrl = null;
        Certificate[] signers = null;
        ArrayList<Principal> principalsList = new ArrayList<Principal>();
        String[] granteeStrings = granteeString.split(REGEX_COMMA_DELIMITER);
        for (int i = 0; i < granteeStrings.length; ++i) {
            Principal principal;
            String grantee = granteeStrings[i].trim();
            if (grantee.startsWith(TOKEN_CODEBASE)) {
                codeBaseUrl = this.extractCodeBaseUrl(grantee);
                continue;
            }
            if (grantee.startsWith(TOKEN_SIGNEDBY)) {
                signers = this.extractSigningCertificates(grantee);
                continue;
            }
            if (!grantee.startsWith(TOKEN_PRINCIPAL) || (principal = this.extractPrincipal(grantee)) == null) continue;
            principalsList.add(principal);
        }
        CodeSource codeSource = new CodeSource(codeBaseUrl, signers);
        Principal[] principals = principalsList.toArray(new Principal[principalsList.size()]);
        if (principals.length == 0) {
            principals = null;
        }
        PermissionCollection permissions = this.extractPermissionCollection(permissionString);
        permissions.setReadOnly();
        ClassLoader classLoader = PolicyReader.class.getClassLoader();
        ProtectionDomain pd = new ProtectionDomain(codeSource, permissions, classLoader, principals);
        return pd;
    }

    protected static boolean secureExists(final File file) throws SecurityException {
        try {
            Boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return file.exists();
                }
            });
            return exists;
        }
        catch (PrivilegedActionException e) {
            throw (SecurityException)e.getException();
        }
    }

    protected URL extractCodeBaseUrl(String token) {
        URL url = null;
        try {
            final String s = PolicyReader.extractTarget(token, TOKEN_CODEBASE);
            url = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL(s);
                }
            });
        }
        catch (PolicyException e) {
            this.addMessage(e);
        }
        catch (PrivilegedActionException e) {
            this.addMessage(e.getException());
        }
        return url;
    }

    protected Principal extractPrincipal(String token) {
        Principal principal = null;
        final String s = token.substring(TOKEN_PRINCIPAL.length()).trim();
        try {
            principal = (Principal)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AccessControlException, ClassNotFoundException {
                    return PolicyReader.this.tokenFactory.getPrincipal(s);
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.addMessage(e.getException());
        }
        return principal;
    }

    protected Certificate[] extractSigningCertificates(String token) {
        Certificate[] signers = null;
        if (this.keystoreFile == null) {
            this.addMessage(new PolicyException("A 'signedBy' entry exists, but no keystore was specified; ignoring."));
        } else {
            try {
                String signedBy = PolicyReader.extractTarget(token, TOKEN_SIGNEDBY);
                signers = this.getKeyStore().getCertificateChain(signedBy);
                if (signers == null) {
                    this.addMessage(new PolicyException("Certificate with alias '" + signedBy + "' not found in keystore " + this.keystoreFile));
                }
            }
            catch (Exception e) {
                this.addMessage(e);
            }
        }
        return signers;
    }

    protected PermissionCollection extractPermissionCollection(String permissions) {
        String[] p = permissions.split(REGEX_SEMICOLON_DELIMITER);
        Permissions permissionCollection = new Permissions();
        for (int j = 0; j < p.length; ++j) {
            String item = p[j].trim();
            if (!item.startsWith(TOKEN_PERMISSION)) continue;
            final String permissionString = item.substring(TOKEN_PERMISSION.length()).trim();
            Permission permission = null;
            try {
                permission = (Permission)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws AccessControlException, ClassNotFoundException {
                        return PolicyReader.this.tokenFactory.getPermission(permissionString);
                    }
                });
                try {
                    boolean isSigned;
                    boolean bl = isSigned = permissionString.indexOf(TOKEN_SIGNEDBY) != -1;
                    if (isSigned && permission != null && !this.isVerified(permission.getClass())) {
                        this.addMessage(new PolicyException("Could not verify permission class signature: " + permissionString));
                    }
                }
                catch (IOException e) {
                    this.addMessage(new PolicyException("Could not instantiate permission: " + permissionString));
                }
                ((PermissionCollection)permissionCollection).add(permission);
                continue;
            }
            catch (PrivilegedActionException e) {
                this.addMessage(e.getException());
            }
        }
        permissionCollection.setReadOnly();
        return permissionCollection;
    }

    public boolean isValid() {
        return this.validPolicy;
    }

    public boolean isVerified(Class clazz) throws IOException {
        Certificate cert = PolicyReader.getSigner(clazz);
        try {
            Enumeration<String> aliases = this.getKeyStore().aliases();
            while (aliases.hasMoreElements()) {
                Certificate keystoreCert;
                String alias = aliases.nextElement();
                if (!this.keystore.isKeyEntry(alias) || !cert.equals(keystoreCert = this.keystore.getCertificate(alias))) continue;
                return true;
            }
        }
        catch (KeyStoreException e) {
            throw new IOException(e.getMessage());
        }
        return false;
    }

    private static String extractTarget(String s, String startAfter) throws PolicyException {
        String s2;
        String string = s2 = startAfter == null ? s : s.substring(startAfter.length()).trim();
        if (s2.startsWith(DOUBLE_QUOTE) && s2.endsWith(DOUBLE_QUOTE) && s2.length() > 2) {
            return s2.substring(1, s2.length() - 1);
        }
        throw new PolicyException("Policy string \"" + s + "\" must be at least one character and surrounded by quotes.");
    }
}

