/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.pages.AbstractIndex;
import net.sourceforge.xhtmldoclet.pages.AllClasses;
import net.sourceforge.xhtmldoclet.pages.AllPackages;
import net.sourceforge.xhtmldoclet.pages.ClassSummary;
import net.sourceforge.xhtmldoclet.pages.ClassUse;
import net.sourceforge.xhtmldoclet.pages.ConstantValues;
import net.sourceforge.xhtmldoclet.pages.DeprecatedList;
import net.sourceforge.xhtmldoclet.pages.Frameset;
import net.sourceforge.xhtmldoclet.pages.Help;
import net.sourceforge.xhtmldoclet.pages.OverviewSummary;
import net.sourceforge.xhtmldoclet.pages.OverviewTree;
import net.sourceforge.xhtmldoclet.pages.PackageFrame;
import net.sourceforge.xhtmldoclet.pages.PackageList;
import net.sourceforge.xhtmldoclet.pages.PackageSummary;
import net.sourceforge.xhtmldoclet.pages.PackageTree;
import net.sourceforge.xhtmldoclet.pages.PackageUse;
import net.sourceforge.xhtmldoclet.pages.SerializedForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doclet
extends com.sun.javadoc.Doclet {
    private Config conf = Config.getInstance();
    public static final String DOCLET_VERSION = "0.4";
    public static final String DOCLET_REVISION = Config.getInstance().getDocletSpecificRevision();
    public static final String DOCLET_BUILD_DATE = Config.getInstance().getDocletSpecificBuildDate();
    public static final int BUFFER_SIZE = 1024;

    protected Doclet(RootDoc root) {
        this.conf.root = root;
        this.conf.setOptions();
        System.out.println(this.conf.propertyText("doclet.info", DOCLET_VERSION, DOCLET_REVISION, DOCLET_BUILD_DATE, Config.JAVA_VERSION));
        System.out.println("      http://xhtmldoclet.sourceforge.net/");
        this.conf.topFile = "overview-summary" + this.conf.ext;
    }

    public static boolean start(RootDoc root) {
        try {
            new Doclet(root).generateDocumentation();
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static DocletAbortException exception(Exception exc, String file) {
        Config.getInstance().standardmessage.error("doclet.exception_encountered", exc.toString(), file);
        return new DocletAbortException();
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        return Config.getInstance().optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return Config.getInstance().validOptions(options, reporter);
    }

    private void generateDocumentation() throws IOException {
        if (this.conf.root.classes().length == 0) {
            this.conf.message.error("No_Public_Classes_To_Document");
            return;
        }
        System.out.println(this.conf.propertyText("doclet.doc_root", this.conf.destDirName));
        this.conf.classTree = new ClassTree((Configuration)this.conf, this.conf.nodeprecated);
        this.conf.indexBuilder = new IndexBuilder((Configuration)this.conf, this.conf.nodeprecated);
        String string = this.conf.rootIndexPage = this.conf.splitindex ? "index-files" + File.separatorChar + "index-" + this.conf.indexBuilder.elements()[0] + this.conf.ext : "index-all" + this.conf.ext;
        if (this.conf.use) {
            System.out.println(this.conf.propertyText("doclet.mapping", new Object[0]));
            this.conf.classUseMapper = new ClassUseMapper(this.conf.root, this.conf.classTree);
        }
        if (!this.conf.stylesheetfile.equals("")) {
            this.copyFileToFile(this.conf.stylesheetfile, "stylesheet.css");
        } else {
            this.copyResourceFileToFile("resources", "core_styles.css", null, "stylesheet.css", false);
            if (!this.conf.plainindex) {
                this.copyResourceFileToFile("resources", "icon_styles.css", null, "stylesheet.css", true);
                System.out.println(this.conf.propertyText("doclet.images", new Object[0]));
                this.copyImageFilesToDestination();
            }
        }
        this.copyResourceFileToFile("images", "inherit.gif", "image-files", null, false);
        System.out.println(this.conf.propertyText("doclet.common", new Object[0]));
        PackageList.generatePackageList();
        Frameset.generateFrameset();
        if (this.conf.packages.length > 1) {
            AllPackages.generateAllPackages();
            OverviewSummary.generateOverviewSummary();
        }
        OverviewTree.generateOverviewTree();
        AllClasses.generateAllClasses();
        ConstantValues.generateConstantValues();
        SerializedForm.generateSerializedForm();
        DeprecatedList.generateDeprecatedList();
        AbstractIndex.generateIndex();
        Help.generateHelp();
        System.out.println(this.conf.propertyText("doclet.packages", new Object[0]));
        this.generatePackageFiles();
        System.out.println(this.conf.propertyText("doclet.classes", new Object[0]));
        this.generateClassFiles();
        if (this.conf.sourcepath != null && this.conf.sourcepath.length() > 0) {
            StringTokenizer pathTokens = new StringTokenizer(this.conf.sourcepath, String.valueOf(File.pathSeparatorChar));
            boolean first = true;
            while (pathTokens.hasMoreTokens()) {
                Util.copyDocFiles((Configuration)this.conf, (String)(pathTokens.nextToken() + File.separator), (String)"doc-files", (boolean)first);
                first = false;
            }
        }
        this.conf.tagletManager.printReport();
    }

    private void copyImageFilesToDestination() throws IOException {
        block4: {
            try {
                JarFile jarFile = this.conf.enclosingJarFile();
                if (jarFile == null) break block4;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String file = entry.getName();
                    if (!file.endsWith(".gif")) continue;
                    this.copyResourceFileToFile("images", file.substring(file.lastIndexOf("/") + 1), "image-files", null, false);
                }
            }
            catch (FileNotFoundException exc) {
                Class<?> c = ((Object)((Object)this)).getClass();
                String codePath = c.getProtectionDomain().getCodeSource().getLocation().getPath();
                String codePkg = c.getPackage().getName().replace(".", "/");
                File imagesDir = new File(codePath + codePkg + "/images/");
                if (imagesDir == null || imagesDir.listFiles() == null) break block4;
                for (File file : imagesDir.listFiles()) {
                    this.copyResourceFileToFile("images", file.getName(), "image-files", null, false);
                }
            }
        }
    }

    private void generatePackageFiles() {
        PackageDoc[] packages = this.conf.packages;
        PackageDoc prev = null;
        for (int i = 0; i < packages.length; ++i) {
            PackageDoc next;
            PackageDoc packageDoc = next = i + 1 < packages.length && packages[i + 1].name().length() > 0 ? packages[i + 1] : null;
            if (next == null && i + 2 < packages.length) {
                next = packages[i + 2];
            }
            PackageFrame.generatePackageFrame(packages[i]);
            PackageSummary.generatePackageSummary(packages[i], prev, next);
            if (this.conf.createtree) {
                PackageTree.generatePackageTree(packages[i], prev, next);
            }
            if (this.conf.use) {
                PackageUse.generatePackageUse(packages[i], prev, next);
            }
            prev = packages[i];
        }
    }

    private void generateClassFiles() {
        for (String string : this.conf.classDocCatalog.packageNames()) {
            this.generateClassFiles(Arrays.asList(this.conf.classDocCatalog.allClasses(string)));
        }
        for (String string : this.conf.root.specifiedPackages()) {
            this.generateClassFiles(Arrays.asList(string.allClasses()));
        }
    }

    private void generateClassFiles(List<ClassDoc> classList) {
        ClassDoc next;
        if (classList.size() == 0) {
            return;
        }
        Collections.sort(classList);
        Iterator<ClassDoc> classes = classList.iterator();
        ClassDoc prev = null;
        ClassDoc curr = classes.next();
        while (curr != null) {
            next = classes.hasNext() ? classes.next() : null;
            ClassSummary.generateClassSummary(curr, prev, next);
            prev = curr;
            curr = next;
        }
        if (!this.conf.use) {
            return;
        }
        classes = classList.iterator();
        prev = null;
        curr = classes.next();
        while (curr != null) {
            next = classes.hasNext() ? classes.next() : null;
            ClassUse.generateClassUse(curr, prev, next);
            prev = curr;
            curr = next;
        }
    }

    private void copyResourceFileToFile(String srcPath, String srcFile, String dstPath, String dstFile, boolean append) throws IOException {
        if (dstFile == null) {
            dstFile = srcFile;
        }
        String destDir = this.conf.destDirName + (dstPath != null ? dstPath : "");
        DirectoryManager.createDirectory((Configuration)this.conf, (String)destDir);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(srcPath + File.separatorChar + srcFile);
        if (stream != null) {
            int len;
            InputStreamReader in = new InputStreamReader(stream);
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(destDir, dstFile), append));
            char[] buf = new char[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            stream.close();
            out.close();
        }
    }

    private void copyFileToFile(String src, String dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(new File(src));
        FileOutputStream out = new FileOutputStream(new File(this.conf.destDirName, dst));
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

