/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import java.io.IOException;
import net.sourceforge.xhtmldoclet.Doclet;
import net.sourceforge.xhtmldoclet.pages.AbstractTree;

public final class PackageTree
extends AbstractTree {
    private PackageDoc prev;
    private PackageDoc next;
    private String pkgName;

    public static void generatePackageTree(PackageDoc pkg, PackageDoc prev, PackageDoc next) {
        String filename = "package-tree" + PackageTree.CONF.ext;
        String pathToFile = DirectoryManager.getDirectoryPath((PackageDoc)pkg);
        try {
            new PackageTree(filename, pathToFile, pkg, prev, next);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, pathToFile + SLASH + filename);
        }
    }

    private PackageTree(String filename, String pathToFile, PackageDoc pkg, PackageDoc prev, PackageDoc next) throws IOException {
        super(filename, pathToFile);
        PackageTree.CONF.classTree = new ClassTree(PackageTree.CONF.classDocCatalog.allClasses(pkg), (Configuration)CONF);
        this.pageType = "PACKAGE_TREE";
        PackageTree.CONF.currentPkg = pkg;
        this.pkgName = pkg.name();
        this.prev = prev;
        this.next = next;
        this.windowTitle = PackageTree.CONF.windowtitle.length() > 0 ? PackageTree.CONF.windowtitle : pkg.name() + " " + CONF.propertyText("Tree", new Object[0]);
        this.printXhtmlHeader();
        this.printEntityCaption((Doc)pkg, "Hierarchy for Package");
        if (!(this.packages.length == 1 && this.packages[0].name().length() <= 0 || this.classesOnly)) {
            this.println(this.openDivWithID("Overview"));
            this.println(this.open("dl"));
            this.println(this.open("dt") + CONF.propertyText("Package_Hierarchies", new Object[0]) + this.close("dt"));
            this.println(this.open("dd") + this.listItem(this.linkToLabelHref("All Packages", this.pathToDocRoot + "overview-tree" + PackageTree.CONF.ext)) + this.close("dd"));
            this.println(this.close("dl"));
            this.println(this.close("div") + this.getComment("#Overview"));
        }
        this.printMemberSubgroups();
        this.printXhtmlFooter();
        this.close();
    }

    protected void navLinkPackage() {
        this.println(this.listItem(this.linkToLabelHrefTitle(PACKAGE, "package-summary" + PackageTree.CONF.ext, CONF.propertyText("navtitle.Package", this.pkgName))));
    }

    protected void navLinkUse() {
        this.println(this.listItem(this.linkToLabelHrefTitle(USE, "package-use" + PackageTree.CONF.ext, CONF.propertyText("navtitle.Use", this.pkgName))));
    }

    protected void navPreviousNext() {
        this.println(this.openULWithID("PreviousNext"));
        this.println(this.listItem(this.linkToLabelHref(PREV_PKG, this.hrefToDoc((Doc)this.prev) + "package-tree" + PackageTree.CONF.ext)) + this.listItemLast(this.linkToLabelHref(NEXT_PKG, this.hrefToDoc((Doc)this.next) + "package-tree" + PackageTree.CONF.ext)));
        this.println(this.close("ul"));
    }
}

