/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.util.Arrays;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class SerializedForm
extends AbstractPageWriter {
    private PackageDoc currentPackage;

    public static void generateSerializedForm() {
        String filename = "serialized-form" + SerializedForm.CONF.ext;
        try {
            new SerializedForm(filename);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private SerializedForm(String filename) throws IOException {
        super(filename);
        this.pageType = "SERIALIZED";
        this.windowTitle = SerializedForm.CONF.windowtitle.length() > 0 ? SerializedForm.CONF.windowtitle : CONF.propertyText("Serialized_Form", new Object[0]);
        this.printXhtmlHeader();
        this.println(this.open("h1") + CONF.propertyText("Serialized_Form", new Object[0]) + this.close("h1"));
        PackageDoc[] arr$ = SerializedForm.CONF.root.specifiedPackages();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            PackageDoc pkg;
            this.currentPackage = pkg = arr$[i$];
            this.buildPackageSerializedForm();
        }
        this.printXhtmlFooter();
        this.close();
    }

    private void buildPackageSerializedForm() {
        Object[] classes = this.currentPackage.allClasses(false);
        if (classes == null || classes.length == 0 || !SerializedForm.serialInclude((Doc)this.currentPackage) || !SerializedForm.serialClassFoundToDocument((ClassDoc[])classes)) {
            return;
        }
        this.println(this.open("h2") + CONF.propertyText("Package", new Object[0]) + " " + this.linkToLabelHref(this.currentPackage.name(), this.hrefToDoc((Doc)this.currentPackage) + "package-summary" + SerializedForm.CONF.ext) + this.close("h2"));
        Arrays.sort(classes);
        for (Object currentClass : classes) {
            MethodDoc[] methods;
            if (!SerializedForm.serialInclude((Doc)currentClass)) continue;
            String classHref = this.hrefToDoc((Doc)currentClass);
            String classLink = this.linkToLabelHrefTargetTitle(currentClass.name(), classHref, null, this.classFlavor((ClassDoc)currentClass, false) + " in package " + currentClass.containingPackage());
            this.print(this.open("h3") + classLink);
            ClassDoc superclass = currentClass.superclass();
            if (superclass != null) {
                this.print(" extends " + this.linkToLabelHrefTargetTitle(superclass.name(), this.hrefToDoc((Doc)superclass), null, this.classFlavor(superclass, false) + " in package " + superclass.containingPackage()));
            }
            this.println(this.close("h3"));
            String serialVersionUID = this.getSerialVersionUID((ClassDoc)currentClass);
            if (serialVersionUID != null) {
                this.println(this.open("p") + "<code>static final long <strong>serialVersionUID</strong></code>: " + serialVersionUID + this.close("p"));
            }
            if ((methods = currentClass.serializationMethods()).length > 0) {
                this.println(this.open("h4") + CONF.propertyText("Serialization_Methods", new Object[0]) + this.close("h4"));
            }
            for (MethodDoc method : methods) {
                this.println(this.open("p") + method + this.close("p"));
            }
            FieldDoc[] fields = currentClass.serializableFields();
            if (fields.length <= 0) continue;
            this.println(this.open("h4") + CONF.propertyText("Serialized_Fields", new Object[0]) + this.close("h4"));
            this.println(this.open("dl"));
            for (FieldDoc field : fields) {
                String typeLink = field.type().typeName();
                if (!field.type().isPrimitive()) {
                    typeLink = this.linkToLabelHref(typeLink, this.hrefToDoc((Doc)field.type().asClassDoc()));
                }
                String fieldName = field.name();
                this.printDT(typeLink + " " + this.open("strong") + this.linkToLabelHref(fieldName, classHref + "#" + fieldName) + this.close("strong"));
                this.printDD(this.getCommentSummary((Doc)field));
            }
            this.println(this.close("dl"));
        }
    }

    private String getSerialVersionUID(ClassDoc currentClass) {
        FieldDoc[] fields = currentClass.fields(false);
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].name().equals("serialVersionUID") || fields[i].constantValueExpression() == null) continue;
            return fields[i].constantValueExpression();
        }
        return null;
    }

    private static boolean serialInclude(Doc doc) {
        if (doc == null) {
            return false;
        }
        return doc.isClass() ? SerializedForm.serialClassInclude((ClassDoc)doc) : SerializedForm.serialDocInclude(doc);
    }

    private static boolean serialClassFoundToDocument(ClassDoc[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (!SerializedForm.serialClassInclude(classes[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean serialClassInclude(ClassDoc cd) {
        if (!cd.isEnum() && cd.superclass() != null && cd.isSerializable()) {
            if (cd.tags("serial").length > 0) {
                return SerializedForm.serialDocInclude((Doc)cd);
            }
            if (cd.isPublic() || cd.isProtected()) {
                return true;
            }
        }
        return false;
    }

    private static boolean serialDocInclude(Doc doc) {
        String serialtext;
        if (doc.isEnum()) {
            return false;
        }
        Tag[] serial = doc.tags("serial");
        return serial.length <= 0 || (serialtext = serial[0].text().toLowerCase()).indexOf("exclude") < 0;
    }
}

