/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.writers;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.markup.HtmlDocWriter;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.doclets.internal.toolkit.ClassWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.taglets.DocRootTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletManager;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletOutput;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.SourceToHTMLConverter;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.writers.ClassWriterImpl;
import net.sourceforge.xhtmldoclet.writers.LinkFactoryImpl;
import net.sourceforge.xhtmldoclet.writers.LinkInfoImpl;
import net.sourceforge.xhtmldoclet.writers.LinkOutputImpl;
import net.sourceforge.xhtmldoclet.writers.MethodWriterImpl;
import net.sourceforge.xhtmldoclet.writers.TagletOutputImpl;
import net.sourceforge.xhtmldoclet.writers.TagletWriterImpl;

public class HtmlDocletWriter
extends HtmlDocWriter {
    public String relativePath = "";
    public String relativepathNoSlash = "";
    public String path = "";
    public String filename = "";
    public int displayLength = 0;
    public Config configuration;

    public HtmlDocletWriter(Config configuration, String filename) throws IOException {
        super((Configuration)configuration, filename);
        this.configuration = configuration;
        this.filename = filename;
    }

    public HtmlDocletWriter(Config configuration, String path, String filename, String relativePath) throws IOException {
        super((Configuration)configuration, path, filename);
        this.configuration = configuration;
        this.path = path;
        this.relativePath = relativePath;
        this.relativepathNoSlash = DirectoryManager.getPathNoTrailingSlash((String)this.relativePath);
        this.filename = filename;
    }

    public String replaceDocRootDir(String htmlstr) {
        int index = htmlstr.indexOf("{@");
        if (index < 0) {
            return htmlstr;
        }
        String lowerHtml = htmlstr.toLowerCase();
        index = lowerHtml.indexOf("{@docroot}", index);
        if (index < 0) {
            return htmlstr;
        }
        StringBuffer buf = new StringBuffer();
        int previndex = 0;
        while (true) {
            if ((index = lowerHtml.indexOf("{@docroot}", previndex)) < 0) break;
            buf.append(htmlstr.substring(previndex, index));
            previndex = index + 10;
            buf.append(this.relativepathNoSlash);
            if (this.relativepathNoSlash.length() <= 0 || previndex >= htmlstr.length() || htmlstr.charAt(previndex) == '/') continue;
            buf.append("/");
        }
        buf.append(htmlstr.substring(previndex));
        return buf.toString();
    }

    public void printNoFramesTargetHyperLink(String link, String where, String target, String label, boolean bold) {
    }

    private void printMethodInfo(MethodDoc method) {
        ClassDoc[] intfacs = method.containingClass().interfaces();
        MethodDoc overriddenMethod = method.overriddenMethod();
        if (intfacs.length > 0 || overriddenMethod != null) {
            this.printTagsInfoHeader();
            MethodWriterImpl.printImplementsInfo(this, method);
            if (overriddenMethod != null) {
                MethodWriterImpl.printOverridden(this, method.overriddenType(), overriddenMethod);
            }
            this.printTagsInfoFooter();
        }
        this.dd();
    }

    protected void printTags(Doc doc) {
        if (this.configuration.nocomment) {
            return;
        }
        if (doc instanceof MethodDoc) {
            this.printMethodInfo((MethodDoc)doc);
        }
        TagletOutputImpl output = new TagletOutputImpl("");
        TagletWriter.genTagOuput((TagletManager)this.configuration.tagletManager, (Doc)doc, (Taglet[])this.configuration.tagletManager.getCustomTags(doc), (TagletWriter)this.getTagletWriterInstance(false), (TagletOutput)output);
        if (output.toString().trim().length() > 0) {
            this.printTagsInfoHeader();
            this.print(output.toString());
            this.printTagsInfoFooter();
        } else if (!(doc instanceof ConstructorDoc || doc instanceof RootDoc || doc instanceof ClassDoc)) {
            this.printTagsInfoHeader();
            this.printTagsInfoFooter();
        }
    }

    public TagletWriter getTagletWriterInstance(boolean isFirstSentence) {
        return new TagletWriterImpl(this, isFirstSentence);
    }

    protected void printTagsInfoHeader() {
    }

    protected void printTagsInfoFooter() {
    }

    public void printTargetPackageLink(PackageDoc pd, String target, String label) {
        this.print(this.getHyperLink(this.pathString(pd, "package-summary.html"), "", label, false, "", "", target));
    }

    public void printHtmlHeader(String title, String[] metakeywords, boolean includeScript) {
        this.body("white", includeScript);
    }

    public void printUserHeaderFooter(boolean header) {
        if (header) {
            this.print(this.replaceDocRootDir(this.configuration.header));
        } else if (this.configuration.footer.length() != 0) {
            this.print(this.replaceDocRootDir(this.configuration.footer));
        } else {
            this.print(this.replaceDocRootDir(this.configuration.header));
        }
    }

    public void printBottom() {
        this.print(this.replaceDocRootDir(this.configuration.bottom));
    }

    protected void navLinks(boolean header) {
    }

    protected void navLinkNext() {
    }

    protected void navLinkPrevious() {
    }

    protected void printSummaryDetailLinks() {
    }

    protected void navLinkContents() {
        this.navCellStart();
        this.printHyperLink(this.relativePath + "overview-summary.html", "", this.configuration.getText("doclet.Overview"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navCellStart() {
        this.print("  ");
        this.tdBgcolorStyle("#EEEEFF", "NavBarCell1");
        this.print("    ");
    }

    protected void navCellRevStart() {
        this.print("  ");
        this.tdBgcolorStyle("#FFFFFF", "NavBarCell1Rev");
        this.print(" ");
        this.space();
    }

    protected void navCellEnd() {
        this.space();
        this.tdEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        PackageDoc[] packages = this.configuration.root.specifiedPackages();
        if (packages.length == 1 && this.configuration.root.specifiedClasses().length == 0) {
            this.printHyperLink(this.pathString(packages[0], "package-tree.html"), "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink(this.relativePath + "overview-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }

    protected void navLinkHelp() {
        String helpfilenm = this.configuration.helpfile;
        if (helpfilenm.equals("")) {
            helpfilenm = "help-doc.html";
        } else {
            int lastsep = helpfilenm.lastIndexOf(File.separatorChar);
            if (lastsep != -1) {
                helpfilenm = helpfilenm.substring(lastsep + 1);
            }
        }
        this.navCellStart();
        this.printHyperLink(this.relativePath + helpfilenm, "", this.configuration.getText("doclet.Help"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navDetail() {
        this.printText("doclet.Detail");
    }

    protected void navSummary() {
        this.printText("doclet.Summary");
    }

    public void tableIndexSummary() {
        this.table(1, "100%", 3, 0);
    }

    public void tableIndexDetail() {
        this.table(1, "100%", 3, 0);
    }

    public void tdIndex() {
        this.print("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\">");
    }

    public void tableHeaderStart(String color, int span) {
        this.trBgcolorStyle(color, "TableHeadingColor");
        this.thAlignColspan("left", span);
        this.font("+2");
    }

    public void tableInheritedHeaderStart(String color) {
        this.trBgcolorStyle(color, "TableSubHeadingColor");
        this.thAlign("left");
    }

    public void tableUseInfoHeaderStart(String color) {
        this.trBgcolorStyle(color, "TableSubHeadingColor");
        this.thAlignColspan("left", 2);
    }

    public void tableHeaderStart(String color) {
        this.tableHeaderStart(color, 2);
    }

    public void tableHeaderStart(int span) {
        this.tableHeaderStart("#CCCCFF", span);
    }

    public void tableHeaderStart() {
        this.tableHeaderStart(2);
    }

    public void tableHeaderEnd() {
        this.fontEnd();
        this.thEnd();
        this.trEnd();
    }

    public void tableInheritedHeaderEnd() {
        this.thEnd();
        this.trEnd();
    }

    public void summaryRow(int width) {
        if (width != 0) {
            this.tdWidth(width + "%");
        } else {
            this.td();
        }
    }

    public void summaryRowEnd() {
        this.tdEnd();
    }

    public void printIndexHeading(String str) {
        this.h2();
        this.print(str);
        this.h2End();
    }

    public void frameSet(String arg) {
        this.println("<FRAMESET " + arg + ">");
    }

    public void frameSetEnd() {
        this.println("</FRAMESET>");
    }

    public void frame(String arg) {
        this.println("<FRAME " + arg + ">");
    }

    public void frameEnd() {
        this.println("</FRAME>");
    }

    protected String pathToClass(ClassDoc cd) {
        return this.pathString(cd.containingPackage(), cd.name() + ".html");
    }

    protected String pathString(ClassDoc cd, String name) {
        return this.pathString(cd.containingPackage(), name);
    }

    protected String pathString(PackageDoc pd, String name) {
        StringBuffer buf = new StringBuffer(this.relativePath);
        buf.append(DirectoryManager.getPathToPackage((PackageDoc)pd, (String)name));
        return buf.toString();
    }

    public void printPackageLink(PackageDoc pkg, String label, boolean isBold) {
        this.print(this.getPackageLink(pkg, label, isBold));
    }

    public void printPackageLink(PackageDoc pkg, String label, boolean isBold, String style) {
        this.print(this.getPackageLink(pkg, label, isBold, style));
    }

    public String getPackageLink(PackageDoc pkg, String label, boolean isBold) {
        return this.getPackageLink(pkg, label, isBold, "");
    }

    public String getPackageLink(PackageDoc pkg, String label, boolean isBold, String style) {
        boolean included;
        boolean bl = included = pkg != null && pkg.isIncluded();
        if (!included) {
            PackageDoc[] packages = this.configuration.packages;
            for (int i = 0; i < packages.length; ++i) {
                if (!packages[i].equals(pkg)) continue;
                included = true;
                break;
            }
        }
        if (included || pkg == null) {
            return this.getHyperLink(this.pathString(pkg, "package-summary.html"), "", label, isBold, style);
        }
        String crossPkgLink = this.getCrossPackageLink(Util.getPackageName((PackageDoc)pkg));
        if (crossPkgLink != null) {
            return this.getHyperLink(crossPkgLink, "", label, isBold, style);
        }
        return label;
    }

    public String italicsClassName(ClassDoc cd, boolean qual) {
        String name = qual ? cd.qualifiedName() : cd.name();
        return cd.isInterface() ? this.italicsText(name) : name;
    }

    public void printSrcLink(ProgramElementDoc d, String label) {
        if (d == null) {
            return;
        }
        ClassDoc cd = d.containingClass();
        if (cd == null) {
            cd = (ClassDoc)d;
        }
        String href = this.relativePath + "src-html/" + DirectoryManager.getDirectoryPath((PackageDoc)cd.containingPackage()) + cd.name() + ".html#" + SourceToHTMLConverter.getAnchorName((Doc)d);
        this.printHyperLink(href, "", label, true);
    }

    public String getLink(LinkInfoImpl linkInfo) {
        LinkFactoryImpl factory = new LinkFactoryImpl(this);
        String link = ((LinkOutputImpl)factory.getLinkOutput(linkInfo)).toString();
        this.displayLength += linkInfo.displayLength;
        return link;
    }

    public String getTypeParameterLinks(LinkInfoImpl linkInfo) {
        LinkFactoryImpl factory = new LinkFactoryImpl(this);
        return ((LinkOutputImpl)factory.getTypeParameterLinks(linkInfo, false)).toString();
    }

    public void printLink(LinkInfoImpl linkInfo) {
        this.print(this.getLink(linkInfo));
    }

    public String getCrossClassLink(String qualifiedClassName, String refMemName, String label, boolean bold, String style, boolean code) {
        int periodIndex;
        String packageName;
        String className = "";
        String string = packageName = qualifiedClassName == null ? "" : qualifiedClassName;
        while ((periodIndex = packageName.lastIndexOf(46)) != -1) {
            String defaultLabel;
            className = packageName.substring(periodIndex + 1, packageName.length()) + (className.length() > 0 ? "." + className : "");
            String string2 = defaultLabel = code ? this.getCode() + className + this.getCodeEnd() : className;
            if (this.getCrossPackageLink(packageName = packageName.substring(0, periodIndex)) == null) continue;
            return this.getHyperLink(this.configuration.extern.getExternalLink(packageName, this.relativePath, className + ".html"), refMemName == null ? "" : refMemName, label == null || label.length() == 0 ? defaultLabel : label, bold, style, this.configuration.getText("doclet.Href_Title_Class_Or_Interface", packageName), "");
        }
        return null;
    }

    public boolean isClassLinkable(ClassDoc cd) {
        if (cd.isIncluded()) {
            return this.configuration.isGeneratedDoc((Doc)cd);
        }
        return this.configuration.extern.isExternal((ProgramElementDoc)cd);
    }

    public String getCrossPackageLink(String pkgName) {
        return this.configuration.extern.getExternalLink(pkgName, this.relativePath, "package-summary.html");
    }

    public void printQualifiedClassLink(int context, ClassDoc cd) {
        this.printLink(new LinkInfoImpl(context, cd, this.configuration.getClassName(cd), ""));
    }

    public void printPreQualifiedClassLink(int context, ClassDoc cd) {
        this.print(this.getPreQualifiedClassLink(context, cd, false));
    }

    public String getPreQualifiedClassLink(int context, ClassDoc cd, boolean isBold) {
        String classlink = "";
        PackageDoc pd = cd.containingPackage();
        if (pd != null && !this.configuration.shouldExcludeQualifier(pd.name())) {
            classlink = this.getPkgName(cd);
        }
        classlink = classlink + this.getLink(new LinkInfoImpl(context, cd, cd.name(), isBold));
        return classlink;
    }

    public void printPreQualifiedBoldClassLink(int context, ClassDoc cd) {
        this.print(this.getPreQualifiedClassLink(context, cd, true));
    }

    public void printText(String key) {
        this.print(this.configuration.getText(key));
    }

    public void printText(String key, String a1) {
        this.print(this.configuration.getText(key, a1));
    }

    public void printText(String key, String a1, String a2) {
        this.print(this.configuration.getText(key, a1, a2));
    }

    public void boldText(String key) {
        this.bold(this.configuration.getText(key));
    }

    public void boldText(String key, String a1) {
        this.bold(this.configuration.getText(key, a1));
    }

    public void boldText(String key, String a1, String a2) {
        this.bold(this.configuration.getText(key, a1, a2));
    }

    public void printDocLink(int context, MemberDoc doc, String label, boolean bold) {
        this.print(this.getDocLink(context, doc, label, bold));
    }

    public void printDocLink(int context, ClassDoc classDoc, MemberDoc doc, String label, boolean bold) {
        this.print(this.getDocLink(context, classDoc, doc, label, bold));
    }

    public String getDocLink(int context, MemberDoc doc, String label, boolean bold) {
        return this.getDocLink(context, doc.containingClass(), doc, label, bold);
    }

    public String getDocLink(int context, ClassDoc classDoc, MemberDoc doc, String label, boolean bold) {
        if (!doc.isIncluded() && !Util.isLinkable((ClassDoc)classDoc, (Configuration)this.configuration())) {
            return label;
        }
        if (doc instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc emd = (ExecutableMemberDoc)doc;
            return this.getLink(new LinkInfoImpl(context, classDoc, this.getAnchor(emd), label, bold));
        }
        if (doc instanceof MemberDoc) {
            return this.getLink(new LinkInfoImpl(context, classDoc, doc.name(), label, bold));
        }
        return label;
    }

    public void anchor(ExecutableMemberDoc emd) {
        this.anchor(this.getAnchor(emd));
    }

    public String getAnchor(ExecutableMemberDoc emd) {
        StringBuilder signature = new StringBuilder(emd.signature());
        StringBuilder signatureParsed = new StringBuilder();
        int counter = 0;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '<') {
                ++counter;
                continue;
            }
            if (c == '>') {
                --counter;
                continue;
            }
            if (counter != 0) continue;
            signatureParsed.append(c);
        }
        return emd.name() + signatureParsed.toString();
    }

    public String seeTagToString(SeeTag see) {
        String tagName = see.name();
        if (!tagName.startsWith("@link") && !tagName.equals("@see")) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        boolean isplaintext = tagName.toLowerCase().equals("@linkplain");
        String label = see.label();
        label = label.length() > 0 ? (isplaintext ? label : this.getCode() + label + this.getCodeEnd()) : "";
        String seetext = this.replaceDocRootDir(see.text());
        if (seetext.startsWith("<") || seetext.startsWith("\"")) {
            result.append(seetext);
            return result.toString();
        }
        String text = isplaintext ? seetext : this.getCode() + seetext + this.getCodeEnd();
        ClassDoc refClass = see.referencedClass();
        String refClassName = see.referencedClassName();
        MemberDoc refMem = see.referencedMember();
        String refMemName = see.referencedMemberName();
        if (refClass == null) {
            PackageDoc refPackage = see.referencedPackage();
            if (refPackage != null && refPackage.isIncluded()) {
                String packageName = isplaintext ? refPackage.name() : this.getCode() + refPackage.name() + this.getCodeEnd();
                result.append(this.getPackageLink(refPackage, label.length() == 0 ? packageName : label, false));
            } else {
                String packageCrossLink = this.getCrossPackageLink(refClassName);
                if (packageCrossLink != null) {
                    result.append(this.getHyperLink(packageCrossLink, "", label.length() == 0 ? text : label, false));
                } else {
                    String classCrossLink = this.getCrossClassLink(refClassName, refMemName, label, false, "", !isplaintext);
                    if (classCrossLink != null) {
                        result.append(classCrossLink);
                    } else {
                        result.append(label.length() == 0 ? text : label);
                    }
                }
            }
        } else if (refMemName == null) {
            if (label.length() == 0) {
                label = isplaintext ? refClass.name() : this.getCode() + refClass.name() + this.getCodeEnd();
                result.append(this.getLink(new LinkInfoImpl(refClass, label)));
            } else {
                result.append(this.getLink(new LinkInfoImpl(refClass, label)));
            }
        } else if (refMem == null) {
            result.append(label.length() == 0 ? text : label);
        } else {
            ClassDoc containing = refMem.containingClass();
            if (see.text().trim().startsWith("#") && !containing.isPublic() && !Util.isLinkable((ClassDoc)containing, (Configuration)this.configuration())) {
                containing = ((ClassWriterImpl)this).getClassDoc();
            }
            if (this.configuration.currentClass != containing) {
                refMemName = containing.name() + "." + refMemName;
            }
            if (refMem instanceof ExecutableMemberDoc && refMemName.indexOf(40) < 0) {
                refMemName = refMemName + ((ExecutableMemberDoc)refMem).signature();
            }
            text = isplaintext ? refMemName : this.getCode() + refMemName + this.getCodeEnd();
            result.append(this.getDocLink(10, containing, refMem, label.length() == 0 ? text : label, false));
        }
        return result.toString();
    }

    public void printInlineComment(Doc doc, Tag tag) {
        this.printCommentTags(doc, tag.inlineTags(), false, false);
    }

    public void printInlineDeprecatedComment(Doc doc, Tag tag) {
        this.printCommentTags(doc, tag.inlineTags(), true, false);
    }

    public void printSummaryComment(Doc doc) {
        this.printSummaryComment(doc, doc.firstSentenceTags());
    }

    public void printSummaryComment(Doc doc, Tag[] firstSentenceTags) {
        this.printCommentTags(doc, firstSentenceTags, false, true);
    }

    public void printSummaryDeprecatedComment(Doc doc) {
        this.printCommentTags(doc, doc.firstSentenceTags(), true, true);
    }

    public void printSummaryDeprecatedComment(Doc doc, Tag tag) {
        this.printCommentTags(doc, tag.firstSentenceTags(), true, true);
    }

    public void printInlineComment(Doc doc) {
        this.printCommentTags(doc, doc.inlineTags(), false, false);
        this.p();
    }

    public void printInlineDeprecatedComment(Doc doc) {
        this.printCommentTags(doc, doc.inlineTags(), true, false);
    }

    private void printCommentTags(Doc doc, Tag[] tags, boolean depr, boolean first) {
        if (this.configuration.nocomment) {
            return;
        }
        if (depr) {
            this.italic();
        }
        String result = this.commentTagsToString(null, doc, tags, first);
        this.print(result);
        if (depr) {
            this.italicEnd();
        }
        if (tags.length == 0) {
            this.space();
        }
    }

    public String commentTagsToString(Tag holderTag, Doc doc, Tag[] tags, boolean isFirstSentence) {
        StringBuffer result = new StringBuffer();
        this.configuration.tagletManager.checkTags(doc, tags, true);
        for (int i = 0; i < tags.length; ++i) {
            Tag tagelem = tags[i];
            String tagName = tagelem.name();
            if (tagelem instanceof SeeTag) {
                result.append(this.seeTagToString((SeeTag)tagelem));
                continue;
            }
            if (!tagName.equals("Text")) {
                TagletOutput output = TagletWriter.getInlineTagOuput((TagletManager)this.configuration.tagletManager, (Tag)holderTag, (Tag)tagelem, (TagletWriter)this.getTagletWriterInstance(isFirstSentence));
                result.append(output == null ? "" : output.toString());
                continue;
            }
            String text = this.redirectRelativeLinks(tagelem.holder(), tagelem.text());
            text = this.replaceDocRootDir(text);
            if (isFirstSentence) {
                text = this.removeNonInlineHtmlTags(text);
            }
            StringTokenizer lines = new StringTokenizer(text, "\r\n", true);
            StringBuffer textBuff = new StringBuffer();
            while (lines.hasMoreTokens()) {
                StringBuffer line = new StringBuffer(lines.nextToken());
                Util.replaceTabs((int)this.configuration.sourcetab, (StringBuffer)line);
                textBuff.append(line.toString());
            }
            result.append(textBuff);
        }
        return result.toString();
    }

    private boolean shouldNotRedirectRelativeLinks() {
        return this instanceof AnnotationTypeWriter || this instanceof ClassWriter || this instanceof PackageSummaryWriter;
    }

    private String redirectRelativeLinks(Doc doc, String text) {
        int begin;
        String redirectPathFromRoot;
        if (doc == null || this.shouldNotRedirectRelativeLinks()) {
            return text;
        }
        if (doc instanceof ClassDoc) {
            redirectPathFromRoot = DirectoryManager.getDirectoryPath((PackageDoc)((ClassDoc)doc).containingPackage());
        } else if (doc instanceof MemberDoc) {
            redirectPathFromRoot = DirectoryManager.getDirectoryPath((PackageDoc)((MemberDoc)doc).containingPackage());
        } else if (doc instanceof PackageDoc) {
            redirectPathFromRoot = DirectoryManager.getDirectoryPath((PackageDoc)((PackageDoc)doc));
        } else {
            return text;
        }
        if (!redirectPathFromRoot.endsWith("/")) {
            redirectPathFromRoot = redirectPathFromRoot + "/";
        }
        if ((begin = text.toLowerCase().indexOf("<a")) >= 0) {
            StringBuffer textBuff = new StringBuffer(text);
            while (begin >= 0) {
                String relativeLink;
                begin = textBuff.indexOf("=", begin) + 1;
                int end = textBuff.indexOf(">", begin + 1);
                if (begin == 0) {
                    this.configuration.getDocletSpecificMsg().warning(doc.position(), "doclet.malformed_html_link_tag", text);
                    break;
                }
                if (end == -1) break;
                if (textBuff.substring(begin, end).indexOf("\"") != -1) {
                    begin = textBuff.indexOf("\"", begin) + 1;
                    end = textBuff.indexOf("\"", begin + 1);
                    if (begin == 0 || end == -1) break;
                }
                if (!((relativeLink = textBuff.substring(begin, end)).toLowerCase().startsWith("mailto:") || relativeLink.toLowerCase().startsWith("http:") || relativeLink.toLowerCase().startsWith("https:") || relativeLink.toLowerCase().startsWith("file:"))) {
                    relativeLink = "{@" + new DocRootTaglet().getName() + "}" + redirectPathFromRoot + relativeLink;
                    textBuff.replace(begin, end, relativeLink);
                }
                begin = textBuff.toString().toLowerCase().indexOf("<a", begin + 1);
            }
            return textBuff.toString();
        }
        return text;
    }

    public String removeNonInlineHtmlTags(String text) {
        if (text.indexOf(60) < 0) {
            return text;
        }
        String[] noninlinetags = new String[]{"<ul>", "</ul>", "<ol>", "</ol>", "<dl>", "</dl>", "<table>", "</table>", "<tr>", "</tr>", "<td>", "</td>", "<th>", "</th>", "<p>", "</p>", "<li>", "</li>", "<dd>", "</dd>", "<dir>", "</dir>", "<dt>", "</dt>", "<h1>", "</h1>", "<h2>", "</h2>", "<h3>", "</h3>", "<h4>", "</h4>", "<h5>", "</h5>", "<h6>", "</h6>", "<pre>", "</pre>", "<menu>", "</menu>", "<listing>", "</listing>", "<hr>", "<blockquote>", "</blockquote>", "<center>", "</center>", "<UL>", "</UL>", "<OL>", "</OL>", "<DL>", "</DL>", "<TABLE>", "</TABLE>", "<TR>", "</TR>", "<TD>", "</TD>", "<TH>", "</TH>", "<P>", "</P>", "<LI>", "</LI>", "<DD>", "</DD>", "<DIR>", "</DIR>", "<DT>", "</DT>", "<H1>", "</H1>", "<H2>", "</H2>", "<H3>", "</H3>", "<H4>", "</H4>", "<H5>", "</H5>", "<H6>", "</H6>", "<PRE>", "</PRE>", "<MENU>", "</MENU>", "<LISTING>", "</LISTING>", "<HR>", "<BLOCKQUOTE>", "</BLOCKQUOTE>", "<CENTER>", "</CENTER>"};
        for (int i = 0; i < noninlinetags.length; ++i) {
            text = this.replace(text, noninlinetags[i], "");
        }
        return text;
    }

    public String replace(String text, String tobe, String by) {
        int startindex;
        while ((startindex = text.indexOf(tobe)) >= 0) {
            int endindex = startindex + tobe.length();
            StringBuffer replaced = new StringBuffer();
            if (startindex > 0) {
                replaced.append(text.substring(0, startindex));
            }
            replaced.append(by);
            if (text.length() > endindex) {
                replaced.append(text.substring(endindex));
            }
            text = replaced.toString();
        }
        return text;
    }

    public void printStyleSheetProperties() {
        File stylefile;
        String parent;
        String filename = this.configuration.stylesheetfile;
        filename = filename.length() > 0 ? ((parent = (stylefile = new File(filename)).getParent()) == null ? filename : filename.substring(parent.length() + 1)) : "stylesheet.css";
        filename = this.relativePath + filename;
        this.link("REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"" + filename + "\" " + "TITLE=\"Style\"");
    }

    public boolean isCoreClass(ClassDoc cd) {
        return cd.containingClass() == null || cd.isStatic();
    }

    public void writeAnnotationInfo(PackageDoc packageDoc) {
        this.writeAnnotationInfo((Doc)packageDoc, packageDoc.annotations());
    }

    public void writeAnnotationInfo(ProgramElementDoc doc) {
        this.writeAnnotationInfo((Doc)doc, doc.annotations());
    }

    public boolean writeAnnotationInfo(int indent, Doc doc, Parameter param) {
        return this.writeAnnotationInfo(indent, doc, param.annotations(), false);
    }

    private void writeAnnotationInfo(Doc doc, AnnotationDesc[] descList) {
        this.writeAnnotationInfo(0, doc, descList, true);
    }

    private boolean writeAnnotationInfo(int indent, Doc doc, AnnotationDesc[] descList, boolean lineBreak) {
        List annotations = this.getAnnotations(indent, descList, lineBreak);
        if (annotations.size() == 0) {
            return false;
        }
        this.fontNoNewLine("-1");
        Iterator iter = annotations.iterator();
        while (iter.hasNext()) {
            this.print((String)iter.next());
        }
        this.fontEnd();
        return true;
    }

    private List getAnnotations(int indent, AnnotationDesc[] descList, boolean linkBreak) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < descList.length; ++i) {
            AnnotationTypeDoc annotationDoc = descList[i].annotationType();
            if (!Util.isDocumentedAnnotation((AnnotationTypeDoc)annotationDoc)) continue;
            StringBuffer annotation = new StringBuffer();
            LinkInfoImpl linkInfo = new LinkInfoImpl(29, (Type)annotationDoc);
            linkInfo.label = "@" + annotationDoc.name();
            annotation.append(this.getLink(linkInfo));
            AnnotationDesc.ElementValuePair[] pairs = descList[i].elementValues();
            if (pairs.length > 0) {
                annotation.append('(');
                for (int j = 0; j < pairs.length; ++j) {
                    if (j > 0) {
                        annotation.append(",");
                        if (linkBreak) {
                            annotation.append(DocletConstants.NL);
                            int spaces = annotationDoc.name().length() + 2;
                            for (int k = 0; k < spaces + indent; ++k) {
                                annotation.append(' ');
                            }
                        }
                    }
                    annotation.append(this.getDocLink(29, (MemberDoc)pairs[j].element(), pairs[j].element().name(), false));
                    annotation.append('=');
                    AnnotationValue annotationValue = pairs[j].value();
                    ArrayList<AnnotationValue> annotationTypeValues = new ArrayList<AnnotationValue>();
                    if (annotationValue.value() instanceof AnnotationValue[]) {
                        AnnotationValue[] annotationArray = (AnnotationValue[])annotationValue.value();
                        for (int k = 0; k < annotationArray.length; ++k) {
                            annotationTypeValues.add(annotationArray[k]);
                        }
                    } else {
                        annotationTypeValues.add(annotationValue);
                    }
                    annotation.append(annotationTypeValues.size() == 1 ? "" : "{");
                    Iterator iter = annotationTypeValues.iterator();
                    while (iter.hasNext()) {
                        annotation.append(this.annotationValueToString((AnnotationValue)iter.next()));
                        annotation.append(iter.hasNext() ? "," : "");
                    }
                    annotation.append(annotationTypeValues.size() == 1 ? "" : "}");
                }
                annotation.append(")");
            }
            annotation.append(linkBreak ? DocletConstants.NL : "");
            results.add(annotation.toString());
        }
        return results;
    }

    private String annotationValueToString(AnnotationValue annotationValue) {
        if (annotationValue.value() instanceof Type) {
            Type type = (Type)annotationValue.value();
            if (type.asClassDoc() != null) {
                LinkInfoImpl linkInfo = new LinkInfoImpl(29, type);
                linkInfo.label = (type.asClassDoc().isIncluded() ? type.typeName() : type.qualifiedTypeName()) + type.dimension() + ".class";
                return this.getLink(linkInfo);
            }
            return type.typeName() + type.dimension() + ".class";
        }
        if (annotationValue.value() instanceof AnnotationDesc) {
            List list = this.getAnnotations(0, new AnnotationDesc[]{(AnnotationDesc)annotationValue.value()}, false);
            StringBuffer buf = new StringBuffer();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
            }
            return buf.toString();
        }
        if (annotationValue.value() instanceof MemberDoc) {
            return this.getDocLink(29, (MemberDoc)annotationValue.value(), ((MemberDoc)annotationValue.value()).name(), false);
        }
        return annotationValue.toString();
    }

    public Configuration configuration() {
        return this.configuration;
    }
}

