/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.writers;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.doclets.internal.toolkit.SerializedFormWriter;
import java.io.IOException;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.writers.HtmlSerialFieldWriter;
import net.sourceforge.xhtmldoclet.writers.HtmlSerialMethodWriter;
import net.sourceforge.xhtmldoclet.writers.LinkInfoImpl;
import net.sourceforge.xhtmldoclet.writers.SubWriterHolderWriter;

public class SerializedFormWriterImpl
extends SubWriterHolderWriter
implements SerializedFormWriter {
    private static final String FILE_NAME = "serialized-form.html";

    public SerializedFormWriterImpl() throws IOException {
        super(Config.getInstance(), FILE_NAME);
    }

    public void writeHeader(String header) {
        this.printHtmlHeader(header, null, true);
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.print(header);
        this.h1End();
        this.centerEnd();
    }

    public void writePackageHeader(String packageName) {
        this.hr(4, "noshade");
        this.tableHeader();
        this.thAlign("center");
        this.font("+2");
        this.boldText("doclet.Package");
        this.print(' ');
        this.bold(packageName);
        this.tableFooter();
    }

    public void writeSerialUIDInfo(String header, String serialUID) {
        this.bold(header + "&nbsp;");
        this.println(serialUID);
        this.p();
    }

    public void writeFooter() {
        this.p();
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    public void writeClassHeader(ClassDoc classDoc) {
        String classLink = classDoc.isPublic() || classDoc.isProtected() ? this.getLink(new LinkInfoImpl(classDoc, this.configuration.getClassName(classDoc))) : classDoc.qualifiedName();
        this.p();
        this.anchor(classDoc.qualifiedName());
        String superClassLink = classDoc.superclassType() != null ? this.getLink(new LinkInfoImpl(7, classDoc.superclassType())) : null;
        String className = superClassLink == null ? this.configuration.getText("doclet.Class_0_implements_serializable", classLink) : this.configuration.getText("doclet.Class_0_extends_implements_serializable", classLink, superClassLink);
        this.tableHeader();
        this.thAlignColspan("left", 2);
        this.font("+2");
        this.bold(className);
        this.tableFooter();
        this.p();
    }

    private void tableHeader() {
        this.tableIndexSummary();
        this.trBgcolorStyle("#CCCCFF", "TableSubHeadingColor");
    }

    private void tableFooter() {
        this.fontEnd();
        this.thEnd();
        this.trEnd();
        this.tableEnd();
    }

    public SerializedFormWriter.SerialFieldWriter getSerialFieldWriter(ClassDoc classDoc) {
        return new HtmlSerialFieldWriter(this, classDoc);
    }

    public SerializedFormWriter.SerialMethodWriter getSerialMethodWriter(ClassDoc classDoc) {
        return new HtmlSerialMethodWriter(this, classDoc);
    }
}

