/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.util.AopUtil;
import org.jboss.util.NestedRuntimeException;

public class CachedSetImpl
extends AbstractSet
implements Set {
    protected TreeCacheAop cache_;
    protected AbstractCollectionInterceptor interceptor_;

    public CachedSetImpl(TreeCacheAop cache, AbstractCollectionInterceptor interceptor) {
        this.cache_ = cache;
        this.interceptor_ = interceptor;
    }

    protected DataNode getNode() {
        try {
            return this.cache_.get(this.getFqn());
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    protected Fqn getFqn() {
        return this.interceptor_.getFqn();
    }

    public int size() {
        DataNode node = this.getNode();
        if (node == null) {
            return 0;
        }
        Map children = node.getChildren();
        return children == null ? 0 : children.size();
    }

    public Iterator iterator() {
        Map children = this.getNode().getChildren();
        final Iterator<Object> i = children == null ? Collections.EMPTY_LIST.iterator() : children.keySet().iterator();
        return new Iterator(){
            Object lastKey;
            int size_;
            {
                this.size_ = CachedSetImpl.this.size();
            }

            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                try {
                    this.lastKey = i.next();
                    return CachedSetImpl.this.cache_.getObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), this.lastKey));
                }
                catch (CacheException e) {
                    throw new NestedRuntimeException((Throwable)((Object)e));
                }
            }

            public void remove() {
                try {
                    CachedSetImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedSetImpl.this.getFqn(), this.lastKey));
                }
                catch (CacheException e) {
                    throw new NestedRuntimeException((Throwable)((Object)e));
                }
            }
        };
    }

    public boolean add(Object o) {
        if (this.contains(o)) {
            return false;
        }
        try {
            this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(this.size())), o);
            return true;
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[" + key).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

