/*
 * Decompiled with CFR 0.152.
 */
package beansoft.jsp;

import beansoft.util.OS;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class StringUtil {
    static /* synthetic */ Class class$0;

    public static String escape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        int i = 0;
        while (i < src.length()) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
            } else if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
            } else {
                tmp.append("%u");
                tmp.append(Integer.toString(j, 16));
            }
            ++i;
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String getRealFilePath(String resourcePath) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("beansoft.jsp.StringUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL inputURL = clazz.getResource(resourcePath);
        String filePath = inputURL.getFile();
        if (OS.isWindows() && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    public static int parseInt(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String formatDateToDHMSString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("d\u65e5 HH:mm:ss");
        return dateFormat.format(date);
    }

    public static String formatDateToHMSString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        return dateFormat.format(date);
    }

    public static Date parseHMSStringToDate(String input) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        try {
            return dateFormat.parse(input);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatDateToMysqlString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public static Date parseStringToMysqlDate(String input) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return dateFormat.parse(input);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatDateToMMddHHmm(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("M\u6708d\u65e5 HH:mm");
        return dateFormat.format(date);
    }

    public static String formatDateToyyMMddHHmm(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yy\u5e74M\u6708d\u65e5HH:mm");
        return dateFormat.format(date);
    }

    public static String getReferer(HttpServletRequest request, String defaultPage) {
        String referer = request.getHeader("Referer");
        String refererParam = request.getParameter("referer");
        if (!StringUtil.isEmpty(refererParam)) {
            referer = refererParam;
        }
        if (StringUtil.isEmpty(referer) || referer.indexOf("_action.jsp") != -1) {
            referer = defaultPage;
        }
        return referer;
    }

    public static String genTimeStampString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        return df.format(date);
    }

    public static void writeHtmlBase(PageContext pageContext) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        StringBuffer buf = new StringBuffer("<base href=\"");
        buf.append(request.getScheme());
        buf.append("://");
        buf.append(request.getServerName());
        buf.append(":");
        buf.append(request.getServerPort());
        buf.append(request.getRequestURI());
        buf.append("\">");
        JspWriter out = pageContext.getOut();
        try {
            out.write(buf.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getBasePath(HttpServletRequest request) {
        String path = request.getContextPath();
        String basePath = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        return basePath;
    }

    public static String getFullRequestURL(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String qString = request.getQueryString();
        if (qString != null) {
            url.append('?');
            url.append(qString);
        }
        return url.toString();
    }

    public static String getFullRequestURI(HttpServletRequest request) {
        StringBuffer url = new StringBuffer(request.getRequestURI());
        String qString = request.getQueryString();
        if (qString != null) {
            url.append('?');
            url.append(qString);
        }
        return url.toString();
    }

    public static String replace(String source, String oldStr, String newStr) {
        return StringUtil.replace(source, oldStr, newStr, true);
    }

    public static String replace(String source, String oldStr, String newStr, boolean matchCase) {
        if (source == null) {
            return null;
        }
        if (source.toLowerCase().indexOf(oldStr.toLowerCase()) == -1) {
            return source;
        }
        int findStartPos = 0;
        int a = 0;
        while (a > -1) {
            String strB;
            String strA;
            int b = 0;
            String str1 = source;
            String str2 = str1.toLowerCase();
            String str3 = oldStr;
            String str4 = str3.toLowerCase();
            if (matchCase) {
                strA = str1;
                strB = str3;
            } else {
                strA = str2;
                strB = str4;
            }
            a = strA.indexOf(strB, findStartPos);
            if (a <= -1) continue;
            b = oldStr.length();
            findStartPos = a + b;
            StringBuffer bbuf = new StringBuffer(source);
            source = "" + bbuf.replace(a, a + b, newStr);
            findStartPos = findStartPos + newStr.length() - b;
        }
        return source;
    }

    public static String trimTailSpaces(String input) {
        if (StringUtil.isEmpty(input)) {
            return "";
        }
        String trimedString = input.trim();
        if (trimedString.length() == input.length()) {
            return input;
        }
        return input.substring(0, input.indexOf(trimedString) + trimedString.length());
    }

    public static String clearNull(String input) {
        return StringUtil.isEmpty(input) ? "" : input;
    }

    public static String limitStringLength(String input, int maxLength) {
        if (StringUtil.isEmpty(input)) {
            return "";
        }
        if (input.length() <= maxLength) {
            return input;
        }
        return String.valueOf(input.substring(0, maxLength - 3)) + "...";
    }

    public static String scriptAlert(String message) {
        return "<SCRIPT language=\"JavaScript\">alert(\"" + message + "\");</SCRIPT>";
    }

    public static String scriptRedirect(String url) {
        return "<SCRIPT language=\"JavaScript\">document.location=\"" + url + "\";</SCRIPT>";
    }

    public static String scriptHistoryBack() {
        return "<SCRIPT language=\"JavaScript\">history.back();</SCRIPT>";
    }

    public static String replaceHtmlCode(String content) {
        if (StringUtil.isEmpty(content)) {
            return "";
        }
        String[] eventKeywords = new String[]{"onmouseover", "onmouseout", "onmousedown", "onmouseup", "onmousemove", "onclick", "ondblclick", "onkeypress", "onkeydown", "onkeyup", "ondragstart", "onerrorupdate", "onhelp", "onreadystatechange", "onrowenter", "onrowexit", "onselectstart", "onload", "onunload", "onbeforeunload", "onblur", "onerror", "onfocus", "onresize", "onscroll", "oncontextmenu"};
        content = StringUtil.replace(content, "<script", "&ltscript", false);
        content = StringUtil.replace(content, "</script", "&lt/script", false);
        content = StringUtil.replace(content, "<marquee", "&ltmarquee", false);
        content = StringUtil.replace(content, "</marquee", "&lt/marquee", false);
        int i = 0;
        while (i < eventKeywords.length) {
            content = StringUtil.replace(content, eventKeywords[i], "_" + eventKeywords[i], false);
            ++i;
        }
        return content;
    }

    public static String replaceHtmlToText(String input) {
        if (StringUtil.isEmpty(input)) {
            return "";
        }
        return StringUtil.setBr(StringUtil.setTag(input));
    }

    public static String setTag(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        int i = 0;
        while (i < j) {
            char ch = s.charAt(i);
            if (ch == '<') {
                stringbuffer.append("&lt");
            } else if (ch == '>') {
                stringbuffer.append("&gt");
            } else if (ch == '&') {
                stringbuffer.append("&amp");
            } else if (ch == '%') {
                stringbuffer.append("%%");
            } else {
                stringbuffer.append(ch);
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String setBr(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        int i = 0;
        while (i < j) {
            if (s.charAt(i) != '\n' && s.charAt(i) != '\r') {
                stringbuffer.append(s.charAt(i));
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String setNbsp(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        int i = 0;
        while (i < j) {
            if (s.charAt(i) == ' ') {
                stringbuffer.append("&nbsp;");
            } else {
                stringbuffer.append(String.valueOf(s.charAt(i)));
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static boolean isNumeric(String input) {
        if (StringUtil.isEmpty(input)) {
            return false;
        }
        int i = 0;
        while (i < input.length()) {
            char charAt = input.charAt(i);
            if (!Character.isDigit(charAt)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toChi(String input) {
        try {
            byte[] bytes = input.getBytes("ISO8859-1");
            return new String(bytes, "GBK");
        }
        catch (Exception exception) {
            return input;
        }
    }

    public static String toISO(String input) {
        return StringUtil.changeEncoding(input, "GBK", "ISO8859-1");
    }

    public static String changeEncoding(String input, String sourceEncoding, String targetEncoding) {
        if (input == null || input.equals("")) {
            return input;
        }
        try {
            byte[] bytes = input.getBytes(sourceEncoding);
            return new String(bytes, targetEncoding);
        }
        catch (Exception exception) {
            return input;
        }
    }

    public static String replaceSql(String input) {
        return StringUtil.replace(input, "'", "''");
    }

    public static String encode(String value) {
        if (StringUtil.isEmpty(value)) {
            return "";
        }
        try {
            value = URLEncoder.encode(value, "GB2312");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public static String decode(String value) {
        if (StringUtil.isEmpty(value)) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "GB2312");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return value;
        }
    }

    public static boolean isEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public static int getBytesLength(String input) {
        if (input == null) {
            return 0;
        }
        int bytesLength = input.getBytes().length;
        return bytesLength;
    }

    public static String isEmpty(String input, String errorMsg) {
        if (StringUtil.isEmpty(input)) {
            return errorMsg;
        }
        return "";
    }

    public static String getExtension(String fileName) {
        int i;
        if (fileName != null && (i = fileName.lastIndexOf(46)) > 0 && i < fileName.length() - 1) {
            return fileName.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public static String getPrefix(String fileName) {
        if (fileName != null) {
            int i;
            if ((fileName = fileName.replace('\\', '/')).lastIndexOf("/") > 0) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            }
            if ((i = fileName.lastIndexOf(46)) > 0 && i < fileName.length() - 1) {
                return fileName.substring(0, i);
            }
        }
        return "";
    }

    public static String getShortFileName(String fileName) {
        if (fileName != null) {
            String oldFileName = new String(fileName);
            if ((fileName = fileName.replace('\\', '/')).endsWith("/")) {
                int idx = fileName.indexOf(47);
                if (idx == -1 || idx == fileName.length() - 1) {
                    return oldFileName;
                }
                return oldFileName.substring(idx + 1, fileName.length() - 1);
            }
            if (fileName.lastIndexOf("/") > 0) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            }
            return fileName;
        }
        return "";
    }

    public static String getParameter(HttpServletRequest request, String fieldName) {
        return request.getParameter(fieldName);
    }

    public static String request(HttpServletRequest request, String fieldName) {
        if (request.getMethod().equalsIgnoreCase("POST")) {
            return StringUtil.toChi(request.getParameter(fieldName));
        }
        return StringUtil.toChi(request.getParameter(fieldName));
    }

    public String request1(HttpServletRequest request, String fieldName) {
        String s = StringUtil.request(request, fieldName);
        if (s == null) {
            return "";
        }
        return s;
    }

    public String requestSql(HttpServletRequest request, String fieldName) {
        return StringUtil.replaceSql(this.request1(request, fieldName));
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "";
        }
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            if (cookie.getName().equals(name)) {
                return StringUtil.decode(cookie.getValue());
            }
            ++i;
        }
        return "";
    }

    public String[] getParameterValues(HttpServletRequest request, String name) {
        String encoding = request.getCharacterEncoding();
        if ("GBK".equalsIgnoreCase(encoding) || "GB2312".equalsIgnoreCase(encoding)) {
            return request.getParameterValues(name);
        }
        String[] values = request.getParameterValues(name);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                values[i] = StringUtil.toChi(values[i]);
                ++i;
            }
        }
        return values;
    }

    public static void deleteFile(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtil.isEmpty(filePath) && !StringUtil.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            File file = new File(physicalFilePath);
            file.delete();
        }
    }

    public static boolean createFile(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtil.isEmpty(filePath) && !StringUtil.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            File file = new File(physicalFilePath);
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Unable to create file " + filePath);
            }
        }
        return false;
    }

    public static boolean createDir(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtil.isEmpty(filePath) && !StringUtil.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            try {
                File dir = new File(application.getRealPath(filePath));
                return dir.mkdirs();
            }
            catch (Exception e) {
                System.err.println("Unable to create directory " + filePath);
            }
        }
        return false;
    }

    public static boolean checkFileExists(ServletContext application, String filePath) {
        String physicalFilePath;
        if (!StringUtil.isEmpty(filePath) && !StringUtil.isEmpty(physicalFilePath = application.getRealPath(filePath))) {
            File file = new File(physicalFilePath);
            return file.exists();
        }
        return false;
    }

    public static String getFileIcon(ServletContext application, String iconDirPath, String fileName) {
        String ext = StringUtil.getExtension(fileName);
        String filePath = String.valueOf(iconDirPath) + ext + ".gif";
        if (StringUtil.checkFileExists(application, filePath)) {
            return filePath;
        }
        return String.valueOf(iconDirPath) + "file.gif";
    }

    public static String paging(int page, int recordCount, int pageSize, int pageCountSize, String linkpageurl) {
        int PageCount = -1;
        String LinkPageName = linkpageurl;
        String LinkText = "";
        int TempPage = (page - 1) % pageCountSize;
        int StartPage = page - TempPage;
        int TempPageCount = recordCount % pageSize;
        PageCount = TempPageCount == 0 ? recordCount / pageSize : recordCount / pageSize + 1;
        String txtPrev = " [\u524d" + pageCountSize + "\u9875] ";
        String txtNext = " [\u540e" + pageCountSize + "\u9875] ";
        String txtStart = " [\u9996\u9875] ";
        String txtEnd = " [\u672b\u9875] ";
        LinkText = StartPage - 1 > 0 ? String.valueOf(LinkText) + "<a href='" + LinkPageName + "&page=1' title='\u5230\u6b64\u9875'>" + txtStart + "</a>" : String.valueOf(LinkText) + txtStart;
        LinkText = StartPage - 1 > 0 ? String.valueOf(LinkText) + "<a href='" + LinkPageName + "&page=" + (StartPage - 1) + "' title='\u5230\u7b2c" + pageCountSize + "\u9875'>" + txtPrev + "</a>" : String.valueOf(LinkText) + txtPrev;
        int i = StartPage;
        while (i < StartPage + pageCountSize) {
            if (i < PageCount + 1) {
                LinkText = String.valueOf(LinkText) + "<a href='" + LinkPageName + "&page=";
                LinkText = String.valueOf(LinkText) + i + "' title='" + i + "\u9875'>";
                LinkText = i == page ? String.valueOf(LinkText) + "<b>[" + i + "]</b>" : String.valueOf(LinkText) + "[" + i + "]";
                LinkText = String.valueOf(LinkText) + "</a>";
            }
            ++i;
        }
        LinkText = StartPage + pageCountSize - PageCount - 1 < 0 ? String.valueOf(LinkText) + "<a href='" + LinkPageName + "&page=" + (StartPage + pageCountSize) + "' title='\u5230\u7b2c" + pageCountSize + "\u9875'>" + txtNext + "</a>" : String.valueOf(LinkText) + txtNext;
        LinkText = StartPage + pageCountSize <= PageCount ? String.valueOf(LinkText) + "<a href='" + LinkPageName + "&page=" + PageCount + "' title='\u6700\u540e\u4e00\u9875'>" + txtEnd + "</a>" : String.valueOf(LinkText) + txtEnd;
        return LinkText;
    }

    public static String getPath(String resourceName) {
        URL classUrl;
        if (!resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        if ((classUrl = new StringUtil().getClass().getResource(resourceName)) != null) {
            return classUrl.getFile();
        }
        return null;
    }

    public static String dateToChineseString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        return dateFormat.format(date);
    }

    public static String dateTo14String(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(date);
    }

    public static Date string14ToDate(String input) {
        if (StringUtil.isEmpty(input)) {
            return null;
        }
        if (input.length() != 14) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            return dateFormat.parse(input);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static byte getByte(HttpServletRequest httpservletrequest, String s) {
        if (httpservletrequest.getParameter(s) == null || httpservletrequest.getParameter(s).equals("")) {
            return 0;
        }
        return Byte.parseByte(httpservletrequest.getParameter(s));
    }

    public static int getInt(HttpServletRequest httpservletrequest, String s) {
        if (httpservletrequest.getParameter(s) == null || httpservletrequest.getParameter(s).equals("")) {
            return 0;
        }
        return Integer.parseInt(httpservletrequest.getParameter(s));
    }

    public static long getLong(HttpServletRequest httpservletrequest, String s) {
        if (httpservletrequest.getParameter(s) == null || httpservletrequest.getParameter(s).equals("")) {
            return 0L;
        }
        return Long.parseLong(httpservletrequest.getParameter(s));
    }

    public static short getShort(HttpServletRequest httpservletrequest, String s) {
        if (httpservletrequest.getParameter(s) == null || httpservletrequest.getParameter(s).equals("")) {
            return 0;
        }
        return Short.parseShort(httpservletrequest.getParameter(s));
    }

    public static String textToHtml(String input) {
        if (StringUtil.isEmpty(input)) {
            return "";
        }
        input = StringUtil.replace(input, "<", "&#60;");
        input = StringUtil.replace(input, ">", "&#62;");
        input = StringUtil.replace(input, "\n", "<br>\n");
        input = StringUtil.replace(input, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        input = StringUtil.replace(input, "  ", "&nbsp;&nbsp;");
        return input;
    }

    public static String toQuoteMark(String s) {
        s = StringUtil.replaceString(s, "'", "&#39;");
        s = StringUtil.replaceString(s, "\"", "&#34;");
        s = StringUtil.replaceString(s, "\r\n", "\n");
        return s;
    }

    public static String replaceChar(String s, char c, char c1) {
        if (s == null) {
            return "";
        }
        return s.replace(c, c1);
    }

    public static String replaceString(String s, String s1, String s2) {
        if (s == null || s1 == null || s2 == null) {
            return "";
        }
        return s.replaceAll(s1, s2);
    }

    public static String toHtml(String s) {
        s = StringUtil.replaceString(s, "<", "&#60;");
        s = StringUtil.replaceString(s, ">", "&#62;");
        return s;
    }

    public static String toBR(String s) {
        s = StringUtil.replaceString(s, "\n", "<br>\n");
        s = StringUtil.replaceString(s, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        s = StringUtil.replaceString(s, "  ", "&nbsp;&nbsp;");
        return s;
    }

    public static String toSQL(String s) {
        s = StringUtil.replaceString(s, "\r\n", "\n");
        return s;
    }

    public static String replaceEnter(String s) throws NullPointerException {
        return s.replaceAll("\n", "<br>");
    }

    public static String replacebr(String s) throws NullPointerException {
        return s.replaceAll("<br>", "\n");
    }

    public static String replaceQuote(String s) throws NullPointerException {
        return s.replaceAll("'", "''");
    }

    public static void main(String[] args) throws Exception {
        Date time = StringUtil.parseHMSStringToDate("12:23:00");
        System.out.println(time.toLocaleString());
        Date nowTime = StringUtil.parseHMSStringToDate(StringUtil.formatDateToHMSString(new Date()));
        System.out.println(nowTime.toLocaleString());
    }
}

