/*
 * Decompiled with CFR 0.152.
 */
package beansoft.jsp;

import beansoft.util.OS;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StringUtilExpress {
    static /* synthetic */ Class class$0;

    public static String getRealFilePath(String resourcePath) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("beansoft.jsp.StringUtilExpress");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL inputURL = clazz.getResource(resourcePath);
        String filePath = inputURL.getFile();
        if (OS.isWindows() && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    public static int parseInt(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String formatDateToDHMSString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("d\u65e5 HH:mm:ss");
        return dateFormat.format(date);
    }

    public static String formatDateToHMSString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        return dateFormat.format(date);
    }

    public static Date parseHMSStringToDate(String input) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        try {
            return dateFormat.parse(input);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatDateToMysqlString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public static Date parseStringToMysqlDate(String input) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return dateFormat.parse(input);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatDateToMMddHHmm(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("M\u6708d\u65e5 HH:mm");
        return dateFormat.format(date);
    }

    public static String formatDateToyyMMddHHmm(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yy\u5e74M\u6708d\u65e5HH:mm");
        return dateFormat.format(date);
    }

    public static String genTimeStampString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        return df.format(date);
    }

    public static String replace(String source, String oldStr, String newStr) {
        return StringUtilExpress.replace(source, oldStr, newStr, true);
    }

    public static String replace(String source, String oldStr, String newStr, boolean matchCase) {
        if (source == null) {
            return null;
        }
        if (source.toLowerCase().indexOf(oldStr.toLowerCase()) == -1) {
            return source;
        }
        int findStartPos = 0;
        int a = 0;
        while (a > -1) {
            String strB;
            String strA;
            int b = 0;
            String str1 = source;
            String str2 = str1.toLowerCase();
            String str3 = oldStr;
            String str4 = str3.toLowerCase();
            if (matchCase) {
                strA = str1;
                strB = str3;
            } else {
                strA = str2;
                strB = str4;
            }
            a = strA.indexOf(strB, findStartPos);
            if (a <= -1) continue;
            b = oldStr.length();
            findStartPos = a + b;
            StringBuffer bbuf = new StringBuffer(source);
            source = "" + bbuf.replace(a, a + b, newStr);
            findStartPos = findStartPos + newStr.length() - b;
        }
        return source;
    }

    public static String trimTailSpaces(String input) {
        if (StringUtilExpress.isEmpty(input)) {
            return "";
        }
        String trimedString = input.trim();
        if (trimedString.length() == input.length()) {
            return input;
        }
        return input.substring(0, input.indexOf(trimedString) + trimedString.length());
    }

    public static String clearNull(String input) {
        return StringUtilExpress.isEmpty(input) ? "" : input;
    }

    public static String limitStringLength(String input, int maxLength) {
        if (StringUtilExpress.isEmpty(input)) {
            return "";
        }
        if (input.length() <= maxLength) {
            return input;
        }
        return String.valueOf(input.substring(0, maxLength - 3)) + "...";
    }

    public static String scriptAlert(String message) {
        return "<SCRIPT language=\"JavaScript\">alert(\"" + message + "\");</SCRIPT>";
    }

    public static String scriptRedirect(String url) {
        return "<SCRIPT language=\"JavaScript\">document.location=\"" + url + "\";</SCRIPT>";
    }

    public static String scriptHistoryBack() {
        return "<SCRIPT language=\"JavaScript\">history.back();</SCRIPT>";
    }

    public static String replaceHtmlCode(String content) {
        if (StringUtilExpress.isEmpty(content)) {
            return "";
        }
        String[] eventKeywords = new String[]{"onmouseover", "onmouseout", "onmousedown", "onmouseup", "onmousemove", "onclick", "ondblclick", "onkeypress", "onkeydown", "onkeyup", "ondragstart", "onerrorupdate", "onhelp", "onreadystatechange", "onrowenter", "onrowexit", "onselectstart", "onload", "onunload", "onbeforeunload", "onblur", "onerror", "onfocus", "onresize", "onscroll", "oncontextmenu"};
        content = StringUtilExpress.replace(content, "<script", "&ltscript", false);
        content = StringUtilExpress.replace(content, "</script", "&lt/script", false);
        content = StringUtilExpress.replace(content, "<marquee", "&ltmarquee", false);
        content = StringUtilExpress.replace(content, "</marquee", "&lt/marquee", false);
        content = StringUtilExpress.replace(content, "\r\n", "<BR>");
        int i = 0;
        while (i < eventKeywords.length) {
            content = StringUtilExpress.replace(content, eventKeywords[i], "_" + eventKeywords[i], false);
            ++i;
        }
        return content;
    }

    public static String replaceHtmlToText(String input) {
        if (StringUtilExpress.isEmpty(input)) {
            return "";
        }
        return StringUtilExpress.setBr(StringUtilExpress.setTag(input));
    }

    public static String setTag(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        int i = 0;
        while (i < j) {
            char ch = s.charAt(i);
            if (ch == '<') {
                stringbuffer.append("\u3008");
            } else if (ch == '>') {
                stringbuffer.append("\u3009");
            } else if (ch == '&') {
                stringbuffer.append("\u3003");
            } else if (ch == '%') {
                stringbuffer.append("\u203b");
            } else {
                stringbuffer.append(ch);
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String setBr(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        int i = 0;
        while (i < j) {
            if (s.charAt(i) != '\n' && s.charAt(i) != '\r') {
                stringbuffer.append(s.charAt(i));
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String setNbsp(String s) {
        int j = s.length();
        StringBuffer stringbuffer = new StringBuffer(j + 500);
        int i = 0;
        while (i < j) {
            if (s.charAt(i) == ' ') {
                stringbuffer.append("&nbsp;");
            } else {
                stringbuffer.append(String.valueOf(s.charAt(i)));
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static boolean isNumeric(String input) {
        if (StringUtilExpress.isEmpty(input)) {
            return false;
        }
        int i = 0;
        while (i < input.length()) {
            char charAt = input.charAt(i);
            if (!Character.isDigit(charAt)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toChi(String input) {
        try {
            byte[] bytes = input.getBytes("ISO8859-1");
            return new String(bytes, "GBK");
        }
        catch (Exception exception) {
            return input;
        }
    }

    public static String toISO(String input) {
        return StringUtilExpress.changeEncoding(input, "GBK", "ISO8859-1");
    }

    public static String changeEncoding(String input, String sourceEncoding, String targetEncoding) {
        if (input == null || input.equals("")) {
            return input;
        }
        try {
            byte[] bytes = input.getBytes(sourceEncoding);
            return new String(bytes, targetEncoding);
        }
        catch (Exception exception) {
            return input;
        }
    }

    public static String replaceSql(String input) {
        return StringUtilExpress.replace(input, "'", "''");
    }

    public static String encode(String value) {
        if (StringUtilExpress.isEmpty(value)) {
            return "";
        }
        try {
            value = URLEncoder.encode(value, "GB2312");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public static String decode(String value) {
        if (StringUtilExpress.isEmpty(value)) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "GB2312");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return value;
        }
    }

    public static boolean isEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public static int getBytesLength(String input) {
        if (input == null) {
            return 0;
        }
        int bytesLength = input.getBytes().length;
        return bytesLength;
    }

    public static String isEmpty(String input, String errorMsg) {
        if (StringUtilExpress.isEmpty(input)) {
            return errorMsg;
        }
        return "";
    }

    public static String getExtension(String fileName) {
        int i;
        if (fileName != null && (i = fileName.lastIndexOf(46)) > 0 && i < fileName.length() - 1) {
            return fileName.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public static String getPrefix(String fileName) {
        if (fileName != null) {
            int i;
            if ((fileName = fileName.replace('\\', '/')).lastIndexOf("/") > 0) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            }
            if ((i = fileName.lastIndexOf(46)) > 0 && i < fileName.length() - 1) {
                return fileName.substring(0, i);
            }
        }
        return "";
    }

    public static String getShortFileName(String fileName) {
        if (fileName != null) {
            if ((fileName = fileName.replace('\\', '/')).lastIndexOf("/") > 0) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
            }
            return fileName;
        }
        return "";
    }

    public static String getPath(String resourceName) {
        URL classUrl;
        if (!resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        if ((classUrl = new StringUtilExpress().getClass().getResource(resourceName)) != null) {
            return classUrl.getFile();
        }
        return null;
    }

    public static String dateToChineseString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        return dateFormat.format(date);
    }

    public static String dateTo14String(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(date);
    }

    public static Date string14ToDate(String input) {
        if (StringUtilExpress.isEmpty(input)) {
            return null;
        }
        if (input.length() != 14) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            return dateFormat.parse(input);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String textToHtml(String input) {
        if (StringUtilExpress.isEmpty(input)) {
            return "";
        }
        input = StringUtilExpress.replace(input, "<", "&#60;");
        input = StringUtilExpress.replace(input, ">", "&#62;");
        input = StringUtilExpress.replace(input, "\n", "<br>\n");
        input = StringUtilExpress.replace(input, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        input = StringUtilExpress.replace(input, "  ", "&nbsp;&nbsp;");
        return input;
    }

    public static void main(String[] args) throws Exception {
        Date time = StringUtilExpress.parseHMSStringToDate("12:23:00");
        System.out.println(time.toLocaleString());
        Date nowTime = StringUtilExpress.parseHMSStringToDate(StringUtilExpress.formatDateToHMSString(new Date()));
        System.out.println(nowTime.toLocaleString());
    }
}

