/*
 * Decompiled with CFR 0.152.
 */
package beansoft.util;

import beansoft.jsp.StringUtil;
import beansoft.sql.DatabaseUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class ConnectionFactory {
    private static String password;
    private static String user;
    private static String url;
    private static String driver;
    private static boolean DEBUG;
    private static Properties props;
    private static DataSource dataSource;

    static {
        DEBUG = true;
        props = new Properties();
        dataSource = null;
        ConnectionFactory.loadConfiguration();
    }

    private ConnectionFactory() {
    }

    public static Connection getConnection() {
        try {
            Connection conn = null;
            if (DEBUG) {
                Class.forName(driver);
                conn = DriverManager.getConnection(url, user, password);
            } else {
                conn = ConnectionFactory.setupDataSource().getConnection();
            }
            return conn;
        }
        catch (Exception ex) {
            System.err.println("Error: Unable to get a connection: " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public static void loadConfiguration() {
        try {
            props.load(new ByteArrayInputStream(ConnectionFactory.readConfigurationString().getBytes()));
            DEBUG = Boolean.valueOf(props.getProperty("debug", "true"));
            password = props.getProperty("jdbc.password", null);
            user = props.getProperty("jdbc.user", null);
            url = props.getProperty("jdbc.url", null);
            driver = props.getProperty("jdbc.driver");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveConfiguration() {
        ConnectionFactory.saveConfiguration(ConnectionFactory.getProperties());
    }

    public static String readConfigurationString() {
        try {
            int data;
            FileInputStream fin = new FileInputStream(ConnectionFactory.getConfigurationFilePath());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((data = fin.read()) != -1) {
                bout.write(data);
            }
            bout.close();
            fin.close();
            return bout.toString();
        }
        catch (Exception ex) {
            System.err.println("Unable to load ConnectionFactory.properties:" + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    private static String getConfigurationFilePath() {
        return StringUtil.getRealFilePath("/ConnectionFactory.properties");
    }

    protected static boolean saveConfigurationString(String props) {
        if (props == null || props.length() <= 0) {
            return false;
        }
        try {
            FileWriter out = new FileWriter(ConnectionFactory.getConfigurationFilePath());
            out.write(props);
            out.close();
            return true;
        }
        catch (Exception ex) {
            System.err.println("Unable save configuration string to ConnectionFactory.properties:" + ex);
            ex.printStackTrace();
            return false;
        }
    }

    public static Properties getProperties() {
        return props;
    }

    public static boolean saveConfiguration(Properties props) {
        if (props == null || props.size() <= 0) {
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(ConnectionFactory.getConfigurationFilePath());
            props.store(out, "");
            out.close();
            return true;
        }
        catch (Exception ex) {
            System.err.println("Unable to save ConnectionFactory.properties:" + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public static DataSource setupDataSource() {
        if (dataSource == null) {
            BasicDataSource ds = new BasicDataSource();
            ds.setDriverClassName(driver);
            ds.setUsername(user);
            ds.setPassword(password);
            ds.setUrl(url);
            dataSource = ds;
        }
        return dataSource;
    }

    public static String getDataSourceStats() {
        BasicDataSource bds = (BasicDataSource)ConnectionFactory.setupDataSource();
        StringBuffer info = new StringBuffer();
        info.append("Active connection numbers: " + bds.getNumActive());
        info.append("\n");
        info.append("Idle connection numbers: " + bds.getNumIdle());
        return info.toString();
    }

    public static void shutdownDataSource() {
        BasicDataSource bds = (BasicDataSource)ConnectionFactory.setupDataSource();
        try {
            bds.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void restartDataSource() {
        ConnectionFactory.shutdownDataSource();
        ConnectionFactory.setupDataSource();
    }

    public static void main(String[] args) {
        Connection conn = ConnectionFactory.getConnection();
        DatabaseUtil dbUtil = new DatabaseUtil();
        dbUtil.setConnection(conn);
        System.out.println(dbUtil.getAllCount("SELECT count(*) FROM t_hitcounter"));
        System.out.println(conn);
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn = ConnectionFactory.getConnection();
        System.out.println(conn);
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

