/*
 * Decompiled with CFR 0.152.
 */
package studio.beansoft.syntax.commentclean;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.gjt.sp.jedit.syntax.TokenHandler;
import studio.beansoft.syntax.ModeLoader;
import studio.beansoft.syntax.commentclean.CleanCommentTokenHandler;

public class CommentCleaner
extends JFrame {
    private CleanCommentTokenHandler tokenHandler = new CleanCommentTokenHandler();
    private MyItemListener itemListener = new MyItemListener();
    private JPanel jContentPane = null;
    private JToolBar jToolBar = null;
    private JButton jButtonConvert = null;
    private JCheckBox jCheckBoxCmt1 = null;
    private JCheckBox jCheckBoxCmt2 = null;
    private JCheckBox jCheckBoxCmt3 = null;
    private JCheckBox jCheckBoxCmt4 = null;
    private JTabbedPane jTabbedPane = null;
    private JScrollPane jScrollPane = null;
    private JScrollPane jScrollPane1 = null;
    private JComboBox jComboBoxSyntax = null;
    private JTextArea jTextAreaSource = null;
    private JTextArea jTextAreaOut = null;
    private JCheckBox jCheckBoxLabel = null;
    private JLabel jLabel = null;

    public CommentCleaner() throws HeadlessException {
        this.initialize();
        this.initSyntaxList();
    }

    private void initSyntaxList() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("syntaxList.txt")));
            StringBuffer buff = new StringBuffer();
            int data = 0;
            while ((data = reader.read()) != -1) {
                buff.append((char)data);
            }
            reader.close();
            StringTokenizer token = new StringTokenizer(buff.toString(), "\n");
            while (token.hasMoreElements()) {
                String value = token.nextElement().toString();
                value = value.replaceAll("\n", "");
                value = value.replaceAll("\r", "");
                this.getJComboBoxSyntax().addItem(value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("\u8bed\u8a00:");
            this.jToolBar = new JToolBar();
            this.jToolBar.add(this.getJButtonConvert());
            this.jToolBar.add(this.getJCheckBoxCmt1());
            this.jToolBar.add(this.getJCheckBoxCmt2());
            this.jToolBar.add(this.getJCheckBoxCmt3());
            this.jToolBar.add(this.getJCheckBoxCmt4());
            this.jToolBar.add(this.getJCheckBoxLabel());
            this.jToolBar.add(this.jLabel);
            this.jToolBar.add(this.getJComboBoxSyntax());
        }
        return this.jToolBar;
    }

    private JButton getJButtonConvert() {
        if (this.jButtonConvert == null) {
            this.jButtonConvert = new JButton();
            this.jButtonConvert.setText("\u5f00\u59cb\u6e05\u9664");
            this.jButtonConvert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String language = CommentCleaner.this.getJComboBoxSyntax().getSelectedItem().toString();
                    CommentCleaner.this.tokenHandler.reset();
                    CommentCleaner.this.getJTextAreaOut().setText(CommentCleaner.cleanCodeComment(CommentCleaner.this.getJTextAreaSource().getText(), language, CommentCleaner.this.tokenHandler));
                    CommentCleaner.this.getJTabbedPane().setSelectedIndex(1);
                    CommentCleaner.this.getJTextAreaOut().setCaretPosition(0);
                }
            });
        }
        return this.jButtonConvert;
    }

    private JCheckBox getJCheckBoxCmt1() {
        if (this.jCheckBoxCmt1 == null) {
            this.jCheckBoxCmt1 = new JCheckBox();
            this.jCheckBoxCmt1.setText("\u6ce8\u91ca1(\u591a\u884c)");
            this.jCheckBoxCmt1.addItemListener(this.itemListener);
        }
        return this.jCheckBoxCmt1;
    }

    private JCheckBox getJCheckBoxCmt2() {
        if (this.jCheckBoxCmt2 == null) {
            this.jCheckBoxCmt2 = new JCheckBox();
            this.jCheckBoxCmt2.setText("\u6ce8\u91ca2(\u5355\u884c)");
            this.jCheckBoxCmt2.addItemListener(this.itemListener);
        }
        return this.jCheckBoxCmt2;
    }

    private JCheckBox getJCheckBoxCmt3() {
        if (this.jCheckBoxCmt3 == null) {
            this.jCheckBoxCmt3 = new JCheckBox();
            this.jCheckBoxCmt3.setText("\u6ce8\u91ca3(Javadoc)");
            this.jCheckBoxCmt3.addItemListener(this.itemListener);
        }
        return this.jCheckBoxCmt3;
    }

    private JCheckBox getJCheckBoxCmt4() {
        if (this.jCheckBoxCmt4 == null) {
            this.jCheckBoxCmt4 = new JCheckBox();
            this.jCheckBoxCmt4.setText("\u6ce8\u91ca4");
            this.jCheckBoxCmt4.addItemListener(this.itemListener);
        }
        return this.jCheckBoxCmt4;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("\u539f\u59cb\u4ee3\u7801", null, this.getJScrollPane(), null);
            this.jTabbedPane.addTab("\u7ed3\u679c\u4ee3\u7801", null, this.getJScrollPane1(), null);
        }
        return this.jTabbedPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextAreaSource());
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJTextAreaOut());
        }
        return this.jScrollPane1;
    }

    private JComboBox getJComboBoxSyntax() {
        if (this.jComboBoxSyntax == null) {
            this.jComboBoxSyntax = new JComboBox();
            this.jComboBoxSyntax.setMaximumRowCount(20);
        }
        return this.jComboBoxSyntax;
    }

    private void initialize() {
        this.setSize(572, 389);
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getJContentPane());
        this.setTitle("\u4ee3\u7801\u6ce8\u91ca\u6e05\u9664\u5de5\u5177(\u652f\u6301139 \u79cd\u8bed\u8a00)");
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJToolBar(), "North");
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
        }
        return this.jContentPane;
    }

    private JTextArea getJTextAreaSource() {
        if (this.jTextAreaSource == null) {
            this.jTextAreaSource = new JTextArea();
            this.jTextAreaSource.setText("/**\n\u4f60\u597d\u4e16\u754c!\n* @author BeanSoft\n* @version 1.00 2005-10-17\n*/\npublic class Hello() {\nint a;// \u5355\u884c\u6ce8\u91ca\n/*\n \u591a\u884c\u6ce8\u91ca\n @authour BeanSoft\n */\n void test();\n}\n");
        }
        return this.jTextAreaSource;
    }

    private JTextArea getJTextAreaOut() {
        if (this.jTextAreaOut == null) {
            this.jTextAreaOut = new JTextArea();
        }
        return this.jTextAreaOut;
    }

    private JCheckBox getJCheckBoxLabel() {
        if (this.jCheckBoxLabel == null) {
            this.jCheckBoxLabel = new JCheckBox();
            this.jCheckBoxLabel.setText("\u6807\u7b7e(@author)");
            this.jCheckBoxLabel.addItemListener(this.itemListener);
        }
        return this.jCheckBoxLabel;
    }

    public static String cleanCodeComment(String string, String languageType, CleanCommentTokenHandler tokenHandler) {
        ModeLoader.loadModeCatalog("modes\\catalog", false);
        ModeLoader.parseTokens(string, languageType, (TokenHandler)tokenHandler);
        return tokenHandler.getOutputText();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        CommentCleaner cleaner = new CommentCleaner();
        cleaner.setSize(800, 600);
    }

    private final class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            Object s = e.getSource();
            if (s == CommentCleaner.this.getJCheckBoxCmt1()) {
                CommentCleaner.this.tokenHandler.setComment1Enabled(CommentCleaner.this.getJCheckBoxCmt1().isSelected());
            }
            if (s == CommentCleaner.this.getJCheckBoxCmt2()) {
                CommentCleaner.this.tokenHandler.setComment2Enabled(CommentCleaner.this.getJCheckBoxCmt2().isSelected());
            }
            if (s == CommentCleaner.this.getJCheckBoxCmt3()) {
                CommentCleaner.this.tokenHandler.setComment3Enabled(CommentCleaner.this.getJCheckBoxCmt3().isSelected());
            }
            if (s == CommentCleaner.this.getJCheckBoxCmt4()) {
                CommentCleaner.this.tokenHandler.setComment4Enabled(CommentCleaner.this.getJCheckBoxCmt4().isSelected());
            }
            if (s == CommentCleaner.this.getJCheckBoxLabel()) {
                CommentCleaner.this.tokenHandler.setLableEnabled(CommentCleaner.this.getJCheckBoxLabel().isSelected());
            }
        }
    }
}

