/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.analyser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.set.ListOrderedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageCache {
    private HashMap<String, HashMap<Object, Object>> caches = new HashMap();
    private HashMap<String, ListOrderedSet> setCaches = new HashMap();

    public void cache(String cacheName, Object key, Object value) {
        HashMap<Object, Object> cache = this.caches.get(cacheName);
        if (cache == null) {
            cache = new HashMap();
            this.caches.put(cacheName, cache);
        }
        cache.put(key, value);
    }

    public Object retrieve(String cacheName, Object key) {
        HashMap<Object, Object> cache = this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        return cache.get(key);
    }

    public Map<Object, Object> retrieveCache(String cacheName) {
        return this.caches.get(cacheName);
    }

    public void cacheSetValues(String cacheName, Object[] value) {
        ListOrderedSet hashSet = this.setCaches.get(cacheName);
        if (hashSet == null) {
            hashSet = new ListOrderedSet();
            this.setCaches.put(cacheName, hashSet);
        }
        hashSet.addAll(Arrays.asList(value));
    }

    public ListOrderedSet retrieveSetValues(String cacheName) {
        return this.setCaches.get(cacheName);
    }

    public String toString() {
        ListOrderedSet cache;
        String result = "== Simple caches\n";
        for (String key : this.caches.keySet()) {
            result = result + "  == Key " + key + "\n";
            cache = this.caches.get(key);
            for (Object key2 : cache.keySet()) {
                result = result + "    - " + key2 + " => " + cache.get(key2) + "\n";
            }
        }
        result = result + "== Set caches\n";
        for (String key : this.setCaches.keySet()) {
            result = result + "  == Key " + key + "\n";
            cache = this.setCaches.get(key);
            for (Object entry : cache) {
                result = result + "    - " + entry + "\n";
            }
        }
        return result;
    }

    public String toString(String key) {
        String result = "== Content of cache " + key + "\n";
        HashMap<Object, Object> cache = this.caches.get(key);
        for (Object key2 : cache.keySet()) {
            if (key2 == null) continue;
            result = result + "  key: " + key2.toString() + "\n    value: " + cache.get(key2).toString() + "\n";
        }
        return result;
    }
}

