/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.makumba.Attributes;
import org.makumba.CompositeValidationException;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.NoSuchFieldException;
import org.makumba.NotUniqueException;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.Transaction;
import org.makumba.UnauthenticatedException;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.db.DataHolder;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.TransactionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionImplementation
implements Transaction {
    protected DataDefinitionProvider ddp;
    protected QueryProvider qp;
    protected TransactionProvider tp;
    private Attributes contextAttributes;

    public TransactionImplementation(TransactionProvider tp) {
        this.tp = tp;
        this.ddp = DataDefinitionProvider.getInstance();
    }

    @Override
    public abstract void close();

    @Override
    public abstract void commit();

    @Override
    public abstract void rollback();

    @Override
    public abstract String getName();

    @Override
    public abstract void lock(String var1);

    @Override
    public abstract void unlock(String var1);

    protected abstract int executeUpdate(String var1, String var2, String var3, Object var4);

    @Override
    public void delete(Pointer ptr) {
        DataDefinition ri = this.ddp.getDataDefinition(ptr.getType());
        FieldDefinition fi = ri.getParentField();
        if (fi != null && fi.getType().equals("ptrOne")) {
            this.executeUpdate(this.transformTypeName(fi.getDataDefinition().getName()) + " this", "this." + fi.getName() + "=" + this.getNullConstant(), "this." + fi.getName() + this.getPrimaryKeyName() + "=" + this.getParameterName(), ptr);
        }
        try {
            this.delete1(ptr);
        }
        catch (Throwable e) {
            if (e.getClass().getName().endsWith("ConstraintViolationException")) {
                throw new DBError(e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeWrappedException(e);
        }
    }

    @Override
    public int delete(String from, String where, Object parameters) {
        return this.executeUpdate(from, null, where, parameters);
    }

    @Override
    public abstract Vector<Dictionary<String, Object>> executeQuery(String var1, Object var2, int var3, int var4);

    @Override
    public abstract Vector<Dictionary<String, Object>> executeQuery(String var1, Object var2);

    @Override
    public TransactionProvider getTransactionProvider() {
        return this.tp;
    }

    @Override
    public Pointer insert(String type, Dictionary<String, Object> data) {
        DataHolder dh = new DataHolder(this, data, type);
        dh.checkInsert();
        return dh.insert();
    }

    @Override
    public Vector<Pointer> insert(String type, Collection<Dictionary<String, Object>> data) {
        throw new MakumbaError("not implemented");
    }

    @Override
    public Pointer insert(Pointer base, String field, Dictionary<String, Object> data) {
        FieldDefinition fi = this.ddp.getDataDefinition(base.getType()).getFieldDefinition(field);
        if (fi == null) {
            throw new NoSuchFieldException(this.ddp.getDataDefinition(base.getType()), field);
        }
        if (fi.getType().equals("setComplex")) {
            data.put(fi.getSubtable().getSetOwnerFieldName(), base);
            return this.insert(fi.getSubtable().getName(), data);
        }
        throw new InvalidFieldTypeException(fi, "subset");
    }

    @Override
    public int insertFromQuery(String type, String OQL, Object parameterValues) {
        int i = 0;
        try {
            i = this.insertFromQueryImpl(type, OQL, parameterValues);
        }
        catch (NotUniqueException nue) {
            this.treatNotUniqueException(type, nue);
        }
        return i;
    }

    protected abstract int insertFromQueryImpl(String var1, String var2, Object var3);

    protected abstract StringBuffer writeReadQuery(Pointer var1, Enumeration<String> var2);

    @Override
    public int update(Pointer ptr, Dictionary<String, Object> fieldsToChange) {
        DataHolder dh = new DataHolder(this, fieldsToChange, ptr.getType());
        dh.checkUpdate(ptr);
        int updated = 0;
        try {
            updated = dh.update(ptr);
        }
        catch (NotUniqueException nue) {
            this.treatNotUniqueException(ptr.getType(), nue);
        }
        return updated;
    }

    private void treatNotUniqueException(String type, NotUniqueException nue) {
        DataDefinition dd = this.ddp.getDataDefinition(type);
        CompositeValidationException cve = new CompositeValidationException();
        if (nue.getFields().size() == 1) {
            FieldDefinition fd = dd.getFieldDefinition(nue.getFields().keySet().iterator().next());
            if (fd.getNotUniqueErrorMessage() == null) {
                cve.addException(new NotUniqueException(fd, (Object)nue.getFields().get(fd.getName())));
            } else {
                cve.addException(new NotUniqueException(fd.getNotUniqueErrorMessage()));
            }
        } else {
            for (DataDefinition.MultipleUniqueKeyDefinition m : dd.getMultiFieldUniqueKeys()) {
                if (!CollectionUtils.isEqualCollection(Arrays.asList(m.getFields()), nue.getFields().keySet())) continue;
                cve.addException(new NotUniqueException(m.getErrorMessage()));
            }
        }
        throw cve;
    }

    @Override
    public int update(String from, String set, String where, Object parameters) {
        return this.executeUpdate(from, set, where, parameters);
    }

    @Override
    public Dictionary<String, Object> read(Pointer p, Object flds) {
        Enumeration<String> e = this.extractReadFields(p, flds);
        StringBuffer sb = this.writeReadQuery(p, e);
        Vector<Dictionary<String, Object>> v = this.executeReadQuery(p, sb);
        if (v.size() == 0) {
            return null;
        }
        if (v.size() > 1) {
            throw new MakumbaError("MAKUMBA DATABASE INCOSISTENT: Pointer not unique: " + p);
        }
        Dictionary<String, Object> d = v.elementAt(0);
        Hashtable<String, Object> h = new Hashtable<String, Object>(13);
        Enumeration<String> en = d.keys();
        while (en.hasMoreElements()) {
            String o = en.nextElement();
            h.put(o, d.get(o));
        }
        return h;
    }

    protected Enumeration<String> extractReadFields(Pointer p, Object flds) throws ProgrammerError {
        Enumeration e = null;
        if (flds == null) {
            DataDefinition ri = this.ddp.getDataDefinition(p.getType());
            Vector<String> v = new Vector<String>();
            for (String s : ri.getFieldNames()) {
                if (ri.getFieldDefinition(s).getType().startsWith("set")) continue;
                v.addElement(s);
            }
            e = v.elements();
        } else if (flds instanceof Vector) {
            e = ((Vector)flds).elements();
        } else if (flds instanceof Enumeration) {
            e = (Enumeration)flds;
        } else if (flds instanceof String[]) {
            String[] fl;
            Vector<String> v = new Vector<String>();
            for (String element : fl = (String[])flds) {
                v.addElement(element);
            }
            e = v.elements();
        } else if (flds instanceof String) {
            Vector<String> v = new Vector<String>();
            v.add((String)flds);
            e = v.elements();
        } else {
            throw new ProgrammerError("read() argument must be Enumeration, Vector, String[], String or null");
        }
        return e;
    }

    protected abstract Vector<Dictionary<String, Object>> executeReadQuery(Pointer var1, StringBuffer var2);

    public void delete1(Pointer ptr) {
        String ptrDD = ptr.getType();
        DataDefinition ri = this.ddp.getDataDefinition(ptrDD);
        Object[] param = new Object[]{ptr};
        Vector<String> ptrOnes = new Vector<String>();
        for (String s : ri.getFieldNames()) {
            if (!ri.getFieldDefinition(s).getType().equals("ptrOne")) continue;
            ptrOnes.addElement(s);
        }
        if (ptrOnes.size() > 0) {
            Dictionary<String, Object> d = this.read(ptr, ptrOnes);
            Enumeration<Object> e = d.elements();
            while (e.hasMoreElements()) {
                this.delete((Pointer)e.nextElement());
            }
        }
        for (String string : ri.getFieldNames()) {
            FieldDefinition fi = ri.getFieldDefinition(string);
            if (!fi.getType().startsWith("set")) continue;
            if (fi.getType().equals("setComplex")) {
                Vector<Dictionary<String, Object>> v = this.executeQuery("SELECT pointedType" + this.getPrimaryKeyName() + " as pointedType FROM " + ptr.getType() + " ptr " + this.getSetJoinSyntax() + " ptr." + fi.getName() + " pointedType WHERE ptr" + this.getPrimaryKeyName() + "=" + this.getParameterName(), ptr);
                for (Dictionary<String, Object> dictionary : v) {
                    Pointer p = (Pointer)dictionary.get("pointedType");
                    this.delete1(p);
                }
                this.executeUpdate(this.transformTypeName(fi.getSubtable().getName()) + " this", null, "this." + this.transformTypeName(fi.getSubtable().getFieldDefinition(fi.getSubtable().getSetOwnerFieldName()).getName()) + this.getPrimaryKeyName() + "= " + this.getParameterName(), param);
                continue;
            }
            this.tp.getCRUD().deleteSet(this, ptr, fi);
        }
        this.executeUpdate(this.transformTypeName(ptrDD) + " this", null, "this." + this.getPrimaryKeyName(ptrDD) + "=" + this.getParameterName(), ptr);
    }

    public String getSetJoinSyntax() {
        return ",";
    }

    protected Map<String, Object> paramsToMap(Object args) {
        final Map<String, Object> m = this.paramsToMap1(args);
        if (this.contextAttributes == null) {
            return m;
        }
        return new EasyMap<String, Object>(){

            @Override
            public Object get(Object key) {
                Object o = m.get(key);
                if (o != null) {
                    return o;
                }
                try {
                    o = TransactionImplementation.this.contextAttributes.getAttribute((String)key);
                    if (o == null && TransactionImplementation.this.contextAttributes.hasAttribute("" + key + "_null")) {
                        o = Pointer.Null;
                    }
                    return o;
                }
                catch (UnauthenticatedException e) {
                    throw new RuntimeWrappedException(e);
                }
                catch (LogicException e) {
                    return null;
                }
            }
        };
    }

    protected Map<String, Object> paramsToMap1(Object args) {
        if (args instanceof Map) {
            return (Map)args;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (args == null) {
            return ret;
        }
        if (args instanceof List) {
            args = ((List)args).toArray();
        }
        if (args instanceof Object[]) {
            for (int j = 0; j < args.length; ++j) {
                ret.put("" + (j + 1), args[j]);
            }
            return ret;
        }
        ret.put("1", args);
        return ret;
    }

    protected Object[] treatParam(Object args) {
        if (args == null) {
            return new Object[0];
        }
        if (args instanceof Vector) {
            Vector v = (Vector)args;
            Object[] param = new Object[v.size()];
            v.copyInto(param);
            return param;
        }
        if (args instanceof Object[]) {
            return (Object[])args;
        }
        Object[] p = new Object[]{args};
        return p;
    }

    public String transformTypeName(String name) {
        return name;
    }

    public String getParameterName() {
        return "$1";
    }

    public String getPrimaryKeyName() {
        return "";
    }

    public String getPrimaryKeyName(String ptrDD) {
        return this.ddp.getDataDefinition(ptrDD).getIndexPointerFieldName();
    }

    public abstract String getNullConstant();

    @Override
    public abstract String getDataSource();

    public void setContext(Attributes a) {
        this.contextAttributes = a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EasyMap<K, V>
    implements Map<K, V> {
        EasyMap() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return null;
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<K> keySet() {
            return null;
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
        }

        @Override
        public V remove(Object key) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<V> values() {
            return null;
        }
    }
}

