/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import com.mchange.v2.c3p0.C3P0ProxyStatement;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mysql.jdbc.CommunicationsException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.makumba.DBError;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NameResolver;
import org.makumba.commons.SQLPointer;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.DBConnectionWrapper;
import org.makumba.db.makumba.Query;
import org.makumba.db.makumba.Update;
import org.makumba.db.makumba.sql.NameResolverHook;
import org.makumba.db.makumba.sql.SQLDBConnection;
import org.makumba.db.makumba.sql.SQLUpdate;
import org.makumba.db.makumba.sql.TableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
extends org.makumba.db.makumba.Database {
    Properties connectionConfig = new Properties();
    String url;
    protected static String eng;
    Properties types = new Properties();
    boolean addUnderscore = true;
    Hashtable<String, Vector<Hashtable<String, Object>>> catalog = null;
    private NameResolver nrh = new NameResolverHook(this);
    static final int DESIRED_TRANSACTION_LEVEL = 4;
    static Properties sqlDrivers;
    protected ComboPooledDataSource pooledDataSource;

    public String getEngine() {
        return eng;
    }

    public static String getEngineProperty(String s) {
        return sqlDrivers.getProperty(s);
    }

    public static boolean supportsUTF8() {
        if (!requestUTF8) {
            return false;
        }
        if (sqlDrivers.getProperty(eng + ".utf8") == null) {
            return false;
        }
        if (sqlDrivers.getProperty(eng + ".utf8").equals("true")) {
            return requestUTF8;
        }
        return false;
    }

    public static boolean supportsForeignKeys() {
        if (!requestForeignKeys) {
            return false;
        }
        if (sqlDrivers.getProperty(eng + ".foreignKeys") == null) {
            return false;
        }
        if (sqlDrivers.getProperty(eng + ".foreignKeys").equals("true")) {
            return requestForeignKeys;
        }
        return false;
    }

    @Override
    protected DBConnection makeDBConnection() {
        try {
            return new SQLDBConnection((org.makumba.db.makumba.Database)this, this.tp, (PooledDataSource)this.pooledDataSource);
        }
        catch (CommunicationsException ce) {
            Database.logException((SQLException)((Object)ce));
            throw new DBError(ce, "Communications exception in database connection, make sure the timeout option 'MaxIdleTime' (current value: )" + this.pooledDataSource.getMaxIdleTime() + " s) is smaller than the connection timeout of your database server");
        }
        catch (SQLException e) {
            Database.logException(e);
            throw new DBError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database(Properties p) {
        super(p);
        try {
            if (p.getProperty("encoding") != null && p.getProperty("encoding").equals("utf8")) {
                requestUTF8 = true;
            }
            eng = p.getProperty("#sqlEngine");
            this.url = p.getProperty("jdbc_url") != null ? p.getProperty("jdbc_url") : this.getJdbcUrl(p);
            p.put("jdbc_url", this.url);
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!s.startsWith("sql.")) continue;
                this.connectionConfig.put(s.substring(4), p.getProperty(s).trim());
            }
            String driver = p.getProperty("sql.driver");
            if (p.getProperty("foreignKeys") != null && p.getProperty("foreignKeys").equals("true")) {
                requestForeignKeys = true;
            }
            if (driver == null) {
                driver = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine"));
            }
            if (driver == null) {
                driver = sqlDrivers.getProperty(this.url.substring(5, this.url.indexOf(58, 6)));
            }
            Logger.getLogger("org.makumba.db.init").info("Makumba " + MakumbaSystem.getVersion() + " INIT: " + this.url);
            Class.forName(driver);
            this.pooledDataSource = new ComboPooledDataSource();
            this.pooledDataSource.setDriverClass(driver);
            this.pooledDataSource.setJdbcUrl(this.url);
            this.pooledDataSource.setAcquireIncrement(5);
            this.pooledDataSource.setMaxIdleTime(1800);
            this.pooledDataSource.setProperties(this.connectionConfig);
            DBConnectionWrapper dbcw = (DBConnectionWrapper)this.getDBConnection();
            SQLDBConnection dbc = (SQLDBConnection)dbcw.getWrapped();
            try {
                p.put("sql_engine.name", dbc.getMetaData().getDatabaseProductName().trim());
                p.put("sql_engine.version", dbc.getMetaData().getDatabaseProductVersion().trim());
                p.put("jdbc_driver.name", dbc.getMetaData().getDriverName().trim());
                p.put("jdbc_driver.version", dbc.getMetaData().getDriverVersion().trim());
                Logger.getLogger("org.makumba.db.init").info("\tconnected to " + p.get("sql_engine.name") + " version: " + p.get("sql_engine.version") + "\n\tusing " + p.get("jdbc_driver.name") + " version: " + p.get("jdbc_driver.version") + "\n\tusing " + (this.isAutoIncrement() ? "auto increment (no DBSV)" : "DBSV " + p.get("dbsv")));
                if (!dbc.getMetaData().supportsTransactionIsolationLevel(4)) {
                    Logger.getLogger("org.makumba.db.init").warning("transaction isolation level 4 not supported, using " + dbc.getMetaData().getDefaultTransactionIsolation());
                }
                this.readCatalog(dbc);
            }
            finally {
                dbcw.close();
            }
        }
        catch (Exception e) {
            throw new MakumbaError(e);
        }
    }

    @Override
    protected void closeResourcePool() {
        this.pooledDataSource.close();
    }

    @Override
    protected int getResourcePoolSize() {
        try {
            return this.pooledDataSource.getNumConnectionsDefaultUser();
        }
        catch (SQLException e) {
            Database.logException(e);
            return -1;
        }
    }

    @Override
    protected int getIdleConnections() {
        try {
            return this.pooledDataSource.getNumIdleConnectionsDefaultUser();
        }
        catch (SQLException e) {
            Database.logException(e);
            return -1;
        }
    }

    @Override
    protected int getOpenedConnections() {
        try {
            return this.pooledDataSource.getNumBusyConnectionsDefaultUser();
        }
        catch (SQLException e) {
            Database.logException(e);
            return -1;
        }
    }

    @Override
    protected DBConnection getPooledDBConnection() {
        return this.makeDBConnection();
    }

    protected void readCatalog(SQLDBConnection dbc) throws SQLException {
        SQLException ex = null;
        Hashtable c = new Hashtable();
        boolean failed = false;
        try {
            ResultSet rs = dbc.getMetaData().getColumns(null, null, "%", null);
            if (rs == null) {
                failed = true;
            } else {
                while (rs.next()) {
                    String tn = rs.getString("TABLE_NAME");
                    Vector<Hashtable<String, Object>> v = (Vector<Hashtable<String, Object>>)c.get(tn);
                    if (v == null) {
                        v = new Vector<Hashtable<String, Object>>();
                        c.put(tn, v);
                    }
                    Hashtable<String, Object> h = new Hashtable<String, Object>(5);
                    h.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                    h.put("DATA_TYPE", new Integer(rs.getInt("DATA_TYPE")));
                    h.put("TYPE_NAME", rs.getString("TYPE_NAME"));
                    h.put("COLUMN_SIZE", new Integer(rs.getInt("COLUMN_SIZE")));
                    h.put("IS_NULLABLE", rs.getString("IS_NULLABLE"));
                    v.addElement(h);
                }
            }
            rs.close();
        }
        catch (SQLException e) {
            failed = true;
            ex = e;
        }
        if (failed) {
            Logger.getLogger("org.makumba.db.init").severe("failed to read catalog " + ex);
        } else {
            this.catalog = c;
        }
    }

    protected String getJdbcUrl(Properties p) {
        String _url = "jdbc:";
        _url = _url + eng + ":";
        String local = Database.getEngineProperty(eng + ".localJDBC");
        if (local == null || !local.equals("true")) {
            _url = _url + "//" + p.getProperty("#host") + "/";
        }
        return _url + p.getProperty("#database") + (Database.supportsUTF8() ? "?useEncoding=true&characterEncoding=UTF-8" : "");
    }

    @Override
    public Query prepareQueryImpl(String oqlQuery, String insertIn) {
        return new org.makumba.db.makumba.sql.Query(this, oqlQuery, insertIn);
    }

    @Override
    public Update prepareUpdateImpl(String type, String set, String where) {
        return new SQLUpdate(this, type, set, where);
    }

    @Override
    public int getMinPointerValue() {
        return this.getDbsv() << SQLPointer.getMaskOrder();
    }

    @Override
    public int getMaxPointerValue() {
        return (this.getDbsv() + 1 << SQLPointer.getMaskOrder()) - 1;
    }

    @Override
    protected Class<?> getTableClassConfigured() {
        try {
            String tcs = this.getConfiguration("table_class");
            if (tcs != null || (tcs = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + "." + "table_class")) != null) {
                return Class.forName(tcs);
            }
            return this.getTableClass();
        }
        catch (Exception e) {
            throw new MakumbaError(e);
        }
    }

    protected Class<?> getTableClass() {
        return TableManager.class;
    }

    public static String SQLEscape(String s) {
        StringBuffer sb = new StringBuffer("'");
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                sb.append('\\');
            } else if (c == '\\') {
                sb.append('\\');
            } else if (c == '\"') {
                sb.append('\\');
            } else if (c == '\u0000') {
                sb.append("\\0");
                continue;
            }
            sb.append(c);
        }
        sb.append('\'');
        return sb.toString();
    }

    protected void checkState(SQLException e, String state) {
        this.checkState(e, state, null);
    }

    protected void checkState(SQLException e, String state, String command) {
        state = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + "." + state);
        if (state != null && e.getSQLState().equals(state)) {
            return;
        }
        Logger.getLogger("org.makumba.db.init.tablechecking").log(Level.SEVERE, "" + e.getSQLState(), e);
        throw new DBError(e, command);
    }

    protected int exec(PreparedStatement ps) {
        try {
            Logger.getLogger("org.makumba.db.update.execution").fine(this.getWrappedStatementToString(ps));
            ps.execute();
            int n = ps.getUpdateCount();
            ps.close();
            return n;
        }
        catch (SQLException e) {
            if (this.isDuplicateException(e)) {
                return -1;
            }
            Database.logException(e);
            throw new DBError(e);
        }
    }

    @Override
    public boolean isDuplicateException(SQLException e) {
        return e.getMessage().toLowerCase().indexOf("duplicate") != -1;
    }

    @Override
    public Map<String, String> getDuplicateFields(SQLException e) {
        throw new MakumbaError("Method not implemented for this database driver, please contact the developers");
    }

    public boolean isForeignKeyViolationException(SQLException se) {
        return se.getMessage().toLowerCase().contains("a foreign key constraint fails");
    }

    static void logException(SQLException e) {
        Database.logException(e, null);
    }

    static void logException(SQLException e, DBConnection dbc) {
        Database.logException(e, dbc, Level.WARNING);
    }

    static void logException(SQLException e, DBConnection dbc, Level lev) {
        if (!Logger.getLogger("org.makumba.db.exception").isLoggable(lev)) {
            return;
        }
        String log = "";
        if (dbc != null) {
            log = dbc.toString() + " ";
        }
        for (SQLException se1 = e; se1 != null; se1 = se1.getNextException()) {
            log = log + se1.getMessage() + " SQL state: " + se1.getSQLState() + " error code :" + se1.getErrorCode() + "\n";
        }
        Logger.getLogger("org.makumba.db.exception").log(lev, "" + log);
    }

    @Override
    public String OQLDate(Date d) {
        return "date\"" + new Timestamp(d.getTime()) + "\"";
    }

    @Override
    public Pointer getPointer(String type, int uid) {
        return new SQLPointer(type, this.getDbsv(), uid);
    }

    public boolean supportsLimitInQuery() {
        return true;
    }

    public String getLimitSyntax() {
        return "LIMIT ?, ?";
    }

    public boolean isLimitOffsetFirst() {
        return true;
    }

    public String parseReadableForeignKeyErrorMessage(SQLException se) {
        return se.getMessage();
    }

    public NameResolver getNameResolverHook() {
        return this.nrh;
    }

    public String getWrappedStatementToString(PreparedStatement ps) {
        String sql = "";
        try {
            C3P0ProxyStatement c3p0Stmt = (C3P0ProxyStatement)ps;
            Method toStringMethod = Object.class.getMethod("toString", new Class[0]);
            Object toStr = c3p0Stmt.rawStatementOperation(toStringMethod, C3P0ProxyStatement.RAW_STATEMENT, new Object[0]);
            if (sql instanceof String) {
                sql = (String)toStr;
                sql = sql.substring(sql.indexOf(45) + 1).trim() + ";";
                return sql;
            }
        }
        catch (Throwable e) {
            return "Exception extracting SQL: " + e.getMessage();
        }
        return null;
    }

    static {
        sqlDrivers = new Properties();
        try {
            sqlDrivers.load(ClassResource.get("org/makumba/db/makumba/sql/sqlEngines.properties").openStream());
        }
        catch (Exception e) {
            throw new MakumbaError(e);
        }
    }
}

